<?php
class moc_detect{
	
	public static function getBrowser(){ 
		$u_agent = $_SERVER['HTTP_USER_AGENT']; 
		$bname = 'Unknown';
		$platform = 'Unknown';
		$version= "";

		//First get the platform?
		if (preg_match('/linux/i', $u_agent)) {
			$platform = 'linux';
		}
		elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
			$platform = 'mac';
		}
		elseif (preg_match('/windows|win32/i', $u_agent)) {
			$platform = 'windows';
		}
		
		// Next get the name of the useragent yes seperately and for good reason
		if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)) 
		{ 
			$bname = 'Internet Explorer'; 
			$ub = "MSIE"; 
		} 
		elseif(preg_match('/Firefox/i',$u_agent)) 
		{ 
			$bname = 'Mozilla Firefox'; 
			$ub = "Firefox"; 
		} 
		elseif(preg_match('/Chrome/i',$u_agent)) 
		{ 
			$bname = 'Google Chrome'; 
			$ub = "Chrome"; 
		} 
		elseif(preg_match('/Safari/i',$u_agent)) 
		{ 
			$bname = 'Apple Safari'; 
			$ub = "Safari"; 
		} 
		elseif(preg_match('/Opera/i',$u_agent)) 
		{ 
			$bname = 'Opera'; 
			$ub = "Opera"; 
		} 
		elseif(preg_match('/Netscape/i',$u_agent)) 
		{ 
			$bname = 'Netscape'; 
			$ub = "Netscape"; 
		} 
		
		// finally get the correct version number
		$known = array('Version', $ub, 'other');
		$pattern = '#(?<browser>' . join('|', $known) .
		')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
		if (!preg_match_all($pattern, $u_agent, $matches)) {
			// we have no matching number just continue
		}
		
		// see how many we have
		$i = count($matches['browser']);
		if ($i != 1) {
			//we will have two since we are not using 'other' argument yet
			//see if version is before or after the name
			if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
				$version= $matches['version'][0];
			}
			else {
				$version= $matches['version'][1];
			}
		}
		else {
			$version= $matches['version'][0];
		}
		
		// check if we have a number
		if ($version==null || $version=="") {$version="?";}
		
		return array(
			'userAgent' => $u_agent,
			'name'      => $bname,
			'version'   => $version,
			'platform'  => $platform,
			'pattern'    => $pattern
		);
	}
	
	public static function get_client_ip() {
		$ipaddress = '';
		if (isset($_SERVER['HTTP_CLIENT_IP']))
			$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
		else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
			$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
		else if(isset($_SERVER['HTTP_X_FORWARDED']))
			$ipaddress = $_SERVER['HTTP_X_FORWARDED'];
		else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
			$ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
		else if(isset($_SERVER['HTTP_FORWARDED']))
			$ipaddress = $_SERVER['HTTP_FORWARDED'];
		else if(isset($_SERVER['REMOTE_ADDR']))
			$ipaddress = $_SERVER['REMOTE_ADDR'];
		else
			$ipaddress = 'UNKNOWN';
		return $ipaddress;
	}
	
	public static function ip_info($ip = NULL, $purpose = "location", $deep_detect = TRUE) {
		$output = NULL;
		if (filter_var($ip, FILTER_VALIDATE_IP) === FALSE) {
			$ip = $_SERVER["REMOTE_ADDR"];
			if ($deep_detect) {
				if (filter_var(@$_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP))
					$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
				if (filter_var(@$_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP))
					$ip = $_SERVER['HTTP_CLIENT_IP'];
			}
		}
		$purpose    = str_replace(array("name", "\n", "\t", " ", "-", "_"), NULL, strtolower(trim($purpose)));
		$support    = array("country", "countrycode", "state", "region", "city", "location", "address");
		$continents = array(
			"AF" => "Africa",
			"AN" => "Antarctica",
			"AS" => "Asia",
			"EU" => "Europe",
			"OC" => "Australia (Oceania)",
			"NA" => "North America",
			"SA" => "South America"
		);
		if (filter_var($ip, FILTER_VALIDATE_IP) && in_array($purpose, $support)) {
			$ipdat = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip));
			if (@strlen(trim($ipdat->geoplugin_countryCode)) == 2) {
				switch ($purpose) {
					case "location":
						$output = array(
							"city"           => @$ipdat->geoplugin_city,
							"state"          => @$ipdat->geoplugin_regionName,
							"country"        => @$ipdat->geoplugin_countryName,
							"country_code"   => @$ipdat->geoplugin_countryCode,
							"continent"      => @$continents[strtoupper($ipdat->geoplugin_continentCode)],
							"continent_code" => @$ipdat->geoplugin_continentCode
						);
						break;
					case "address":
						$address = array($ipdat->geoplugin_countryName);
						if (@strlen($ipdat->geoplugin_regionName) >= 1)
							$address[] = $ipdat->geoplugin_regionName;
						if (@strlen($ipdat->geoplugin_city) >= 1)
							$address[] = $ipdat->geoplugin_city;
						$output = implode(", ", array_reverse($address));
						break;
					case "city":
						$output = @$ipdat->geoplugin_city;
						break;
					case "state":
						$output = @$ipdat->geoplugin_regionName;
						break;
					case "region":
						$output = @$ipdat->geoplugin_regionName;
						break;
					case "country":
						$output = @$ipdat->geoplugin_countryName;
						break;
					case "countrycode":
						$output = @$ipdat->geoplugin_countryCode;
						break;
				}
			}
		}
		return $output;
	}
	
	public static function systemInfo(){
		$user_agent = $_SERVER['HTTP_USER_AGENT'];
		$os_platform    = "Unknown OS Platform";
		$os_array       = array('/windows phone 8/i'    =>  'Windows Phone 8',
								'/windows phone os 7/i' =>  'Windows Phone 7',
								'/windows nt 6.3/i'     =>  'Windows 8.1',
								'/windows nt 6.2/i'     =>  'Windows 8',
								'/windows nt 6.1/i'     =>  'Windows 7',
								'/windows nt 6.0/i'     =>  'Windows Vista',
								'/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
								'/windows nt 5.1/i'     =>  'Windows XP',
								'/windows xp/i'         =>  'Windows XP',
								'/windows nt 5.0/i'     =>  'Windows 2000',
								'/windows me/i'         =>  'Windows ME',
								'/win98/i'              =>  'Windows 98',
								'/win95/i'              =>  'Windows 95',
								'/win16/i'              =>  'Windows 3.11',
								'/macintosh|mac os x/i' =>  'Mac OS X',
								'/mac_powerpc/i'        =>  'Mac OS 9',
								'/linux/i'              =>  'Linux',
								'/ubuntu/i'             =>  'Ubuntu',
								'/iphone/i'             =>  'iPhone',
								'/ipod/i'               =>  'iPod',
								'/ipad/i'               =>  'iPad',
								'/android/i'            =>  'Android',
								'/blackberry/i'         =>  'BlackBerry',
								'/webos/i'              =>  'Mobile');
		$found = false;
		//$addr = new RemoteAddress;
		$device = '';
		foreach ($os_array as $regex => $value) 
		{ 
			if($found)
			 break;
			else if (preg_match($regex, $user_agent)) 
			{
				$os_platform    =   $value;
				$device = !preg_match('/(windows|mac|linux|ubuntu)/i',$os_platform)
						  ?'MOBILE':(preg_match('/phone/i', $os_platform)?'MOBILE':'SYSTEM');
			}
		}
		$device = !$device? 'SYSTEM':$device;
		return array('os'=>$os_platform,'device'=>$device);
	}

	public static function browser(){
		$user_agent = $_SERVER['HTTP_USER_AGENT'];

		$browser        =   "Unknown Browser";

		$browser_array  = array('/msie/i'       =>  'Internet Explorer',
								'/firefox/i'    =>  'Firefox',
								'/safari/i'     =>  'Safari',
								'/chrome/i'     =>  'Chrome',
								'/opera/i'      =>  'Opera',
								'/netscape/i'   =>  'Netscape',
								'/maxthon/i'    =>  'Maxthon',
								'/konqueror/i'  =>  'Konqueror',
								'/mobile/i'     =>  'Handheld Browser');
		$found = false;
		foreach ($browser_array as $regex => $value) 
		{ 
			if($found)
			 break;
			else if (preg_match($regex, $user_agent,$result)) 
			{
				$browser    =   $value;
				$found = true;
			}
		}
		return $browser;
	}
}

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://motothemes.net/
 * @since      1.0.0
 *
 * @package    Moto_Chat
 * @subpackage Moto_Chat/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Moto_Chat
 * @subpackage Moto_Chat/public
 * @author     motothemes <admin@motothemes.net>
 */
class Moto_Chat_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Moto_Chat_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Moto_Chat_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Moto_Chat_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Moto_Chat_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		global $post;
		
		$settings = get_option('__moto_chat__settings__');  
		
		if(isset($settings['general_settings']) && !empty($settings['general_settings'])) extract($settings['general_settings']); 
		if( isset($moc_select_page) && ($moc_select_page == $post->ID || $moc_select_page == 'all' ) ){
			wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/moto-chat-public.css', array(), $this->version, 'all' );
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/moto-chat-public.js', array( 'jquery' ), $this->version, false );
			
			wp_localize_script( $this->plugin_name, 'moc_obj', array( 
					'ajax_url' => admin_url( 'admin-ajax.php' ),
				)
			);
		}
	}
	
	public function footer(){
		
		global $post;
		
		$settings = get_option('__moto_chat__settings__');  
		
		if(isset($settings['general_settings']) && !empty($settings['general_settings'])) extract($settings['general_settings']); 
		if( isset($moc_select_page) && ($moc_select_page == $post->ID || $moc_select_page == 'all' ) ){
			$footer = true;
		
			$ip = moc_detect::get_client_ip(); 
			$details = moc_detect::systemInfo();
			$browser = moc_detect::getBrowser();
			$ip_info = moc_detect::ip_info($ip);
			
			$info = base64_encode( json_encode( array( 'ip' => $ip, 'systemInfo' => $details, 'getBrowser' => $browser, 'ip_info' => $ip_info ) ) );
			
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/moto-chat-public-display.php';
		}
	}

	public function body_class( $classes ){
		$classes[] = 'moc_chat_win';
		return $classes;
	}
	
	public function moc_connectchat(){
		if(isset($_POST['action']) && $_POST['action'] == 'moc_connectchat'){
			global $wpdb;
			$prefix = $wpdb->prefix;
			$table = $prefix . "chat_user";
			
			$info = base64_decode($_POST['info']);
			$array = array(
				'name' => $_POST['name'],
				'email' => $_POST['email'],
				'role' => $_POST['role'],
				'info' => $info,
				'date' => date('Y-m-d H:i:s')
			);
			
			$wpdb->insert( $table, $array ); 
			$customer_id = $wpdb->insert_id;
			
			$agent_id = $wpdb->get_var( "SELECT user_id FROM $table WHERE role = 'agent'" );			
			
			if(!empty($agent_id)){
				$table_mess = $prefix . "chat_mess";
				$array = array(
					'user_from' => $customer_id,
					'user_to' => $agent_id,
					'msg' => $_POST['msg'],
					'date' => date('Y-m-d H:i:s')
				);
				$wpdb->insert( $table_mess, $array ); 
				
				echo json_encode( array( 
						'status' => 1, 
						'customer_id' => $customer_id,
						'msg_id' => $wpdb->msg_id,
						'agent_id' => $agent_id, 
						'msg' => $_POST['msg'],
						'c_name' => get_first_letter( $_POST['name'] ),
						'a_name' => 'A'
					) 
				);
				
				$settings = get_option('__moto_chat__settings__');
				
				if(isset($settings['general_settings']) && !empty($settings['general_settings'])) extract($settings['general_settings']); 
				
				if(isset($moc_firebase_api_key) && !empty($moc_firebase_api_key)){
					$this->sendpushnotification( $moc_firebase_api_key );
				}
				
			}else{
				echo json_encode( array( 'status' => 0, 'msg' => 'Agent is offline.' ) );
			}
			
		}
		die();
	}
	
	public function sendpushnotification( $firebase_api ){
		define( 'FIREBASE_API_KEY', $firebase_api );
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'api/notify/firebase.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'api/notify/push.php';
		
		$firebase = new Firebase();
		$push = new Push();
		$title = $_POST['name'];
		$message = $_POST['msg'];
		$push->setTitle($title);
		$push->setMessage($message);
		
		$json = $push->getPush();
		$body = $push->getBodyPush();
		
		$userID = get_option('moc_mobile_agentID');
		$regId = get_user_meta( $userID, 'moc_mobile_push_token', true );
		if(empty($regId)) return '';
		
		$response = $firebase->send($regId, $json, $body);
	}
	
	public function sendmessage(){
		if(isset($_POST['action']) && $_POST['action'] == 'sendmessage'){
			global $wpdb;
			$prefix = $wpdb->prefix;
			
			$user_from = $_POST['user_from'];
			$user_to = $_POST['user_to'];
			$user_msg = $_POST['user_msg'];
			$table_mess = $prefix . "chat_mess";
			$array = array(
				'user_from' => $user_from,
				'user_to' => $user_to,
				'msg' => $user_msg,
				'deliver' => 0,
				'date' => date('Y-m-d H:i:s')
			);
			
			$wpdb->insert( $table_mess, $array ); 
			$msg_id = $wpdb->insert_id;
			echo json_encode( array( 'status' => 1, 'msg' => $user_msg, 'msg_id' => $msg_id, 'cust_id' => $user_to ) );
			
			$settings = get_option('__moto_chat__settings__');
				
			if(isset($settings['general_settings']) && !empty($settings['general_settings'])) extract($settings['general_settings']); 
			
			if(isset($moc_firebase_api_key) && !empty($moc_firebase_api_key)){
				
				$table = $prefix . "chat_user";
				
				$name = $wpdb->get_var( "SELECT name FROM $table WHERE user_id = $user_from" );

				$_POST['name'] = $name;
				$_POST['msg'] = $user_msg;
				
				$this->sendpushnotification( $moc_firebase_api_key );
			}
			
		}
		die();
	}
	
	public function receivemessage(){
		if(isset($_POST['action']) && $_POST['action'] == 'receivemessage'){
			global $wpdb;
			$prefix = $wpdb->prefix;
						
			$table_mess = $prefix . "chat_mess";
			$table_user = $prefix . "chat_user";
			$lastid = $_POST['last_msgid'];
			$user_to = $_POST['cust_id'];
			$str = $lastid == '' ? '' : "&& $table_mess.msg_id > $lastid && deliver = 0";
			$sql = "SELECT * FROM $table_mess WHERE $table_mess.user_to = ".$user_to." $str";
			$chatdata = $wpdb->get_results( $sql );
			
			for($i=0;$i<count($chatdata);$i++){
				$wpdb->update( $table_mess, array('deliver'=>1), array('msg_id'=>$chatdata[$i]->msg_id) ); 	
			}
			
			$udata = array(
				'is_type_cust' => $_POST['is_type']
			);
			$uwhere = array(
				'user_id' => $user_to
			);
			$wpdb->update( $table_user, $udata, $uwhere ); 
			
			$is_type = $wpdb->get_var( "SELECT is_type_agent FROM $table_user WHERE user_id = $user_to" );
			
			echo json_encode( array( 'status' => 1, 'data' => $chatdata, 'is_type' => $is_type ) );
		}
		die();	
	}

}
