<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://kamleshyadav.com/templatemonster/jyotish-astrologer/demo1/
 * @since             1.0.0
 * @package           Moto_Chat
 *
 * @wordpress-plugin
 * Plugin Name:       Pixel Chat
 * Plugin URI:        https://kamleshyadav.com/templatemonster/jyotish-astrologer/demo1/
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Pixelnx
 * Author URI:        https://kamleshyadav.com/templatemonster/jyotish-astrologer/demo1/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       moto-chat
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'PLUGIN_NAME_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-moto-chat-activator.php
 */
function activate_moto_chat() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-moto-chat-activator.php';
	Moto_Chat_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-moto-chat-deactivator.php
 */
function deactivate_moto_chat() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-moto-chat-deactivator.php';
	Moto_Chat_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_moto_chat' );
register_deactivation_hook( __FILE__, 'deactivate_moto_chat' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-moto-chat.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_moto_chat() {

	$plugin = new Moto_Chat();
	$plugin->run();

}
run_moto_chat();

function get_first_letter( $str ){
	$acronym = "";
	if(!empty($str)){
		$words = explode(" ", $str);
	
		foreach ($words as $w) {
			$acronym .= isset($w[0]) ? $w[0] : '';
		}
	}
	return $acronym;
}
