<?php

/**
 * Fired during plugin activation
 *
 * @link       https://motothemes.net/
 * @since      1.0.0
 *
 * @package    Moto_Chat
 * @subpackage Moto_Chat/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Moto_Chat
 * @subpackage Moto_Chat/includes
 * @author     motothemes <admin@motothemes.net>
 */
class Moto_Chat_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		global $wpdb;

		$prefix = $wpdb->prefix;
		
		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE IF NOT EXISTS `".$prefix."chat_user` (
			`user_id` int(11) NOT NULL AUTO_INCREMENT,
			`name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
			`email` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
			`role` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
			`info` text,
			`is_type_cust` tinyint,
			`is_type_agent` tinyint,
			`date` datetime,
			PRIMARY KEY  (user_id),
			KEY (user_id)
		)$charset_collate;";

		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

		dbDelta($sql);
		
		$array = array(
			'name' => 'Agent',
			'email' => 'agent@gmail.com',
			'role' => 'agent',
			'info' => '',
			'date' => date('Y-m-d H:i:s')
		);
		
		$wpdb->insert( $prefix."chat_user", $array ); 

		$sql = "CREATE TABLE IF NOT EXISTS `".$prefix."chat_mess` (
			`msg_id` int(11) NOT NULL AUTO_INCREMENT,
			`user_from` int(11),
			`user_to` int(11),
			`msg` text,
			`deliver` tinyint default 0,
			`date` datetime,
			PRIMARY KEY  (msg_id),
			KEY (msg_id)
		)$charset_collate;";	

		dbDelta($sql);

	}

}
