<?php
/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       https://#
 * @since      1.0.0
 *
 * @package    Gpt_Sniper
 * @subpackage Gpt_Sniper/public/partials
 */
$chatbot_custom_setting = json_decode(get_option('gpt_chatbot_custom_setting'),true);
$position = '';
if(isset($chatbot_custom_setting['chatbot_position']) && $chatbot_custom_setting['chatbot_position']=='left_side'):
    $position = 'gpt-chatbot-left gpt-chat-has-position';
elseif(isset($chatbot_custom_setting['chatbot_position']) && $chatbot_custom_setting['chatbot_position']=='right_side'):
    $position = 'gpt-chatbot-right gpt-chat-has-position';
else:
    $position = '';
endif;
?> 
<div class="gpt-chatbot-wrap <?php echo esc_attr($position); ?> <?php if(!empty($atts['title'])): echo "gpt-chat-has-title"; endif; ?>">
    <!-- Chat Boat Icon  -->
    <div class="gpt-chatbot-icon">
        <div class="gpt-chatbot-icon-inner">
             <svg xmlns="http://www.w3.org/2000/svg"  x="0" y="0" viewBox="0 0 512 512" xml:space="preserve"><g><path d="M477 252h-5v150h5c19.299 0 35-15.701 35-35v-80c0-19.299-15.701-35-35-35zM0 287v80c0 19.299 15.701 35 35 35h5V252h-5c-19.299 0-35 15.701-35 35zM387 182H125c-30.376 0-55 24.624-55 55v180c0 30.376 24.624 55 55 55h167.055l66.503 38.001c10 5.714 22.442-1.506 22.442-13.024V472h6c30.376 0 55-24.624 55-55V237c0-30.376-24.624-55-55-55zM171 287c0 8.284-6.716 15-15 15s-15-6.716-15-15c0-24.813 20.187-45 45-45s45 20.187 45 45c0 8.284-6.716 15-15 15s-15-6.716-15-15c0-8.271-6.729-15-15-15s-15 6.729-15 15zm143.852 100.606c-16.225 16.226-37.539 24.338-58.852 24.338s-42.626-8.112-58.852-24.338c-5.858-5.857-5.858-15.355 0-21.213 5.857-5.857 15.355-5.857 21.213 0 20.754 20.754 54.523 20.754 75.277 0 5.857-5.857 15.355-5.857 21.213 0 5.858 5.858 5.858 15.356.001 21.213zM356 302c-8.284 0-15-6.716-15-15 0-8.271-6.729-15-15-15s-15 6.729-15 15c0 8.284-6.716 15-15 15s-15-6.716-15-15c0-24.813 20.187-45 45-45s45 20.187 45 45c0 8.284-6.716 15-15 15zM346 122h-5V87.42c17.459-6.192 30-22.865 30-42.42 0-24.813-20.187-45-45-45s-45 20.187-45 45c0 19.555 12.541 36.228 30 42.42V122H201V87.42c17.459-6.192 30-22.865 30-42.42 0-24.813-20.187-45-45-45s-45 20.187-45 45c0 19.555 12.541 36.228 30 42.42V122h-5c-19.555 0-36.228 12.541-42.42 30h264.84c-6.192-17.459-22.865-30-42.42-30z" fill="currentColor"/></g></svg>
        </div>
    </div>
    <div class="gpt-card">
         <!-- Chat Boat Close  -->
         <div class="gpt-chatbot-close">x</div>
        <h4 class="gpt-form-title">
            <?php
            if(!empty($atts['title'])):
              echo esc_html($atts['title']);
            endif;
            ?>
        </h4> 
        <div class="gpt-from-wrapper">
            <div class="gpt-chatbox-and-settings-wrap">
                <div class="gpt-chatbot-container">
                    <!-- Chat Content   -->
                    <div class="gpt-chatbot-content" id="gpt_chat_start">
					<div class="gpt-chatbox-messages">
						<div class="gpt_chat_output">
							<span class="gpt-typing-balls">
							<span></span>
							<span></span>
							<span></span>
							</span>
						</div>
					</div>
                    </div>
                    <!-- Chat Message  -->
                    <div class="gpt-chatbot-message">
                        <div class="gpt-input-wrapper">
                            <input type="text" name="gpt_chat_option_input" id="gpt_chat_option_input" placeholder="<?php echo esc_html__('Type a message...','gpt-sniper'); 
                            ?>"/>
                            <a href="javascript:void(0);" class="gpt-btn" id="gpt_chat_option_send">
                            <?php echo esc_html__('Send','gpt-sniper'); ?> 
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" viewBox="0 0 448.011 448.011"  xml:space="preserve"><g><path d="m438.731 209.463-416-192c-6.624-3.008-14.528-1.216-19.136 4.48a15.911 15.911 0 0 0-.384 19.648l136.8 182.4-136.8 182.4c-4.416 5.856-4.256 13.984.352 19.648 3.104 3.872 7.744 5.952 12.448 5.952 2.272 0 4.544-.48 6.688-1.472l416-192c5.696-2.624 9.312-8.288 9.312-14.528s-3.616-11.904-9.28-14.528z" fill="currentColor"/></g></svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>