<?php
/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://#
 * @since      1.0.0
 *
 * @package    Gpt_Sniper
 * @subpackage Gpt_Sniper/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Gpt_Sniper
 * @subpackage Gpt_Sniper/includes
 * @author     gptsniper <admin@gptsniper.com>
 */
class Gpt_Sniper {
	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Gpt_Sniper_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;
	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;
	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;
	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'GPT_SNIPER_VERSION' ) ) {
			$this->version = GPT_SNIPER_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'gpt-sniper';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Gpt_Sniper_Loader. Orchestrates the hooks of the plugin.
	 * - Gpt_Sniper_i18n. Defines internationalization functionality.
	 * - Gpt_Sniper_Admin. Defines all hooks for the admin area.
	 * - Gpt_Sniper_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-gpt-sniper-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-gpt-sniper-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-gpt-sniper-admin.php';

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/gpt-sniper-schedule-post.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-gpt-sniper-public.php';
		$this->loader = new Gpt_Sniper_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Gpt_Sniper_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Gpt_Sniper_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Gpt_Sniper_Admin( $this->get_plugin_name(), $this->get_version() );
      
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		
		/**
		 * Gpt Sniper Post Admin Menu
		 */
        $this->loader->add_action('admin_menu', $plugin_admin,'gptsniper_admin_menus');

		/**
		 * Gpt Sniper Meta box Setting post and custom type
		 */
		$this->loader->add_action('add_meta_boxes', $plugin_admin,'gptsniper_add_custom_box');

		/**
		 * Gpt Sniper Meta box Setting post and custom type Save 
		 */
		$this->loader->add_action('save_post', $plugin_admin,'gptsniper_save_postdata');

		/**
		 * Gpt Sniper Images ajax hook
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_wp_media_image_fileload', $plugin_admin,'gptsniper_wp_media_image_fileload');
		$this->loader->add_action('wp_ajax_gptsniper_wp_media_image_fileload', $plugin_admin,'gptsniper_wp_media_image_fileload');

		/**
		 * Gpt Sniper Images Search 
		 */
        $this->loader->add_action('wp_ajax_nopriv_gptsniper_open_search_image',$plugin_admin,'gptsniper_open_search_image');
		$this->loader->add_action('wp_ajax_gptsniper_open_search_image',$plugin_admin,'gptsniper_open_search_image');

		/**
		 * Gpt Sniper User Image Save Media Libary
		 */ 
		$this->loader->add_action( 'wp_ajax_nopriv_gptsniper_upload_save_media', $plugin_admin, 'gptsniper_upload_save_media');
		$this->loader->add_action('wp_ajax_gptsniper_upload_save_media', $plugin_admin, 'gptsniper_upload_save_media'); 
		
		/**
		 * Gpt Sniper Image Generator
		 */
	   $this->loader->add_action('wp_ajax_nopriv_gptsniper_openai_img_generator', $plugin_admin,'gptsniper_openai_img_generator'); 
	   $this->loader->add_action('wp_ajax_gptsniper_openai_img_generator', $plugin_admin,'gptsniper_openai_img_generator'); 

	   /**
		* Gpt Sniper General Api Setting ajax
	    */
	   $this->loader->add_action('wp_ajax_nopriv_gptsniper_general_api_settings', $plugin_admin,'gptsniper_general_api_settings'); 
	   $this->loader->add_action('wp_ajax_gptsniper_general_api_settings', $plugin_admin,'gptsniper_general_api_settings'); 
	   /**
		* Gpt Sniper Content Generator 
	    */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_content_generator', $plugin_admin,'gptsniper_content_generator');
		$this->loader->add_action('wp_ajax_gptsniper_content_generator', $plugin_admin,'gptsniper_content_generator');

		/**
		 * Gpt Sniper Seo Content Generator
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_seo_content', $plugin_admin,'gptsniper_seo_content');
		$this->loader->add_action('wp_ajax_gptsniper_seo_content', $plugin_admin,'gptsniper_seo_content');

		/**
		 * Gpt Sniper Sec Content Save
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_seo_content_save', $plugin_admin,'gptsniper_seo_content_save');
		$this->loader->add_action('wp_ajax_gptsniper_seo_content_save', $plugin_admin,'gptsniper_seo_content_save');

		/**
		 * Gpt Sniper Head Section in Add Data
		 */
		$gpt_seo_data = json_decode(get_option('gpt_seo_data'),true);
		
		if(isset($gpt_seo_data['includ_text_check']) && $gpt_seo_data['includ_text_check']=== 'true'):
		 $this->loader->add_action('wp_head', $plugin_admin,'gptsniper_seo_content_added_head');
		endif;

		/**
		 * Gpt Sniper Quetion & Answers ajax
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_quetion_anwsers', $plugin_admin,'gptsniper_quetion_anwsers');
		$this->loader->add_action('wp_ajax_gptsniper_quetion_anwsers', $plugin_admin,'gptsniper_quetion_anwsers');

		/**
		 * Gpt Sniper Chatbot Ajax 
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_chatbot_option_ajax',$plugin_admin,'gptsniper_chatbot_option_ajax');
		$this->loader->add_action('wp_ajax_gptsniper_chatbot_option_ajax',$plugin_admin,'gptsniper_chatbot_option_ajax');	

		/**
		 * Gpt Sniper Chatbot Custom Setting
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_chatbot_custom_setting',$plugin_admin,'gptsniper_chatbot_custom_setting');
		$this->loader->add_action('wp_ajax_gptsniper_chatbot_custom_setting',$plugin_admin,'gptsniper_chatbot_custom_setting');

		/**
		 * Gpt Sniper Chatbot
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_qa_custom_setting',$plugin_admin,'gptsniper_qa_custom_setting');
		$this->loader->add_action('wp_ajax_gptsniper_qa_custom_setting',$plugin_admin,'gptsniper_qa_custom_setting'); 

		/**
		 * Schedule Poster Ajax File
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_add_schedule_post',$plugin_admin,'gptsniper_add_schedule_post');
		$this->loader->add_action('wp_ajax_gptsniper_add_schedule_post',$plugin_admin,'gptsniper_add_schedule_post');  

		/**
		 * Schedule Delete Ajax
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_delete_Schedule',$plugin_admin,'gptsniper_delete_Schedule');
		$this->loader->add_action('wp_ajax_gptsniper_delete_Schedule',$plugin_admin,'gptsniper_delete_Schedule');

		/**
		 * Gpt Sniper Blogs Demos
		 */
        $this->loader->add_action('wp_ajax_nopriv_gptsniper_demos_ajax_imports',$plugin_admin,'gptsniper_demos_ajax_imports');
		$this->loader->add_action('wp_ajax_gptsniper_demos_ajax_imports',$plugin_admin,'gptsniper_demos_ajax_imports');

		/**
		 * GPT Sniper Customer Authentication
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_customer_authentication_verify',$plugin_admin,'gptsniper_customer_authentication_verify');
		$this->loader->add_action('wp_ajax_gptsniper_customer_authentication_verify',$plugin_admin,'gptsniper_customer_authentication_verify'); 

		/**
		 * GPT Sniper Customer Authentication  Disconnection
		 */
		$this->loader->add_action('wp_ajax_nopriv_gptsniper_customer_authentication_disconnection',$plugin_admin,'gptsniper_customer_authentication_disconnection');
		$this->loader->add_action('wp_ajax_gptsniper_customer_authentication_disconnection',$plugin_admin,'gptsniper_customer_authentication_disconnection'); 

		$schedule_post = new Gpt_Schedule_post($this->get_plugin_name(), $this->get_version());
         
	} 
	/** 
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Gpt_Sniper_Public( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Gpt_Sniper_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}
}
