<?php
/**
 * Fired during plugin activation
 *
 * @link       https://#
 * @since      1.0.0
 *
 * @package    Gpt_Sniper
 * @subpackage Gpt_Sniper/includes
 */
/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Gpt_Sniper
 * @subpackage Gpt_Sniper/includes
 * @author     gptsniper <admin@gptsniper.com>
 */
class Gpt_Sniper_Activator {
	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		global $wpdb;
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        /**
		 * GPT Sniper Payment Option
		 */
		$table_name = $wpdb->prefix . 'schedule_poster';
		$charset_collate = $wpdb->get_charset_collate();
		$sql_create_table = "CREATE TABLE IF NOT EXISTS $table_name (
					`sp_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
					`sp_schedule_name` varchar(255) NOT NULL, 
					`sp_keywords` text NOT NULL,
					`sp_time_duration` varchar(100) NOT NULL,
					`sp_date_time` varchar(100) NOT NULL,
					`sp_post_status` varchar(100) NOT NULL,
					`add_featured_image` varchar(100) NOT NULL,
					`add_image` varchar(100) NOT NULL,
					`gpt_image_size` varchar(100) NOT NULL,
					`create_date_time` datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
					`update_date_time` datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
					PRIMARY KEY  (sp_id)
				) $charset_collate;";
				
		dbDelta($sql_create_table);
	}
} 