<?php
/** 
 * GPT Sniper Schedule Post
 */
class Gpt_Schedule_post {

    private $plugin_name;
    private $version;
    public function __construct( $plugin_name, $version ) {
        $this->plugin_name = $plugin_name;
		$this->version = $version;
        add_filter('cron_schedules',array($this,'gptsniper_cron_schedules'));
        global $wpdb;
        $table_name = $wpdb->prefix .'schedule_poster';
        $result = $wpdb->get_results(sprintf("SELECT * FROM $table_name"));
        if($result){
            foreach($result as $datavalue){
                $keywords = $datavalue->sp_keywords;
                if(!wp_next_scheduled('schedules_task_hook_'.$datavalue->sp_id)) {
                    wp_schedule_event(time(), "gpt_".$datavalue->sp_id, 'schedules_task_hook_'.$datavalue->sp_id);
                }
              add_action('schedules_task_hook_'.$datavalue->sp_id,array($this,'gptsniper_cron_task_schedules_post'));
            }
        }  
    }
    /**
     * Cron Schedule
     */ 
    public function gptsniper_cron_schedules($schedules){
        global $wpdb;
        $table_name = $wpdb->prefix .'schedule_poster';
        $result = $wpdb->get_results(sprintf("SELECT * FROM $table_name"));
        if($result){
            foreach($result as $datavalue){
                if(!isset($schedules["gpt_".$datavalue->sp_id])){
                    $schedules["gpt_".$datavalue->sp_id] = array(
                        'interval' => 24*60*60*(int)$datavalue->sp_time_duration,
                        'display' => __('Once every '.$datavalue->sp_time_duration.' day'));
                }
            }
        } 
        return $schedules;
    }  
    /**
     * Add Post 
     */
    public function gptsniper_set_image_from_urls($url) {
        if (!function_exists( 'download_url' ) ) {
        require_once ABSPATH . "wp-includes/pluggable.php"; 
        require_once ABSPATH . '/wp-admin/includes\media.php';
        require_once ABSPATH . 'wp-admin/includes/file.php';
        require_once ABSPATH . '/wp-admin/includes\image.php';
        }
        $tmp = download_url($url);
        $file_array = array(
            'name' => basename( $url ),
            'tmp_name' => $tmp
        );
        if(is_wp_error($tmp)){
            @unlink( $file_array[ 'tmp_name' ] );
            return $tmp;
        }
        $post_id = '0';
        $id = media_handle_sideload( $file_array, $post_id );
        if(is_wp_error($id)){
            @unlink( $file_array['tmp_name']);
            return $id;
        }
        return $id;
    }  
    /**
     * GPT Sniper Feature 
     */
    public function gptsniper_setfeature_images($post_id=false,$image_url=false){
        $image_name  = 'openai_images.png';
        $upload_dir  = wp_upload_dir(); // Set upload folder
        $image_data  = file_get_contents($image_url); // Get image data
        $unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name
        $filename  = basename( $unique_file_name ); // Create image file name
        // Check folder permission and define file location
        if( wp_mkdir_p( $upload_dir['path'] ) ) {
            $file = $upload_dir['path'] . '/' . $filename;
        } else {
            $file = $upload_dir['basedir'] . '/' . $filename;
        }
        // Create the image  file on the server
        file_put_contents( $file, $image_data );
        $wp_filetype = wp_check_filetype( $filename, null );
        // Set attachment data
        $attachment = array(
            'post_mime_type' => $wp_filetype['type'],
            'post_title'     => sanitize_file_name( $filename ),
            'post_content'   => '',
            'post_status'    => 'inherit'
        );
        $attach_id = wp_insert_attachment( $attachment, $file, $post_id );
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        $attach_data = wp_generate_attachment_metadata( $attach_id, $file );
        wp_update_attachment_metadata( $attach_id, $attach_data );
        set_post_thumbnail($post_id, $attach_id);
    }
    public function gptsniper_cron_task_schedules_post() {
        global $wpdb; 
        $general_api = json_decode(get_option('gptsniper_general_api'),true);
        $openai_api_save = '';
       
        $user_key = '';
        if(!empty($general_api['api_key'])):
            $openai_api_save = $general_api['api_key'];
            $user_key ='yes';
        else:
            $user_key ='no';
            $openai_api_save = get_option('gpt_open_rendom_api_keys');
        endif;

        $getMaxTokens = 1000;
        if(!empty($general_api['max_tokens'])):
            $getMaxTokens = $general_api['max_tokens'];
        endif; 
        $getTemperature = 0.5;
        if(!empty($general_api['temperature'])):
            $getTemperature = $general_api['temperature'];
        endif;
        $model_option = 'text-davinci-003';
        if(!empty($general_api['model_option'])):
            $model_option = $general_api['model_option'];
        endif;
        $presence_penalty = 0.01;
        if(!empty($general_api['presence_penalty'])): 
            $presence_penalty = $general_api['presence_penalty'];
        endif;
        $frequency_penalty = 0.01;
        if(!empty($general_api['frequency_penalty'])): 
            $frequency_penalty = $general_api['frequency_penalty'];
        endif;
        $best_of = 1;
        if(!empty($general_api['best_of'])): 
            $best_of = $general_api['best_of'];
        endif;
        $top_p = 0.01;
        if(!empty($general_api['top_p'])): 
            $top_p = $general_api['top_p'];
        endif;
        $table_name = $wpdb->prefix .'schedule_poster';
        $result = $wpdb->get_results(sprintf("SELECT * FROM $table_name"));
        if($result){
            foreach($result as $datavalue){
                $add_image = $datavalue->add_image;
                $feature_image = $datavalue->add_featured_image;
                $keywords = $datavalue->sp_keywords;
                $media_image_url = '';
                if($add_image === 'true' || $feature_image === 'true'){
                    /**
                     * Image Code
                     */
                    $ogj = str_replace(" ","%20",$keywords);
                    if(!empty($datavalue->gpt_image_size)){
                        $size = $datavalue->gpt_image_size;
                    }else{
                        $size = "1024x1024";
                    }
                    if(!empty($ogj)){
                        $args = array(
                            "prompt" => "$keywords",
                            "n"=>1,
                            "size"=>$size
                        );  
                    $data_string = json_encode($args);  
                    $ch = curl_init('https://api.openai.com/v1/images/generations');
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                                       
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                         
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Authorization: Bearer '.$openai_api_save,
                        'Content-Type: application/json'
                    ));
                    $result = curl_exec($ch);
                    $a = json_decode($result,true);
                    if(isset($a['data'])){
                        foreach($a['data'] as $a_child){
                            $img = 'openai_images.png'; 
                            $imgUrl = $a_child['url'];
                            file_put_contents($img, file_get_contents($imgUrl));
                            $img_url= get_home_url().'/wp-admin/openai_images.png';
                            $new_image = sanitize_url($img_url);
                            $res = $this->gptsniper_set_image_from_urls($new_image); 
                            if($res > 0):
                                $media_image_url = wp_get_attachment_url($res);
                            endif;
                            
                            }
                        }
                    } 
                }
                /** 
                 * Images Api Close
                 * Content Code
                 */
                $header = array(
                    'Authorization: Bearer '.$openai_api_save,
                    'Content-type: application/json; charset=utf-8',
                );
                $params = json_encode(array( 
                    'prompt' => "$keywords",
                    'model'	 => $model_option,
                    'temperature' => (float)$getTemperature,
                    'max_tokens' => (float)$getMaxTokens,
                    'top_p' => (float)$top_p,
                    'best_of' => (float)$best_of,
                    "frequency_penalty" => (float)$frequency_penalty,
                    "presence_penalty" => (float)$presence_penalty,
                ));   
                $curl = curl_init('https://api.openai.com/v1/completions');
                $options = array(
                    CURLOPT_POST => true,
                    CURLOPT_HTTPHEADER =>$header,
                    CURLOPT_POSTFIELDS => $params,
                    CURLOPT_RETURNTRANSFER => true,
                  );
                curl_setopt_array($curl, $options);
                $response = curl_exec($curl);
                $httpcode = curl_getinfo($curl, CURLINFO_RESPONSE_CODE);
                $json_array = json_decode($response, true);
                $messages = '';
                if(!empty($json_array['error']['message'])):
                    $messages = $json_array['error']['message'];
                else:
                    $messages = esc_html__('Successfully',"gpt-sniper");
                endif;
                if(200 == $httpcode){
                    
                    $choices = $json_array['choices'];
                    $postContent = $choices[0]["text"];
                    if($add_image==='true'):
                        $with_image = '<img src="'.esc_url($media_image_url).'" alt='.esc_attr($datavalue->sp_keywords).'><br>';
                        $postContent = $with_image.' '.$postContent;
                    endif;
                    $add_post = array(
                        'post_title' => $datavalue->sp_keywords,
                        'post_content' => $postContent,
                        'post_status' => $datavalue->sp_post_status,
                        'post_author' => 1, 
                      );
                    // Insert the post into the database
                    $post_id = wp_insert_post($add_post);   
                    /**
                     * Set Feture Image Option
                     */
                    if($feature_image=='true'):
                        $this->gptsniper_setfeature_images($post_id,$media_image_url);
                    endif;    
                    $result_data = array(
                                'status'=>$httpcode,
                                'content_data'=> $postContent,
                                'message' => $messages
                                );
                }else{
                    $result_data = array(
                       'status'=>$httpcode,
                       'user_key'=>$user_key,
                       'message' =>$messages
                       );
                                   
                    /**
        			 * Api key Update
        			 */ 
        			if(empty($general_api['api_key'])){
                        if($httpcode == 429){
                            $remot_hit = $this->gptsniper_remote_api_update();
                            if($remot_hit){
                              $this->gptsniper_cron_task_schedules_post();
                            }
                        }
                    }              
                }
                echo json_encode($result_data);
            }
        }
    }   
} 