<?php
/**
 * Team Section shortcode js_composer
 */
add_shortcode('astrologercore_team_members','astrologercore_team_view');
function astrologercore_team_view($atts,$content){
    extract(shortcode_atts(
	array(
	    'team_style' => 'grid',
		'team_c_class' => '',
		'team_post' => '',
		'team_button_text' => '',
		'team_button_url' => '',
		'col' => '3',
	),$atts 
	) );
$result = '';
$icon_path = plugins_url( '/images/' , __FILE__ ) ;
if($team_style == 'slider'){
    $result.= '<div class="al-testimonial-wrapper al-team-sldr-wrapper '.esc_attr($team_c_class).'">
	<div class="container">
		<div class="al-testimonial-slider-wrapper">
			<div class="swiper-container">
				<div class="swiper-wrapper">';
				$args = array(
                    'post_type' => 'team',
                    'posts_per_page' => $team_post
                    // Several more arguments could go here. Last one without a comma.
                );
                $args_query = new WP_Query($args);
                if ( $args_query->have_posts() ) :
                while ($args_query->have_posts()) : $args_query->the_post();
                $team_designation = get_post_meta(get_the_ID(), 'team_designation', true);
                $team_fb = get_post_meta(get_the_ID(), 'team_fb', true);
                $team_tw = get_post_meta(get_the_ID(), 'team_tw', true);
                $team_linkedin = get_post_meta(get_the_ID(), 'team_linkedin', true);
                $img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
				$result.= '<div class="swiper-slide">
					<div class="al-testimonial-box">
						<div class="al-testimonial-inner">
							<div class="al-team-content">
								<div class="al-team-img-div">
									<a href="'.esc_url(get_the_permalink()).'">';
									if(!empty($img_url)):
										$result .= '<img src="'.esc_url($img_url).'" alt="'.esc_attr__('movie','astrologer').'">';
									endif;
									 $result.= '<div class="al-overlay"></div>
									</a>
								</div>																				
								<div class="overlay-icon">';
									if($team_tw):
										$result .= '<a href="'.esc_html($team_tw).'"><img src="'.($icon_path.'Twitter.png').'" alt="'.esc_attr__('Twitter','astrologer').'"></a>';
									endif;
									 if($team_linkedin):
										$result .= '<a href="'.esc_html($team_linkedin).'"><img src="'.($icon_path.'Linkedin.png').'" alt="'.esc_attr__('Linkedin','astrologer').'"></a>';
									 endif;
									if($team_fb):	
										$result .= '<a href="'.esc_html($team_fb).'"><img src="'.($icon_path.'Facebook.png').'" alt="'.esc_attr__('Facebook','astrologer').'"></a>';
									endif;
									$result .= '
								</div>																						
								<div class="al-team-updt-info">
									<a href="'.esc_url(get_the_permalink()).'"><h1>'.get_the_title().'</h1></a>
									<a href="'.esc_url(get_the_permalink()).'"><p>'.esc_html($team_designation).'</p></a>
								</div>			
							</div>
						</div>							
					</div>
				</div>';
                    endwhile;
                // Reset Post Data
                wp_reset_postdata();
                endif;
			$result.= '</div>
			</div>			
			<div class="swiper-button-prev" tabindex="0" role="button" aria-label="Previous slide" aria-controls="swiper-wrapper-f6593c349f5cafdf"></div>
			<div class="swiper-button-next" tabindex="0" role="button" aria-label="Next slide" aria-controls="swiper-wrapper-f6593c349f5cafdf"></div>					
		</div>';
		if($team_button_text){
		    $result.= '<div class="al-slidr-btn">
			<a href="'.esc_url($team_button_url).'" class="al-btn">'.esc_html($team_button_text).'</a>
		</div>';
		}
	$result.= '</div>
</div>';  
}else{
    $col = $col;
	$col = $col == '3' ? '4' : ($col == '4' ? '3' : '6');
	$cls = 'col-lg-'.$col.' col-md-6';
    $result .= '<div class="al-testimonial-wrapper al-team-updt-wrapper">
        <div class="container">
        	<div class="al-testimonial-slider-wrapper">
         <div class="row gy-4">';
				$args = array(
                    'post_type' => 'team',
                    'posts_per_page' => $team_post
                    // Several more arguments could go here. Last one without a comma.
                );
                $args_query = new WP_Query($args);
                while ($args_query->have_posts()) : $args_query->the_post();
                $team_designation = get_post_meta(get_the_ID(), 'team_designation', true);
                $team_fb = get_post_meta(get_the_ID(), 'team_fb', true);
                $team_tw = get_post_meta(get_the_ID(), 'team_tw', true);
                $team_linkedin = get_post_meta(get_the_ID(), 'team_linkedin', true);
                $img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                $result.= '<div class="'.esc_attr($cls).'">
					<div class="al-testimonial-box">
						<div class="al-testimonial-inner">
							<div class="al-team-content">
								<div class="al-team-img-div">
									<a href="'.esc_url(get_the_permalink()).'">';
									if(!empty($img_url)):
										$result .= '<img src="'.esc_url($img_url).'" alt="'.esc_attr__('movie','astrologer').'">';
									endif;
									 $result.= '<div class="al-overlay"></div>
									</a>
								</div>																				
								<div class="overlay-icon">';
									if($team_tw):
										$result .= '<a href="'.esc_html($team_tw).'"><img src="'.($icon_path.'Twitter.png').'" alt="'.esc_attr__('Twitter','astrologer').'"></a>';
									endif;
									 if($team_linkedin):
										$result .= '<a href="'.esc_html($team_linkedin).'"><img src="'.($icon_path.'Linkedin.png').'" alt="'.esc_attr__('Linkedin','astrologer').'"></a>';
									 endif;
									if($team_fb):	
										$result .= '<a href="'.esc_html($team_fb).'"><img src="'.($icon_path.'Facebook.png').'" alt="'.esc_attr__('Facebook','astrologer').'"></a>';
									endif;
									$result .= '
								</div>																						
								<div class="al-team-updt-info">
									<a href="'.esc_url(get_the_permalink()).'"><h1>'.get_the_title().'</h1></a>
									<a href="'.esc_url(get_the_permalink()).'"><p>'.esc_html($team_designation).'</p></a>
								</div>			
							</div>
						</div>							
					</div>         
					</div>';
                    endwhile;
                // Reset Post Data
                wp_reset_postdata();
			$result.= '</div>';
		if($team_button_text){
		    $result.= '<div class="al-slidr-btn">
			<a href="'.esc_url($team_button_url).'" class="al-btn">'.esc_html($team_button_text).'</a>
		</div>';
		}
	$result.= '</div>
	</div>
    </div>';
}
return $result;
}