<?php
// Daily panchang
include __DIR__ . '/client.php';

$astrologer_options = get_option('astrologer_options');	
if(!empty($astrologer_options)){
	if($astrologer_options['prokerala_api'] == '1'){
		if(!empty($astrologer_options['pro_client_id'])){
			define("PK_CLIENT_ID", $astrologer_options['pro_client_id']);
		}
		if(!empty($astrologer_options['pro_client_secrete'])){
			define("PK_CLIENT_SECRET", $astrologer_options['pro_client_secrete']);
		}
		if(!empty($astrologer_options['pro_location'])){
			define("DEFAULT_LOCATION", $astrologer_options['pro_location']);
		}
		if(!empty($astrologer_options['pro_location_cordinate'])){
			define("DEFAULT_LOCATION_COORDINATES", $astrologer_options['pro_location_cordinate']);
		}
		if(!empty($astrologer_options['pro_location_tz'])){
			define("DEFAULT_LOCATION_TZ", $astrologer_options['pro_location_tz']);
		}
	}
}
/**
 * Convert short code to HTML.
 *
 * @param array $atts Shortcode attributes.
 * @return string Rendered HTML.
 */
function daily_horoscope_panchang() {
	if (defined('DEFAULT_LOCATION')) {
		$location = DEFAULT_LOCATION;
	}else{
		printf("<p>Location is not defind.</p>");
	}
	if (defined('DEFAULT_LOCATION_COORDINATES')) {
		$coordinates = DEFAULT_LOCATION_COORDINATES;
	}else{
		printf("<p>Location COORDINATES is not defind.</p>");
	}
	if (defined('DEFAULT_LOCATION_TZ')) {
		$tz = DEFAULT_LOCATION_TZ;
	}else{
		printf("<p>Location TZ is not defind.</p>");
	}
	if(!empty($location) && !empty($coordinates) && !empty($tz)){
		$date = date("j");
		$key = 'astro_daily_panchang';
		$data = get_option($key);
		$arr_data = '';
		if(!empty($data)){
			$arr_data = json_decode($data,true);
		}
		if($arr_data['date'] == $date){
			$result = $arr_data['result'];
		}else{
			$tz = new DateTimeZone( $tz );
			
			$result = astrology_panchang_get_data( $coordinates, new \DateTimeImmutable('now', $tz ) );
			$data = array(
			   'date' => $date,
			   'result' => $result
			);
			update_option($key,json_encode($data));
		}
		include __DIR__ . '/templates/panchang.tpl.php';
	}
}

/**
 * Get panchang data from API Server
 *
 * @param string $coordinates Location latitude and longitude.
 * @param string $tz Timezone name
 * @return string Rendered widget HTML.
 */
function astrology_panchang_get_data( $coordinates, $datetime ) {
	if (defined('PK_CLIENT_ID') && defined('PK_CLIENT_SECRET')) {
		$client = new \Prokerala\WP\Panchang\Api\ApiClient( PK_CLIENT_ID, PK_CLIENT_SECRET );

		$response = $client->get('v2/astrology/panchang/advanced', [
			'ayanamsa' => 1,
			'coordinates' => '23.1765,75.7885',
			'datetime' => $datetime->format( 'c' ),
		]);

		return astrology_panchang_convert_date( $response->data, $datetime->getTimeZone() );
	}else{
		printf("<p>prokerala's credentials is not defind.</p>");
	}
}

/**
 * Convert datetime string to DateTimeImmutable objects
 *
 * @param mixed $data Data to iterate into.
 * @param \DateTimeZone $timezone Output timezone.
 * @return mixed Data with datestring converted to DateTimeImmutable object.php
 */
function astrology_panchang_convert_date( $data, $tz ) {
    foreach ( $data as $key => &$val ) {
        if (is_iterable ( $val ) || $val instanceof \stdClass ) {
            $val = astrology_panchang_convert_date( $val, $tz );
        } else if ( is_string( $val ) && preg_match( '/^\d{4}-\d{2}-\d{2}T/', $val ) ) {
            $val = (new \DateTimeImmutable( $val ))->setTimeZone( $tz );
        }
    }

    return $data;
}

/**
 * Enqueue plugin css file.
 *
 * @return void
 */
function astrology_panchang_enqueue_script() {
    $plugin_url = plugin_dir_url( __FILE__ );
    wp_enqueue_style( 'astrology_panchang_style', $plugin_url . 'css/style.css' );
}

/**
 * Initialize plugin.
 *
 * @return void
 */
function astrology_panchang_init() {
    add_shortcode('panchang', 'daily_horoscope_panchang');
    add_action('wp_enqueue_scripts','astrology_panchang_enqueue_script');
}

add_action('init', 'astrology_panchang_init');