<?php 
/**
 * Astrologer top header WooCommerce function
 */
if(!function_exists('astrologercore_top_header')){
    function astrologercore_top_header(){
        $theme_option = '';
if(function_exists('astrologer_theme_option_settings')):
  $theme_option = astrologer_theme_option_settings();
endif;
$header_switch = '';
    if(!empty($theme_option['top_header_switch'])){
        $header_switch = $theme_option['top_header_switch'];
}
     if($header_switch == true) {
        $headclass = 'al-top-header-active';
    }else{
        $headclass = '';
    }
	?>
    <div class="al-info-detail">
      <?php dynamic_sidebar('al-top-header');  ?>
      <div class="al-info-detail-right <?php  echo esc_attr($headclass); ?>">
            <?php dynamic_sidebar('al-top-header-2');  ?>
        </div>
     </div>
 <?php	
  }
}

/**
 * Astrologer Search Function
 */
if(!function_exists('astrologercore_header_search')){
    function astrologercore_header_search(){
	?>
    <div class="al-search-form">
        <div class="al-search-form-inner">
            <form method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
              <a href="javascript:void(0);" class="close-search">
                <svg viewBox="0 0 413.348 413.348" xmlns="http://www.w3.org/2000/svg"><path d="m413.348 24.354-24.354-24.354-182.32 182.32-182.32-182.32-24.354 24.354 182.32 182.32-182.32 182.32 24.354 24.354 182.32-182.32 182.32 182.32 24.354-24.354-182.32-182.32z"/></svg>
              </a>
              <div class="search-bar-inner">
                <input type="text" name="s" id="s" placeholder="<?php echo esc_attr_x( 'Search here', 'astrologer' ) ?>" />
                <button class="sr-header-search">
                  <svg class="sr-search-svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid" viewBox="0 0 15 16.031">
                    <path d="M12.490,7.014 C12.467,7.837 12.244,8.933 11.679,9.915 C11.478,10.263 11.539,10.450 11.794,10.713 C12.735,11.684 13.658,12.675 14.576,13.671 C15.305,14.463 15.040,15.650 14.075,15.948 C13.545,16.111 13.121,15.892 12.750,15.492 C11.839,14.512 10.915,13.545 10.010,12.558 C9.794,12.321 9.642,12.257 9.335,12.436 C7.170,13.702 4.989,13.682 2.905,12.279 C0.866,10.906 -0.084,8.842 0.001,6.278 C0.104,3.170 2.407,0.526 5.349,0.071 C9.133,-0.514 12.508,2.615 12.490,7.014 ZM10.617,6.642 C10.611,4.097 8.643,1.991 6.270,1.989 C3.829,1.988 1.865,4.078 1.865,6.678 C1.865,9.235 3.848,11.336 6.257,11.330 C8.657,11.324 10.623,9.210 10.617,6.642 Z"/>
                  </svg>
                </button>
              </div>
            </form>
        </div>
      </div>
 <?php	
  }
}
  
/**
 * Astrologer Widget Function
 */
function astrologercore_widgets_init() {
    
    register_sidebar(
		array(
		'name' => esc_html__('Astrologer Top Header Left', 'astrologer' ),
		'id'   => 'al-top-header',
		'description'   => esc_html__( 'Add Astrologer Top Left Header Setting.', 'astrologer' ),
		'before_widget' => '<div class="al-top-bar-widget-left">',
		'after_widget'  => '</div>',
		'before_title'  => '',
		'after_title'   => '',
		)
	);  
	
	 register_sidebar(
		array(
		'name' => esc_html__('Astrologer Top Header Right', 'astrologer' ),
		'id'   => 'al-top-header-2',
		'description'   => esc_html__( 'Add Astrologer Top Right Header Setting.', 'astrologer' ),
		'before_widget' => '<div class="al-top-bar-widget-right">',
		'after_widget'  => '</div>',
		'before_title'  => '',
		'after_title'   => '',
		)
	); 
	
}
add_action( 'widgets_init', 'astrologercore_widgets_init' );
