<?php 
/**
 * Plugin Name: Astrologercore Theme Plugin
 * Plugin URI:  http://kamleshyadav.com/wp/astrology/
 * Description: Astrologercore
 * Version: 1.1.0
 * Requires at least: 5.2
 * Requires PHP:      7.2
 * Author:            kamaleshyadav
 * Author URI:        https://themeforest.net/user/kamleshyadav
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       astrologer
 * Domain Path:       /languages
 */  
  
global $astrologercore_plug_version;
 
$astrologercore_plug_version = '1.0.8'; 

remove_action( 'wp_head', 'rest_output_link_wp_head'); 

add_action( 'admin_enqueue_scripts', 'astrologercore_enqueue_admin_script' );
function astrologercore_enqueue_admin_script($hook) {
    if ( 'widgets.php' != $hook ) {
        return;
    }
 wp_enqueue_media();
    wp_enqueue_script( 'astrologercore-admin-custom-script', plugin_dir_url( __FILE__ ) . '/assets/js/astrologercore-admin-custom-script.js', array(), '1.0', 'all' );
    wp_localize_script('astrologercore-admin-custom-script', 'frontadminajax', array('ajax_url' => admin_url('admin-ajax.php')));
}
/**
 * Astrologer frontend Script
 */

add_action( 'wp_enqueue_scripts', 'astrologercore_enqueue_frontend_script' );
function astrologercore_enqueue_frontend_script($hook) {
  $theme_option = '';
if(function_exists('astrologer_theme_option_settings')):
  $theme_option = astrologer_theme_option_settings();
endif;

  $sticky_header_menu = '';
if(!empty($theme_option['sticky_header_menu'])):
   $sticky_header_menu = $theme_option['sticky_header_menu'];
endif;
$header_menu = '';
if($sticky_header_menu == '1'){
    $header_menu = 'true';
}
 wp_enqueue_style('toastr-style', plugin_dir_url( __FILE__ )  . 'assets/css/toastr.min.css', array(), '1', 'all' );
 wp_enqueue_script( 'toastr', plugin_dir_url( __FILE__ ) . 'assets/js/toastr.min.js', array('jquery'), '20151215', true );
 wp_enqueue_script( 'astrologercore-forent-custom-script', plugin_dir_url( __FILE__ ) . '/assets/js/astrologercore-forent-custom-script.js', array(), '1.0', 'all' );
 wp_localize_script('astrologercore-forent-custom-script', 'frontadminajax', array('ajax_url' => admin_url('admin-ajax.php'),'switch_header'=> $header_menu));   
}

/** 
 * Redux Framework
 */   
if(class_exists( 'ReduxFramework' ) ) {
	require_once 'admin/options/astrologercore-config.php';
	require_once 'admin/options/custom-extensions/loader.php';
}   
  
/** 
 * WPBakery Page Builder Add Shortcode
 */ 
require_once 'admin/shortcodes/astrologercore-shortcodes-map.php'; 
require_once 'public/shortcodes/astrologercore-shortcodes-view.php'; 

/**
 * astrologercore custom meta option
 */ 
 
require_once 'admin/meta/astrologercore-meta-custom-post.php';
/** 
 * Astrologer Widgets
 */ 
require_once 'admin/widgets/astrologercore-widgets.php';  
  
/**
 * Astrologer Custom Function Settings 
 */ 
require_once 'public/astrologercore-custom-funcation-setting.php'; 

/**
 * Astrologer Custom Function Settings 
 */ 
require_once 'public/astrologercore-ajax-function.php'; 
/**
 * Astrologer Custom custom posts
 */ 
require_once 'admin/astrologercore-customposts.php';
/**
 * Astrologer Daily Horoscope API 
 */
require_once 'public/vedicastro-horoscope.php'; 
require_once 'public/daily-horoscope-panchange.php'; 
require_once 'public/daily_horoscope_prediction.php'; 

/**
 * Astrologer Demo Importer
 */ 
require_once 'admin/astrologercore-demo-importer.php';

/**
 * Theme demo impoter
 */
if ( !function_exists( 'astrologer_wbc_extended' ) ) {
	function astrologer_wbc_extended( $demo_active_import , $demo_directory_path ) {

		reset( $demo_active_import );
		$current_key = key( $demo_active_import );

		/************************************************************************
		* Import slider(s) for the current demo being imported
		*************************************************************************/

		if(class_exists('RevSlider')) {

			//If it's demo3 or demo5
			$wbc_sliders_array = array(
				'astrologer-demo' => 'astrology-slider.zip', //Set slider zip 
			);

			if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_sliders_array ) ) {
				$wbc_slider_import = $wbc_sliders_array[$demo_active_import[$current_key]['directory']];

				if ( file_exists( $demo_directory_path.$wbc_slider_import ) ) {
					$slider = new RevSlider();
					$slider->importSliderFromPost( true, true, $demo_directory_path.$wbc_slider_import );
				}
			}
		}

		/************************************************************************
		* Setting Menus
		*************************************************************************/

		// If it's demo1 - demo6
		$wbc_menu_array = array( 'astrologer-demo');

		if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && in_array( $demo_active_import[$current_key]['directory'], $wbc_menu_array ) ) {
		  
			$header_menu = get_term_by('name', 'Main_Menu', 'nav_menu' );
			$fot_menu = get_term_by( 'name', 'Footer_Menu', 'nav_menu' );
           
			if ( isset( $header_menu->term_id ) ) {
				set_theme_mod( 'nav_menu_locations', array(
						'astrologer-header-menu' => $header_menu->term_id,
						'astrologer-footer-menu' => $fot_menu->term_id,
					)
				); 
			} 

		} 

		/************************************************************************
		* Set HomePage
		*************************************************************************/

		// array of demos/homepages to check/select from
		$wbc_home_pages = array(
			'astrologer-demo' => 'Home',
		);
  
		if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_home_pages ) ) {
			$page = get_page_by_title( $wbc_home_pages[$demo_active_import[$current_key]['directory']] );
			if ( isset( $page->ID ) ) {
				update_option( 'page_on_front', $page->ID );
				update_option( 'show_on_front', 'page' );
			}
		}

	}
add_action( 'wbc_importer_after_content_import', 'astrologer_wbc_extended', 10, 2 );
} 