<?php

    /**
     * ReduxFramework Barebones Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
	  
	// This is your option name where all the Redux data is stored.
    $opt_name = "astrologer_options"; 
    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */ 

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Astrologer Options', 'astrologer' ),
        'page_title'           => __( 'Astrologer Options', 'astrologer' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,   // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-art',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 99,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => 'dashicons-screenoptions',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => false,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        //'compiler'             => true,
		
		'show_options_object' => false,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => '#7791ea',
            'icon_size'     => 'large',
            'tip_style'     => array(
                'color'   => 'dark',
                'shadow'  => true,
                'rounded' => true,
                'style'   => 'bootstrap',
            ),
            'tip_position'  => array(
                'my' => 'top right',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'astrologer' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'astrologer' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'astrologer' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'astrologer' )
        )
    );
    //Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'astrologer' );
    Redux::set_help_sidebar( $opt_name, $content );


// -> START Basic Fields

Redux::setSection( $opt_name, array(
    'id' => 'wbc_importer_section',
    'title'  => esc_html__( 'Demo Importer', 'astrologer' ),
    'icon'   => 'el el-download-alt',
    'fields' => array(
            array(
                'id'   => 'wbc_demo_importer',
                'type' => 'wbc_importer'
                )
        )
    )
);
Redux::setSection( $opt_name, array(
	'title' => __( 'Header', 'astrologer' ),
	'id'    => 'general',
	'desc'  => __( 'General settings of the site', 'astrologer' ),
	'icon'  => 'el el-credit-card'
) );

/* Top Header Setting start */
Redux::setSection( $opt_name, array(
	'title'      => __( 'Top Header', 'astrologer' ),
	'desc'       => __( 'Top Header global settings.', 'astrologer' ),
	'id'         => 'top-header',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'top_header_switch',
			'type'     => 'switch',
			'title'    => 'Top Header Enable/Disable',
			'default'  => false
			),
		array(
			'id'       => 'top_header_bg',
			'type'     => 'color',
			'title'    => 'Top Header background color',
			'default'  => '#07273c',
			),
		array(
			'id'       => 'top_header_color',
			'type'     => 'color',
			'title'    => 'Top Header color',
			'default'  => '#383838',
			),
		array(
			'id'       => 'mobile_icon',
			'type'     => 'media',
			'url'      => true,
			'title'    => __( 'Upload Mobile Icon', 'astrologer' ),
			'required' => array( array( 'top_header_switch', '=', true ) )
		  ),
		array(
		'id'       => 'mobile_number',
		'type'     => 'text',
		'title'    => __( 'Enter Mobile Number', 'astrologer' ),
		'required' => array( array( 'top_header_switch', '=', true ) )
		),
		array(
			'id'       => 'email_icon',
			'type'     => 'media',
			'url'      => true,
			'title'    => __( 'Upload Email Icon', 'astrologer' ),
			'required' => array( array( 'top_header_switch', '=', true ) )
		  ),
		array(
		'id'       => 'email',
		'type'     => 'text',
		'title'    => __( 'Enter Email', 'astrologer' ),
		'required' => array( array( 'top_header_switch', '=', true ) )
		),
		array(
			'id'       => 'clock_icon',
			'type'     => 'media',
			'url'      => true,
			'title'    => __( 'Upload Clock Icon', 'astrologer' ),
			'required' => array( array( 'top_header_switch', '=', true ) )
		  ),
		array(
		'id'       => 'clock',
		'type'     => 'text',
		'title'    => __( 'Enter Time', 'astrologer' ),
		'required' => array( array( 'top_header_switch', '=', true ) )
		),
		array(
			'id'       => 'login_register_switch',
			'type'     => 'switch',
			'title'    => 'Log in And Register Enable/Disable',
			'default'  => true
		),
		array(
		'id'       => 'page_title',
		'type'     => 'text',
		'title'    => __( 'Page Title', 'astrologer' ),
		'required' => array( array( 'top_header_switch', '=', true ) )
		),
		array(
		'id'       => 'page_url',
		'type'     => 'text',
		'title'    => __( 'Page URl', 'astrologer' ),
		'required' => array( array( 'top_header_switch', '=', true ) )
		),
		array(
			'id'       => 'search_switch',
			'type'     => 'switch',
			'title'    => ' Header Search Enable/Disable',
			'default'  => false
		),
		array(
			'id'       => 'mincart_switch',
			'type'     => 'switch',
			'title'    => 'WooCommerce MinCart Enable/Disable',
			'default'  => false
		),		
		array(
			'id'       => 'class_switch',
			'type'     => 'switch',
			'title'    => 'Body class switch Enable/Disable',
			'default'  => false
		),	
	)
		
/* Topbar Setting ends */
) );

Redux::setSection( $opt_name, array(
	'title'      => __( 'Main Menu', 'astrologer' ),
	'desc'       => __( 'Main Menu global settings.', 'astrologer' ),
	'id'         => 'general-header',
	'subsection' => true,
	'fields'     => array(
                array(
                    'id' => 'section-navigatoin-start',
                    'type' => 'section',
                    'title' => __('Main Settings', 'astrologer'),
                    'indent' => true 
                ),
                array( 
                    "type" => "select",
                    "title" => __( "Header Style", "astrologer" ),
                    "id" => "header_style",
                    'options'  => array( 'style-one'  => 'Style 1', 
                    			 'style-two'  => 'Style 2',
                    			 'style-tree' => 'Style 3',
                    			 'style-four' => 'Style 4'
                    			 ),
                    'default' => 'solid',
                ),
                array( 
                    "type" => "select",
                    "title" => __( "Color Style", "astrologer" ),
                    "id" => "style",
                    'options'  => array( 'solid' => 'Solid', 'gradient' => 'Gradient' ),
                    'default' => 'solid',
                ),
                array(
                    'id'       => 'site_logo',
                    'type'     => 'media',
                    'url'      => true,
                    'title'    => __( 'Site Logo', 'astrologer' ),
                    'compiler' => 'true',
                    'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/astrologer-logo.png' ),
                ),
                array(
                    'id'       => 'mobile_logo',
                    'type'     => 'media',
                    'url'      => true,
                    'title'    => __( 'Site Mobile Logo', 'astrologer' ),
                    'compiler' => 'true',
                    'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/mobile-logo.png' ),
                    'desc'  => __( 'This option is only for mobile device.', 'astrologer' ),
                ),
                array(
                    'id'       => 'header_bg_color',
                    'type'     => 'color', 
                    'title'    => __('Header Background color', 'astrologer'),
                    'default' => '#07273c'
                ),
                array(
                    'id'       => 'head_btn_text',
                    'type'     => 'text',
                    'title'    => __( 'Enter Header Button text', 'astrologer' ),
                ),
                array(
                    'id'       => 'btn_url',
                    'type'     => 'text',
                    'title'    => __( 'Enter Header Button Url', 'astrologer' ),
                ),
                array(
                    'id'       => 'sticky_header_menu',
                    'type'     => 'switch',
                    'title'    => __('Sticky Header Enable/Disable','astrologer'),
                    'default'  => false
                ),  		
    		array(
    			'id'       => 'toggle_header_position',
    			'type'     => 'select',
    			'title'    => __( 'Toggle Menu Position', 'astrologer' ),
    			'desc'     => __('Select position where you want to show the Main Menu.', 'astrologer'),
    			'options'  => array(
    				'header-left' => 'Left',
    				'header-right' => 'Right',
    				'header-top' => 'Top',
    				'header-bottom' => 'Bottom',
    				'header-center' => 'Center'
    			),
    			'default'  => 'header-top',
    			'required' => array( 'header', '=', array('toggle-header') )
    		),
    		array(
    			'id'       => 'social_box',
    			'type'     => 'color',
    			'title'    => __( 'Social Box Color', 'astrologer' ),
    			'desc'     => __('Change social box background color.', 'astrologer'),
    			'required' => array( 'toggle_header_position', '=', array('header-top','header-bottom') )
    		  ),
    		array(
    			'id'       => 'header_layout',
    			'type'     => 'select',
    			'title'    => __( 'Width', 'astrologer' ),
    			'options'  => array(
    				'wide' => 'Wide',
    				'narrow' => 'Narrow'
    			),
    			'default'  => 'narrow',
    			'required' => array( 'header', '!=', array('toggle-header') )
    		),
		
	     )
    ) );

Redux::setSection( $opt_name, array(
    'title'     => __( 'Page Title', 'astrologer' ),
    'id'        => 'general-page-title',
    'subsection' => true,
	'fields' => array(
			array(
			  'id' => 'astrologer_global_breadcrumb',
			  'type' => 'switch',
			  'title' => 'Breadcrumb ON/OFF',
			  'default' => false
		    ),
		    array(
            	'id'  => 'breadcrumb_image',
            	'type' => 'media', 
            	'url' => false,
            	'title' => __('Breadcrumb Background Image', 'astrologer'),
                'desc' => __('Breadcrumb Background Image.', 'astrologer'),
              ),
		)
    ) );

Redux::setSection( $opt_name, array(
	'title' => __( 'Theme Layout Setting', 'astrologer' ),
	'id'    => 'general-theme',
	'icon'          => 'dashicons dashicons-align-left',
	'fields'     => array(
		array(
			'id'       => 'theme_layout',
            'type'     => 'image_select',
            'title'    => __( 'Theme Layout Setting', 'astrologer' ),
            'desc'     => __( 'please select theme color.', 'astrologer' ),
            'options'  => array(
				'dark' => array(
					'id'       => 'dark',
					'type'     => 'image_select',
					'img' => get_template_directory_uri() . '/assets/images/dark.png',
					'required' => array( array( 'theme_layout', '=', true ) )
						
				),
                'light' => array(
					'type'     => 'image_select',
                    'id'       => 'light',
                    'img' =>  get_template_directory_uri() . '/assets/images/light.png',
					'required' => array( array( 'theme_layout', '=', true ) )
                ),
			 ), 
            ),
		),
	)
);

Redux::setSection( $opt_name, array(
	'title' => __( 'Sidebar', 'astrologer' ),
	'id'    => 'general-sidebar',
	'icon'          => 'dashicons dashicons-align-left',
	'fields'     => array(
		array(
			'id'       => 'sidebar_postion',
            'type'     => 'image_select',
            'title'    => __( 'Sidebar Position', 'astrologer' ),
            'desc'     => __( 'Select sidebar position as you want to show on page.', 'astrologer' ),
            
            'options'  => array(
                'full' => array(
                    'alt' => 'No sidebar',
                    'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                ),
                'left' => array(
                    'alt' => 'Left Sidebar',
                    'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                ),
                'right' => array(
                    'alt' => 'Right Sidebar',
                    'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                ),
				'both' => array(
                    'alt' => 'Both Side Sidebars',
                    'img' => ReduxFramework::$_url . 'assets/img/3cm.png'
                ),
            ),
            'default'  => 'right'
		),
	)
) );
Redux::setSection( $opt_name, array(
	'title' => __( '404 Page Setting', 'astrologer' ),
	'id'    => '404_colors',
	'desc'  => __( '', 'astrologer' ),
	'icon'  => 'el el-shopping-cart',
	'fields'     => array(
	    array(
			'id'       => 'err_title',
			'type'     => 'text',
			'title'    => __( 'Enter Title', 'astrologer' ),
			'default'    => '',
			),
		array(
			'id'       => 'error_404_desc',
			'type'     => 'textarea',
			'title'    => __( 'Enter Description', 'astrologer' ),
			'default'    => '',
			),
		array(
			'id'       => 'error_404_image',
			'type'     => 'media', 
			'url'      => true,
			'title'    => __('Uploa 404  Image', 'astrologer'),
			'desc'     => __('', 'astrologer'),
			),
	    )
    ) );
 
Redux::setSection( $opt_name, array(
	'title'      => __( 'Footer', 'astrologer' ),
	'id'         => 'general-footer',
	'icon'  => 'el el-credit-card',
	
	'fields'     => array(
	    array(
			'id'       => 'footer_bg_image',
			'type'     => 'media', 
			'url'      => true,
			'title'    => __('Upload Footer Background Image', 'astrologer'),
			'desc'     => __('please Upload Image', 'astrologer'),
			),
		array(
			'id'       => 'footer_bg_color',
			'type'     => 'color', 
			'title'    => __('Footer Background color', 'astrologer'),
			'default' => '#031d2e',
			),
		array(
			'id'       => 'copyright_bg_color',
			'type'     => 'color', 
			'title'    => __('Copyright Background color', 'astrologer'),
			'default' => '#17384e'
			),
		array(
			'id'       => 'footer_text',
			'type'     => 'text',
			'title'    => __( 'Copyright Text', 'astrologer' ),
			'default'  => '',
		   ),
		array(
			'id'       => 'footer_menu_switcher',
			'type'     => 'switch',
			'title'    => __('Footer Menu Enable/Disable','astrologer'),
			'default'  => false
		  ),  
        array(
			'id'       => 'footer_bottomtotop_switcher',
			'type'     => 'switch',
			'title'    => __('Bottom To Top Button Enable/Disable','astrologer'),
			'default'  => false
		  ),  		  
	    )
    ) );
	Redux::setSection( $opt_name, array(
		'title'      => __( 'API Setting', 'astrologer' ),
		'id'         => 'general-api',
		'icon'  => 'el el-credit-card',
		'fields'     => array(
		array(
		   'id' => 'section-prokerala-start',
		   'type' => 'section',
		   'title' => __('Prokerala API Settings', 'astrologer'),
		   'indent' => true 
		),
		array(
			'id'       => 'prokerala_api',
			'type'     => 'switch',
			'title'    => 'Prokerala Enable/Disable',
			'default'  => false,
			'desc' => __('To Get API related details visit: <b><a href="https://api.prokerala.com/">Prokerala</a></b>', 'astrologer'),
			),
		array(
			'id'       => 'pro_client_id',
			'type'     => 'text',
			'title'    => __( 'Prokerala client id', 'astrologer' ),
			'default'  => '',
			'required' => array( array( 'prokerala_api', '=', true ) )
			),
		array(
			'id'       => 'pro_client_secrete',
			'type'     => 'text',
			'title'    => __( 'Prokerala client Secrete', 'astrologer' ),
			'default'  => '',
			'required' => array( array( 'prokerala_api', '=', true ) )
			),
		array(
			'id'       => 'pro_location',
			'type'     => 'text',
			'title'    => __( 'Prokerala Location', 'astrologer' ),
			'default'  => 'Ujjain, India',
			'desc' => __( 'Kindly provide location like : <b>Ujjain, India</b>', 'astrologer' ),
			'required' => array( array( 'prokerala_api', '=', true ) )
			),
		array(
			'id'       => 'pro_location_cordinate',
			'type'     => 'text',
			'title'    => __( 'Prokerala Location Coordinates', 'astrologer' ),
			'default'  => '23.1765,75.7885',
			'desc' => __( 'Kindly provide cordination like : <b>23.1765,75.7885</b>', 'astrologer' ),
			'required' => array( array( 'prokerala_api', '=', true ) )
			),
		array(
			'id'       => 'pro_location_tz',
			'type'     => 'text',
			'title'    => __( 'Prokerala Location TZ', 'astrologer' ),
			'default'  => 'Asia/Kolkata',
			'desc' => __( 'Kindly provide location Time Zone like : <b>Asia/Kolkata</b>', 'astrologer' ),
			'required' => array( array( 'prokerala_api', '=', true ) )
			),
		array(
		   'id' => 'section-vedicastro-start',
		   'type' => 'section',
		   'title' => __('Vedicastro API Settings', 'astrologer'),
		   'indent' => true 
		),
		array(
			'id'       => 'vedicastro_switch',
			'type'     => 'switch',
			'title'    => 'Vedic Astro API Enable/Disable',
			'default'  => false,
			'desc' => __('To Get API related details visit: <b><a href="https://vedicastroapi.com/">Vedicastro</a></b>', 'astrologer'),
			),
		array(
			'id'       => 'vedicastro_api',
			'type'     => 'text',
			'title'    => __( 'Vedic Astro Api Key', 'astrologer' ),
			'default'  => '',
			'required' => array( array( 'vedicastro_switch', '=', true ) )
			),
		array(
			'id'       => 'vedicastro_latitude',
			'type'     => 'text',
			'title'    => __( 'Vedicastro Latitude', 'astrologer' ),
			'default'  => '23.1765',
			'desc' => __( 'Kindly provide cordination like : <b>23.1765</b>', 'astrologer' ),
			'required' => array( array( 'vedicastro_switch', '=', true ) )
			),
		array(
			'id'       => 'vedicastro_longitude',
			'type'     => 'text',
			'title'    => __( 'Vedicastro Longitude', 'astrologer' ),
			'default'  => '75.7885',
			'desc' => __( 'Kindly provide cordination like : <b>75.7885</b>', 'astrologer' ),
			'required' => array( array( 'vedicastro_switch', '=', true ) )
			),
		array(
			'id'       => 'vedicastro_location_tz',
			'type'     => 'text',
			'title'    => __( 'Vedicastro Location TZ', 'astrologer' ),
			'default'  => '5.5',
			'desc' => __( 'TimeZone in jumps of 0.5 - (ex: 5:30 will be 5.5, 5:45 will be 5.75)', 'astrologer' ),
			'required' => array( array( 'vedicastro_switch', '=', true ) )
			),
			
		 )
	) );	
	Redux::setSection( $opt_name, array(
	'title'      => __( 'Newsletter Settings', 'astrologer' ),
	'id'         => 'general-googlemap',
	'icon'  => 'fas fa-map-signs',
	'fields'     => array(
	   	array(
			'id'       => 'newsletter_switch',
			'type'     => 'switch',
			'title'    => 'News letter Enable/Disable',
			'default'  => false
		),
		array(
			'id'       => 'newsletter_heading',
			'type'     => 'text',
			'title'    => __( 'Heading', 'astrologer' ),
			'default'  => '',
			'required' => array( array( 'newsletter_switch', '=', true ) )
		   ), 
		   	array(
			'id'       => 'newsletter_des',
			'type'     => 'text',
			'title'    => __( 'Description', 'astrologer' ),
			'default'  => '',
			'required' => array( array( 'newsletter_switch', '=', true ) )
		   ),
		   array(
			'id'       => 'newsletter_placeholder',
			'type'     => 'text',
			'title'    => __('Placeholder', 'astrologer' ),
			'default'  => '',
			'required' => array( array( 'newsletter_switch', '=', true ) )
		   ),
		   array(
			'id'       => 'newsletter_email',
			'type'     => 'text',
			'title'    => __('Email', 'astrologer' ),
			'default'  => '',
			'required' => array( array( 'newsletter_switch', '=', true ) )
		   ),
		    array(
			'id'       => 'newsletter_button',
			'type'     => 'text',
			'title'    => __('Button', 'astrologer' ),
			'default'  => '',
			'required' => array( array( 'newsletter_switch', '=', true ) )
		   ),
		    array(
			'id'       => 'newsletter_apikey',
			'type'     => 'text',
			'title'    => __('Mailchimp Api Key', 'astrologer' ),
			'default'  => '',
			'required' => array( array( 'newsletter_switch', '=', true ) )
		   ),
		    array(
			'id'       => 'mailchimp_listid',
			'type'     => 'text',
			'title'    => __('Mailchimp List ID', 'astrologer' ),
			'default'  => '',
			'required' => array( array( 'newsletter_switch', '=', true ) )
		   ),
	    )
    ) );  
Redux::setSection( $opt_name, array(
	'title' => __( 'Appearance', 'astrologer' ),
	'id'    => 'astrologer-appearance',
	
	'icon'  => 'dashicons dashicons-welcome-view-site'
) );

Redux::setSection( $opt_name, array( 
		'title' => __( 'General Settings', 'astrologer' ),
		'id'    => 'astrologer-general-appearance',
		'subsection' => true,
		'fields'     => array(
			array(
				'id'       => 'section-theme-color',
				'type'     => 'section',
				'title'    => __( 'Theme Color Settings', 'astrologer' ),
				'subtitle' => __( 'Theme Color settings will be applicable for all theme color except shortcode related colors.', 'astrologer' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				"type"  => "color",		
				"title" => __( "Body Background Color", "astrologer" ),
				'desc'     => __('This will change the body background color.', 'astrologer'),
				"id" 	=> "theme_bg_color",
				'default' => '#07273c',
			  ),
			array(
				"type" => "color",		
				"title" => __( "Gradient Color 1", "astrologer" ),
				"id" => "grad_color_one",
				"default" => "#07273c",
			 ),
			  array(
				"type" => "color",		
				"title" => __( "Gradient Color 2", "astrologer" ),
				"id" => "grad_color_two",
				"default" => "#999999",
			 ),
			  array(
				"type" => "color",		
				"title" => __( "Solid Background Color", "astrologer" ),
				"id" => "solid_primary_color",
				'default' => '#ff7010',
			 ),
			   array(
				"type" => "color",		
				"title" => __( "Primary light Background Color", "astrologer" ),
				"id" => "primary_light_color",
				'default' => '#ff7010',
			 ),
			 array(
				"type" => "color",		
				"title" => __( "Secondary Color", "astrologer" ),
				"id" => "secondary_color",
				'default' => '#07273c',
			 ),
			 array(
				"type" => "color",		
				"title" => __( "Body Title Color", "astrologer" ),
				'desc'     => __('This will change the body Title color.', 'astrologer'),
				"id" => "body_title_color",
				'default' => '#fff',
			 ),
			 array(
				"type" => "color",		
				"title" => __( "Body Font Color", "astrologer" ),
				'desc'     => __('This will change the body Font color.', 'astrologer'),
				"id" => "body_font_color",
				'default' => '#e5f0f5',
			  ),
			  array(
				"type" => "color",		
				"title" => __( "Input Field Background Color", "astrologer" ),
				'desc'     => __('This will change the Input field Background Color.', 'astrologer'),
				"id" => "input_field_bg_color",
				'default' => '#10334a',
			  ),
			  array(
				"type" => "color",		
				"title" => __( "Alternate Background Color", "astrologer" ),
				'desc'     => __('This will change the alternate Background Color.', 'astrologer'),
				"id" => "alternate_bg",
				'default' => '#383838',
			  ),
			  array(
				"type" => "color",		
				"title" => __( "Button Hover Background Color", "astrologer" ),
				'desc'     => __('This will change the button hover background color.', 'astrologer'),
				"id" => "button_hover_color",
				'default' => '#234a64',
			  ),
			array(
				'type'  => 'text',		
				"title" => __( "Heading Size", "astrologer" ),
				'desc'     => __('This will change the heading size.', 'astrologer'),
				"id" => "body_heading_size",
				'default' => '35px',
			  ),
			array(
				'type'  => 'text',		
				"title" => __( "Body Font Size", "astrologer" ),
				'desc'     => __('This will change the heading font size.', 'astrologer'),
				"id" => "body_font_size",
				'default' => '16px',
			),
			array(
				'type'  => 'text',		
				"title" => __( "Button And Input Field Border Radius", "astrologer" ),
				'desc'     => __('This will change the button and input field border radius.', 'astrologer'),
				"id" => "button_border_radius",
				'default' => '1px'
			),
			array(
				'id'       => 'section-theme-loader-start',
				'type'     => 'section',
				'title'    => __( 'Page Loader', 'astrologer' ),
				'indent'   => true,
			),
			array(
				'id'       => 'page_loader',
				'type'     => 'media', 
				'url'      => true,
				'title'    => __('Upload Loader Image', 'redux-framework-demo'),
				'desc'     => __('Loader will work on front page of the site.', 'astrologer'),
			),
			array(
				"type" => "color",		
				"title" => __( "Loader Background Color", "astrologer" ),
				"id" => "loader_bak_clr",
				'default'  => "#ffffff"
			),
			array(
				'id'       => 'section-theme-backtotop-start',
				'type'     => 'section',
				'title'    => __( 'Back To Top Button', 'astrologer' ),
				'indent'   => true,
		 	   ),
			array(
				'id'       => 'backtotop',
				'type'     => 'switch',
				'title'    => 'Button',
				'default'  => false
			    ),
			array(
				'id'       => 'bakToTop_align',
				'type'     => 'select',
				'title'    => __('Alignment', 'astrologer'),
				'options'  => array(
					'left' => 'Left',
					'right' => 'Right',
					'center' => 'Center'
				),
				'default'  => 'right',
				'required' => array( array( 'backtotop', '=', true ) )
			),
			array(
				'id'       => 'backtotop_color',
				'type'     => 'color',
				'title'    => __( 'Button Color', 'astrologer' ),
				'default' => '#5575e3',
				'required' => array( array( 'backtotop', '=', true ) )
			),
			array(
				'id'       => 'backtotop_custom',
				'type'     => 'media', 
				'url'      => true,
				'title'    => __('Upload Custom Image', 'redux-framework-demo'),
				'desc'     => __('You can custom image for back to top button.', 'astrologer'),
				'required' => array( array( 'backtotop', '=', true ) )
			),
		)
) );

Redux::setSection( $opt_name, array(
	'title' => __( 'WooCommerce Styles', 'astrologer' ),
	'id'    => 'woo_colors',
	'desc'  => __( 'These settings will be applicable for Woocommerce templates. ', 'astrologer' ),
	'icon'  => 'el el-shopping-cart',
	'fields'     => array(
		array(
		   'id' => 'section-woo-start',
		   'type' => 'section',
		   'title' => __('Main Settings', 'astrologer'),
		   'indent' => true 
	     ),
		array(
			'id'       => 'woo_sidebar_postion',
            'type'     => 'image_select',
            'title'    => __( 'Woocommerce Sidebar Position', 'astrologer' ),
            'desc'     => __( 'Select sidebar position as you want to show on products realted page.', 'astrologer' ),
            'options'  => array(
                'full' => array(
                    'alt' => 'No sidebar',
                    'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                ),
                'left' => array(
                    'alt' => 'Left Sidebar',
                    'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                ),
                'right' => array(
                    'alt' => 'Right Sidebar',
                    'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                ),
				'both' => array(
                    'alt' => 'Both Side Sidebars',
                    'img' => ReduxFramework::$_url . 'assets/img/3cm.png'
                ),
            ),
            'default'  => 'right'
		),
	  )
 ) );
 
Redux::setSection( $opt_name, array(
	'title'      => __( 'Social', 'astrologer' ),
	'desc'       => __( 'You can set social url.', 'astrologer' ),
	'id'         => 'general-social',
	'icon'  => 'dashicons dashicons-twitter',
	'fields'     => array(
		array(
		   'id' => 'section-socials-start',
		   'type' => 'section',
		   'title' => __('Add Social Page URL', 'astrologer'),
		   'indent' => true 
		   ),
		array(
			'id'       => 'astrologer_facebook',
			'type'     => 'text',
			'title'    => __( 'Facebook', 'astrologer' ),
			'default'    => 'https://www.facebook.com/',
			),
		array(
			'id'       => 'astrologer_twitter',
			'type'     => 'text',
			'title'    => __( 'Twitter', 'astrologer' ),
			'default'    => 'https://twitter.com/',
		   ),
		array(
			'id'       => 'astrologer_instagram',
			'type'     => 'text',
			'title'    => __( 'Instagram', 'astrologer' ),
			'default'    => 'https://www.instagram.com/',
		   ),
		array(
			'id'       => 'astrologer_linkedIn',
			'type'     => 'text',
			'title'    => __( 'LinkedIn', 'astrologer' ),
		   ),
		array(
			'id'       => 'astrologer_youtube',
			'type'     => 'text',
			'title'    => __( 'Youtube', 'astrologer' )
		   ),
	   )
) );
 
Redux::setSection( $opt_name, array(
		'title' => __( 'Google Analytics/AdSense', 'astrologer' ),
		'id'    => 'astrologer-google_analytics',
		'icon'  => 'dashicons dashicons-chart-area',
		'fields'     => array(
			array(
				'id'       => 'analytics_script',
				'type'     => 'textarea',
				'title'    => 'Add Script',
				'desc'  => __('Enter Google Analytics/AdSense script here.After adding it, you can add your add script on any place of the page using WP editor or Text Widget.', 'astrologer'),
			)
		)
) );

Redux::setSection( $opt_name, array(
		'title' => __( 'Custom Code', 'astrologer' ),
		'id'    => 'astrologer-custom-code',
		'icon'  => 'dashicons dashicons-editor-code',
		'fields'     => array(
			array(
                'id'       => 'astrologer_custom_css',
                'type'     => 'ace_editor',
                'title'    => __( 'CSS Code', 'astrologer' ),
                'subtitle' => __( 'Paste your CSS code here.', 'astrologer' ),
                'mode'     => 'css',
                'theme'    => 'monokai',
                'default'  => "#yourIdORClass{\n   margin: 0 auto;\n}"
            ),
            array(
                'id'       => 'astrologer_custom_js',
                'type'     => 'ace_editor',
                'title'    => __( 'JS Code', 'astrologer' ),
                'subtitle' => __( 'Paste your JS code here.', 'astrologer' ),
                'mode'     => 'javascript',
                'theme'    => 'chrome',
                'default'  => "jQuery(document).ready(function(){\n\n});"
            ),
		)
) );

/*
 * <--- END SECTIONS
 */