<?php
/**
  * Register Testimonial Post Type
**/
add_action( 'init', 'astrologer_testimonial_post_type' );
function astrologer_testimonial_post_type() {
	$labels = array(
		'name'               => esc_html_x( 'Testimonial', 'Testimonial', 'astrologer' ),
		'singular_name'      => esc_html_x( 'Testimonial', 'Testimonial', 'astrologer' ),
		'menu_name'          => esc_html_x( 'Testimonials', 'admin menu', 'astrologer' ),
		'name_admin_bar'     => esc_html_x( 'Testimonials', 'add new on admin bar', 'astrologer' ),
		'add_new'            => esc_html_x( 'Add New', 'Testimonial', 'astrologer' ),
		'add_new_item'       => esc_html__( 'Add New Testimonial', 'astrologer' ),
		'new_item'           => esc_html__( 'New Testimonial', 'astrologer' ),
		'edit_item'          => esc_html__( 'Edit Testimonial', 'astrologer' ),
		'view_item'          => esc_html__( 'View Testimonial', 'astrologer' ),
		'all_items'          => esc_html__( 'All Testimonials', 'astrologer' ),
		'search_items'       => esc_html__( 'Search Testimonial', 'astrologer' ),
		'parent_item_colon'  => esc_html__( 'Parent Testimonial:', 'astrologer' ),
		'not_found'          => esc_html__( 'No Testimonial found.', 'astrologer' ),
		'not_found_in_trash' => esc_html__( 'No Testimonial found in Trash.', 'astrologer' )
	);
   
	$args = array(
		'labels'             => $labels,
        'description'        => esc_html__( 'Description.', 'astrologer' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'testimonial' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'show_in_rest' 		 => true,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail' ),
		'menu_icon'			 => 'dashicons-format-status'	
	);

	register_post_type( 'testimonial', $args );
}
add_action( 'init', 'astrologer_testimonial_category' );
function astrologer_testimonial_category() {
	register_taxonomy(
		'testi_cat',
		'testimonial',
		array(
			'rewrite' => array( 'slug' => 'testimonial-category' ),
			'label' => esc_html__( 'Testimonial Category', 'astrologer' ),
			'hierarchical' => true,
			'show_in_rest' => true,
		)
	);
}
/**
* team Custom post
*/
add_action( 'init', 'astrologer_team_post_type' );
function astrologer_team_post_type() {
	$labels = array(
		'name'               => esc_html_x( 'Team', 'Team', 'astrologer' ),
		'singular_name'      => esc_html_x( 'Team', 'Team', 'astrologer' ),
		'menu_name'          => esc_html_x( 'Teams', 'admin menu', 'astrologer' ),
		'name_admin_bar'     => esc_html_x( 'Teams', 'add new on admin bar', 'astrologer' ),
		'add_new'            => esc_html_x( 'Add New', 'Team', 'astrologer' ),
		'add_new_item'       => esc_html__( 'Add New Team', 'astrologer' ),
		'new_item'           => esc_html__( 'New Team', 'astrologer' ),
		'edit_item'          => esc_html__( 'Edit Team', 'astrologer' ),
		'view_item'          => esc_html__( 'View Team', 'astrologer' ),
		'all_items'          => esc_html__( 'All Teams', 'astrologer' ),
		'search_items'       => esc_html__( 'Search Team', 'astrologer' ),
		'parent_item_colon'  => esc_html__( 'Parent Team:', 'astrologer' ),
		'not_found'          => esc_html__( 'No Team found.', 'astrologer' ),
		'not_found_in_trash' => esc_html__( 'No Team found in Trash.', 'astrologer' )
	);
   
	$args = array(
		'labels'             => $labels,
        'description'        => esc_html__( 'Description.', 'astrologer' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'team' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'show_in_rest' 		 => true,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail' ),
		'menu_icon'			 => 'dashicons-format-status'	
	);

	register_post_type( 'team', $args );
}
/**
* Team category for custom post
**/
add_action( 'init', 'astrologer_team_category' );
function astrologer_team_category() {
	register_taxonomy(
		'testi_cat',
		'team',
		array(
			'rewrite' => array( 'slug' => 'team-category' ),
			'label' => esc_html__( 'Team Category', 'astrologer' ),
			'hierarchical' => true,
			'show_in_rest' => true,
		)
	);
}
?>