<?php
/**
 *Add shortcode js_composer
 */
if(!function_exists('astro_event_shortcodes_map')):
add_action( 'vc_before_init', 'astro_event_shortcodes_map' );
function astro_event_shortcodes_map(){
	
	$icon_path = plugin_dir_url( __FILE__ ) . '/icons/';
	$preview_path = plugin_dir_url( __FILE__ ) . '/previews/';
    
    vc_map( array(
      "name" => __("Event Listing", "astro"),
      "base" => "event_listing_shortcode",
	  "category" => __('Event','astro'),
	  "icon"	 => $icon_path . 'Event-Listing.png',
	  "params" => array(
		    array(
				"type" => "textfield",
				"holder" => "div",
				"heading" => __("Event Listing Number",'astro'),
				"param_name" => "listnumber",
				"description" => __("Enter number of show.",'astro'),
			   ),
			array(
                'type' => 'dropdown',
                'heading' => __( 'Event list style',  "astro" ),
                'param_name' => 'liststyle',
                'value' => array(
                        __('Default', "astro") => 'default',
                        __('Minimal', "astro") => 'minimal',
                        __('Native', "astro") => 'native',
                        __('List', "astro") => 'list',
                        __('Grid', "astro") => 'grid',
                        __('Timeline Vertical', "astro") => 'vertical',
                        __('Timeline Horizontal', "astro") => 'horizontal',
                        __('Carousal Grid', "astro") => 'carousalgrid',
                        __('Carousal List', "astro") => 'carousallist',
                        __('Carousal Minimal', "astro") => 'carousalminimal',
                        __('Carousal Native', "astro") => 'carousalnative',
                        
                      )
                ),
				
			array(
                'type' => 'dropdown',
                'heading' => __( 'Columns',  "astro" ),
                'param_name' => 'cols',
                'value' => array( '2' => '2', '3' => '3', '4' => '4' ),
				'dependency' => array(
					'element' => 'liststyle',
					'value' => 'grid'
				)
            ),
			
			array(
                'type' => 'textfield',
                'heading' => __( 'Filter By City',  "astro" ),
                'description' => __( 'Enter city name here, by which you want to filter the events.',  "astro" ),
                'param_name' => 'filter_city',
            ),
			array(
                'type' => 'textfield',
                'heading' => __( 'Filter By Country',  "astro" ),
                'description' => __( 'Enter Country name here, by which you want to filter the events.',  "astro" ),
                'param_name' => 'filter_country',
            ),
            
            array(
                "type"  => "checkbox",
                "admin_label"   => true,
                "weight"    => 10,
                "heading"    => __( "Pagination", "astro" ),
                "description"   => __("", "astro"),
                "value"  => __('on','astro'),
                "param_name"    => "pagination"
                ),
				array(
					"type" => "mcom_shortcode_preview",
					"group" => "Preview",
					"param_name" => "preview",
					"url" => $preview_path . 'event-listing.jpg',
				),
	  	   )
    ) );

   /**
    * Event Add To Cart Section
    */ 
    vc_map( array(
        "name" => __("Event Add To Cart", "astro"),
        "base" => "event_addtocart_shortcode",
        "category" => __('Event','astro'),
		"icon"	 => $icon_path . 'Event-add-to-card.png',
        "params" => array(
              
                array(
				   "type" => "textfield",
				   "holder" => "div",
				   "heading" => __("Event Listing Number",'astro'),
				   "param_name" => "listnumber",
				   "description" => __("Enter number of show.",'astro'),
			      ),
				  array(
					"type" => "mcom_shortcode_preview",
					"group" => "Preview",
					"param_name" => "preview",
					"url" => $preview_path . 'event-add-tocart.jpg',
				  ),
			      
             )
   ));   
   
/**
* Event Calender
*/ 
    vc_map( array(
        "name" => __("Event Calender", "astro"),
        "base" => "event_calender_shortcode",
        "category" => __('Event','astro'),
		"icon"	 => $icon_path . 'Event-Calendar.png',
		"show_settings_on_create" => false,
		"params" => array(
			array(
				"type" => "mcom_shortcode_preview",
				"group" => "Preview",
				"param_name" => "preview",
				"url" => $preview_path . 'calender.jpg',
			  ),
		)
    ));
   
/**
* Events City List
*/ 
    vc_map( array(
        "name" => __("City List", "astro"),
        "base" => "event_citylist",
        "category" => __('Event','astro'),
		"icon"	 => $icon_path . 'Event-Calendar.png',
		"show_settings_on_create" => false,
		"params" => array(
			array(
				"type" => "mcom_shortcode_preview",
				"group" => "Preview",
				"param_name" => "preview",
				"url" => $preview_path . 'city-list.jpg',
			  ),
		)
    ));
	
/**
* Events Speakers List
*/ 

    vc_map( array(
        "name" => __("Speakers List", "astro"),
        "base" => "event_speakers",
        "category" => __('Event','astro'),
		"icon"	 => $icon_path . 'Event-Calendar.png',
		"params" => array(
                array(
				   "type" => "textfield",
				   "holder" => "div",
				   "heading" => __("Event ID",'astro'),
				   "param_name" => "event_id",
				   "description" => __("To get the speakers of perticular event, enter event id here.",'astro')
			      ),
				  array(
					"type" => "mcom_shortcode_preview",
					"group" => "Preview",
					"param_name" => "preview",
					"url" => $preview_path . 'speakers.jpg',
				  ),
             )
    ));	
   
}
endif;