<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="hl-table-booking">
            <?php 
            $booking_calendar_heading = get_option('cafe_booking_calendar_heading');
            if(!empty($booking_calendar_heading)):
               echo '<h2 class="hl-room-title">'.esc_html($booking_calendar_heading).'</h2>';
            endif;
            ?>
             <div id="booking_date"></div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="hl-event-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      <div class="modal-body">
        <div class="hl-event-booking-form">
          <div class="hl-form-close">
            <span></span>
          </div>
          <form id="Astro_cafe_booking" name="Astro_cafe_booking" method="post" action="<?php echo esc_attr($_SERVER['PHP_SELF']);?>">
            <?php 
            $booking_form_heading = get_option('cafe_booking_form_heading');
            if(!empty($booking_form_heading)):
            ?><h4><?php echo esc_html($booking_form_heading); ?></h4>
            <?php endif; ?>
            <ul>  
                <li>
                <label><?php echo esc_html__('Name','astro'); ?></label>
                <input type="text" name="cust_name" id="cust_name">
                </li>
                <li>
                <label><?php echo esc_html__('Email','astro'); ?></label>
                <input type="text" name="cust_email" id="cust_email">
                </li>
                <li>
                <label><?php echo esc_html__('Phone','astro'); ?></label>
                <input type="number" name="cust_number" id="cust_number">
                </li>
                <li>
                <label><?php echo esc_html__('Event Type','astro'); ?></label>
                <select name="cafe_event_type" id="cafe_event_type">
                    <option value="">
                      <?php echo esc_html__('Select Event','astro'); ?></option>
                    <option value="<?php echo esc_attr__('Birthday','astro'); ?>"><?php echo esc_html__('Birthday','astro'); ?></option>
                    <option value="<?php echo esc_attr__('Anniversary','astro'); ?>"><?php echo esc_html__('Anniversary','astro'); ?></option>
                    <option value="<?php echo esc_attr__('Office Party','astro'); ?>"><?php echo esc_html__('Office Party','astro'); ?></option>
                    <option value="<?php echo esc_attr__('Dating','astro'); ?>"><?php echo esc_html__('Dating','astro'); ?></option>
                    <option value="<?php echo esc_attr__('Other','astro'); ?>"><?php echo esc_html__('Other','astro'); ?></option>
                </select>
                </li>

                <li>
                    <label><?php echo esc_html__('Booking Date','astro'); ?></label>
                    <input type="text" value="20-10-2021" id="booking_cafe_date" name="booking_cafe_date" id="booking_date" readonly>  
                </li>
                <li>
                    <label><?php echo esc_html__('Time','astro'); ?></label>
                    <input type="text" class="timepicker" name="booking_time" id="booking_time">
                </li>
                <li>
                    <label><?php echo esc_html__('No. of Guests','astro'); ?></label>
                    <input type="number" name="numberof_guests" id="numberof_guests" min="1">
                </li>
                <li>
                    <label><?php echo esc_html__('Message','astro'); ?></label>
                    <textarea name="cust_message" id="cust_message"></textarea>
                </li>
                <li>
                    <button class="hl-btn" id="cafe_books" name="cafe_books"><?php echo esc_html__('Submit','astro'); ?></button>
                </li> 
            </ul>
          </form>
        </div>
      </div>
    </div>
  </div>
</div> 
<div id="cafe_payment_option" class="modal">
   <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="modal-header">
          <?php 
          $booking_review_heading = get_option('cafe_booking_review_heading');
          if(!empty($booking_review_heading)):
          ?><h4><?php echo esc_html($booking_review_heading); ?></h4>
          <?php endif; ?>
        </div>
       <div class="modal-body">
        <div class="hl-payment-astro" id="hl_cafe_review_date"></div> 
        <!-- Stripe Payment Option -->
        <?php 
        $stripe_submit_url = plugins_url().'/astro-appointment/strippayment/astro-event-payment.php';
        $stripe_publishable_key = get_option('stripe_cafe_publishbale_key');
        $stripe_store_name = get_option('cafe_payment_form_heading');
        $currency = get_option('curreny_val'); 
        $confirmation_charge = $price_main = get_option('cafe_confirmation_charge');
        
        $stripe_store_description = '';
        $stripe_logo_image = ''; 
        $email = '';
        if(!empty($_COOKIE['email'])):
            $email = $_COOKIE['email'];
        endif;
		
		$tax_title = get_option('tax_title');
		$text_percent = get_option('text_percent');
		if(!empty($tax_title) && !empty($text_percent)){
		    $price = $confirmation_charge;
		    $tax = ($price*$text_percent)/100;
	    	$confirmation_charge = $tax + $price;			
			?> 
			<p><?php echo esc_html__('You have booked an order of '.$currency .' '. $price_main .'  and '.$tax_title. '  ' . $text_percent .'% Tax on your order and your Total Price '.$currency .' '.$confirmation_charge ); ?></p>
		<?php 
				}
			?>
			<div class="payment-form">
                <form action="<?php echo esc_url($stripe_submit_url); ?>" method="post" id="form_data_strip">
                <script src="https://checkout.stripe.com/checkout.js" class="stripe-button"
                    data-key="<?php echo esc_attr($stripe_publishable_key); ?>"
                    data-name="<?php echo esc_attr($stripe_store_name); ?>"
                    data-amount="<?php echo esc_attr($confirmation_charge*100); ?>"
                    data-currency=<?php echo esc_attr($currency); ?>
                    data-email="<?php echo esc_attr($email); ?>"
                    data-locale="auto"></script>
                    <input type="hidden" name="strip_cust_name" id="strip_cust_name" value="" class="strip_cust_name"> 
                    <input type="hidden" name="eamil" id="eamil" value="" class="eamil">  
        			<input type="hidden" name="contact_number" id="contact_number" value="" class="contact_number">  
                    <input type="hidden" name="confirmation_charge" id="confirmation_charge" value="<?php echo esc_attr($confirmation_charge); ?>">  
                    <input type="hidden" name="event_type" id="event_type" value="" class="event_type"> 
                    <input type="hidden" name="num_of_guests" id="num_of_guests" value="" class="num_of_guests">    
                    <input type="hidden" name="strip_cust_message" id="strip_cust_message" value="" class="strip_cust_message">  
                    <input type="hidden" name="strip_booking_date" id="strip_booking_date" value="" class="strip_booking_date"> 
                    <input type="hidden" name="strip_booking_time" id="strip_booking_time" value="" class="strip_booking_time">
        			<input type="hidden" name="new_price" id="new_price" value="<?php echo esc_attr($confirmation_charge); ?>"> 
        			<input type="hidden" name="tax_name_n" id="tax_name_n" value="<?php echo esc_attr($tax_title); ?>"> 
        			<input type="hidden" name="text_percent_n" id="text_percent_n" value="<?php echo esc_attr($text_percent); ?>"> 
                   </form> 
        		<?php
        			// Razorpay Payment form
        			$razorpay_url= plugins_url().'/astro-appointment/razorpay/event-payment-process.php';
        			$razorpay_key = get_option('cafe_razorpay_key');
        			$razorpay_success_url = get_option('cafe_razorpay_success_url');
        			$razorpay_cancel_url = get_option('cafe_razorpay_cancel_url');
        			$currency = get_option('curreny_val');
        			$tax_title = get_option('tax_title');
        			$text_percent = get_option('text_percent');
        			?>
        			<form action="" method="post" id="form_data_razorpay_cafe">
        				<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
        				<input type="hidden" name="strip_cust_name" id="strip_cust_name" value="" class="strip_cust_name"> 
        				<input type="hidden" name="eamil" id="eamil" value="" class="eamil">  
        				<input type="hidden" name="contact_number" id="contact_number" value="" class="contact_number">  
        				<input type="hidden" name="event_type" id="event_type" value="" class="event_type"> 
        				<input type="hidden" name="num_of_guests" id="num_of_guests" value="" class="num_of_guests">    
        				<input type="hidden" name="strip_cust_message" id="strip_cust_message" value="" class="strip_cust_message">  
        				<input type="hidden" name="strip_booking_date" id="strip_booking_date" value="" class="strip_booking_date"> 
        				<input type="hidden" name="strip_booking_time" id="strip_booking_time" value="" class="strip_booking_time">
        				<input type="hidden" name="razorpay" id="razorpay" value="<?php echo esc_attr($razorpay_key); ?>">
        				<input type="hidden" name="razorpay_success_url" id="razorpay_success_url" value="<?php echo esc_attr($razorpay_success_url); ?>">
        				<input type="hidden" name="razorpay_cancel_url" id="razorpay_cancel_url" value="<?php echo esc_attr($razorpay_cancel_url); ?>">
        				<input type="hidden" name="razorpay_url" id="razorpay_url" value="<?php echo esc_attr($razorpay_url); ?>">
        				<input type="hidden" name="amount" id="amount" value="<?php echo esc_attr($price_main); ?>"> 
        				<input type="hidden" name="new_price" id="new_price" value="<?php echo esc_attr($confirmation_charge); ?>"> 
        			<input type="hidden" name="tax_name_n" id="tax_name_n" value="<?php echo esc_attr($tax_title); ?>"> 
        			<input type="hidden" name="text_percent_n" id="text_percent_n" value="<?php echo esc_attr($text_percent); ?>">
        			<input type="submit" name="razorpay_submit" id="razorpay_submit" value="">
        		</div>
        </div>
      </div>
    </div>
</div>