<?php

/**
 * Fired during plugin activation
 *
 * @link       https://codecanyon.net/user/kamleshyadav
 * @since      1.0.0
 *
 * @package    Astro
 * @subpackage Astro/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Astro
 * @subpackage Astro/includes
 * @author     kamleshyadav <kamlesh.yadav@himanshusofttech.com >
 */
class Astro_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
        global $wpdb;
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        /**
		 * Astro Hotel Payment Option
		 */
		$table_name = $wpdb->prefix . 'hotel_room_booked';
		$charset_collate = $wpdb->get_charset_collate();
		$sql_create_table = "CREATE TABLE IF NOT EXISTS $table_name (
					`b_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
					`b_user_id` bigint(20) UNSIGNED NOT NULL,
					`b_room_id` bigint(20) UNSIGNED NOT NULL,
					`b_start_date` varchar(50) NOT NULL,
					`b_end_date` varchar(50) NOT NULL,
					`b_adults` varchar(50) NOT NULL, 
					`b_children` varchar(50) NOT NULL,
					`b_requirement` text NOT NULL,
					`b_requests` text NOT NULL,
					`b_txnid` varchar(100) NOT NULL,
					`b_payment_amount` double NOT NULL,
					`b_payment_status` varchar(20) NOT NULL,
					`b_timestamp` datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
					`b_customer_details` text NOT NULL,
					`b_payment_getway` varchar(20) NOT NULL,
					`b_hash` varchar(100) DEFAULT NULL,
					PRIMARY KEY  (b_id)
				) $charset_collate;";
				
		dbDelta($sql_create_table);
        /**
		 * Astro Event Table Booking Data
		 */
		$table_cafe_name = $wpdb->prefix . 'cafe_table_booked';
		$charset_cafe_collate = $wpdb->get_charset_collate();
		$sql_create_table = "CREATE TABLE IF NOT EXISTS $table_cafe_name (
					`bc_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
					`bc_user_id` bigint(20) UNSIGNED NOT NULL,
					`bc_table_id` bigint(20) UNSIGNED NOT NULL,
					`bc_booking_date` varchar(50) NOT NULL,  
					`bc_booking_time` varchar(50) NOT NULL, 
					`bc_txnid` varchar(100) NOT NULL,
					`bc_payment_amount` double NOT NULL,
					`bc_payment_status` varchar(20) NOT NULL,
					`bc_timestamp` datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
					`bc_customer_details` text NOT NULL,
					`bc_payment_getway` varchar(20) NOT NULL,
					 PRIMARY KEY  (bc_id)   
				) $charset_cafe_collate;";
		dbDelta($sql_create_table);

		/**
		 * Astro Appointment Schedule Booking List
		 */ 
		$table_appointment_schedule_name = $wpdb->prefix . 'appointment_schedule_booked';
		$charset_appointment_schedule_collate = $wpdb->get_charset_collate();
		$sql_create_table = "CREATE TABLE IF NOT EXISTS $table_appointment_schedule_name (
					`asb_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
					`asb_user_id` bigint(20) UNSIGNED NOT NULL,
					`asb_schedule_id` bigint(20) UNSIGNED NOT NULL,
					`asb_schedule_date` varchar(50) NOT NULL,  
					`asb_schedule_time` varchar(50) NOT NULL, 
					`asb_txnid` varchar(100) NOT NULL,
					`asb_payment_amount` double NOT NULL,
					`asb_payment_status` varchar(20) NOT NULL,
					`asb_timestamp` datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
					`asb_customer_details` text NOT NULL,
					`asb_payment_getway` varchar(20) NOT NULL,
					 PRIMARY KEY  (asb_id)   
				) $charset_appointment_schedule_collate;";
		dbDelta($sql_create_table);
    }  

} 