<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://codecanyon.net/user/kamleshyadav
 * @since      1.0.1
 *
 * @package    Astro
 * @subpackage Astro/email
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Astro
 * @subpackage Astro/email
 * @author     kamleshyadav <kamlesh.yadav@himanshusofttech.com >
 */
class Astro_Email {

     /**
	 * The ID of this plugin.
	 *
	 * @since    1.0.1
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.1
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.1
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name=false, $version=false ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}
    /**
     * Astro Email Template
     */
    public function Astro_email_template($product_id=false,$customer_email=false,$order_id=false){
        $header = get_option('email_form_heading');
		$subject = get_option('email_form_subject');
		$emailmessage = get_option('email_form_content');
		$html_temp = '';
		$html_temp = require_once('astro-email-content.php');
        $web_url = get_the_permalink($product_id); 
		$admin_email = get_option('admin_email');
		$headers = array('Content-Type: text/html; charset=UTF-8',$header);
		$multiple_emails = array(
			$admin_email, 
			$customer_email,
		);
		wp_mail($multiple_emails,$subject,$html_temp,$web_url,$headers); 
    } 
    
  
}