<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://codecanyon.net/user/kamleshyadav
 * @since             1.0.8
 * @package           Astro
 *
 * @wordpress-plugin
 * Plugin Name:       Astro Appointment 
 * Plugin URI:        https://kamleshyadav.com/wp/astrologer/demo1/
 * Description:       Astro Booking WordPress Plugin is an all together plugin with which you can manage  booking and appointment services online.
 * Version:           1.0.0
 * Author:            kamleshyadav
 * Author URI:        https://codecanyon.net/user/kamleshyadav
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       astro
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'Astro_VERSION', '1.0.8' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-astro-activator.php
 */
function Astro_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-astro-activator.php';
	Astro_Activator::activate();
}
   
/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-astro-deactivator.php
 */
function Astro_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-astro-deactivator.php';
	Astro_Deactivator::deactivate();
}
 
register_activation_hook( __FILE__, 'Astro_activate' );
register_deactivation_hook( __FILE__, 'Astro_deactivate' );
 
/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-astro.php';
/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_Astro() {

	$plugin = new Astro();
	$plugin->run();

}
run_Astro(); 