<div class="hl-main-wraper">
   <div class="container-fluid">
        <div class="hl-card-body">
            <div class="row">
                <div class="col-lg-12">
                    <div class="hl-hotal-tabs">
                        <ul>
                          <li>
                            <a href="<?php echo esc_url(admin_url('admin.php?page=hotel_rooms')); ?>"><img src="<?php echo esc_url(plugins_url(). '/astro-appointment/admin/images/bed.png'); ?>" alt="<?php esc_attr_e('Rooms icon ','astro'); ?>"><?php echo esc_html__('Rooms','astro'); ?></a>
                          </li>
                          <li>
                            <a href="<?php echo esc_url(admin_url('admin.php?page=hotel_booking')); ?>"><img src="<?php echo esc_url(plugins_url(). '/astro-appointment/admin/images/calendar.png'); ?>" alt="<?php esc_attr_e('Bookings icon','astro'); ?>"><?php echo esc_html__('Bookings','astro'); ?></a>
                          </li>
                          <li>
                            <a href="<?php echo esc_url(admin_url('admin.php?page=hotel_payment')); ?>"><img src="<?php echo esc_url(plugins_url(). '/astro-appointment/admin/images/credit-card.png'); ?>" alt="<?php esc_attr_e('Payment icon','astro'); ?>"><?php echo esc_html__('Payment Settings','astro'); ?></a>
                          </li>
                          <li>
                            <a href="<?php echo esc_url(admin_url('admin.php?page=hotel_form')); ?>"><img src="<?php echo esc_url(plugins_url(). '/astro-appointment/admin/images/form.png'); ?>" alt="<?php esc_attr_e('Form icon','astro'); ?>"><?php echo esc_html__('Form Settings','astro'); ?></a>
                          </li>   
                        </ul>
                     </div>
                </div>
            </div>
            <?php
            $user_info = get_userdata(get_current_user_id()); 
            ?>
            <h1 class="hl-heading-title"><?php echo esc_html__('Welcome:','astro'); ?> <?php echo esc_html($user_info->user_nicename);?> </h1>
            <div class="hl-data-analytics">
                <div class="row">
                    <div class="col-lg-3 col-md-6">
                        <div class="hl-category-box hl-purple-bg">
                            <?php 
                             $count_posts = wp_count_posts('rooms')->publish;
                             if(!empty($count_posts)):
                                echo '<h2>'.esc_html($count_posts).'</h2>';
                             else:
                                echo '<h2>'.esc_html__('0','astro').'</h2>';
                             endif;
                            ?>
                            <h3><?php echo esc_html__('Total Rooms','astro'); ?></h3> 
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="hl-category-box hl-blue-bg">
                        <?php 
                        global $wpdb;
                        $Astro_check_in = date("Y-m-d");
                        $Astro_check_out = date("Y-m-d"); 
                        $table_name = $wpdb->prefix.'hotel_room_booked';
                        $room_ids = array();
                        $book_results = $wpdb->get_results("SELECT * FROM $table_name Where b_start_date='$Astro_check_in'");
                        if(!empty($book_results)): 
                            foreach($book_results as $results):
                                $room_ids[] = $results->b_room_id;
                            endforeach;
                        endif;
                        $room_count = array(
                                'post_type'=>'rooms',
                                'post_status' =>'publish',
                                'post__not_in' => $room_ids,
			                    'posts_per_page' => -1,
                                );
                        $room_query = new WP_Query($room_count);
                        $numberOfPosts= $room_query->found_posts;
                        if(!empty($numberOfPosts)):
                            echo '<h2>'.esc_html($numberOfPosts).'</h2>';
                        else:
                            echo '<h2>'.esc_html__('0','astro').'</h2>';
                        endif;
                        ?>
                        <h3> 
                        <?php echo esc_html__('Available Room','astro'); ?>
                        </h3> 
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="hl-category-box hl-orange-bg">
                            <?php 
                            $room_ids = array();
                            $Astro_check_in = date("Y-m-d");
                            $book_results = $wpdb->get_results("SELECT * FROM $table_name Where b_start_date='$Astro_check_in'");
                            
                            if(!empty($book_results)): 
                                foreach($book_results as $results):
                                    $room_ids[] = $results->b_room_id;
                                endforeach;
                            endif;
                            if(!empty($room_ids)):
                            $room_chin_count = array(
                                'post_type'=>'rooms',
                                'post_status' =>'publish',
                                'post__in' => $room_ids,
			                    'posts_per_page' => -1,
                                );
                            else:
                               $room_chin_count = array();
                            endif;
                            $room_query = new WP_Query($room_chin_count);
                            $numberOfPosts= $room_query->found_posts;
                            if(!empty($numberOfPosts)):
                              echo '<h2>'.esc_html($numberOfPosts).'</h2>';
                            else:
                              echo '<h2>'.esc_html__('0','astro').'</h2>'; 
                            endif;
                            ?>
                            <h3><?php echo esc_html__('Check In','astro'); ?></h3>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="hl-category-box hl-pink-bg">
                        <?php 
                            $room_ids = array();
                            $Astro_check_out = date("Y-m-d");
                            $book_results = $wpdb->get_results("SELECT * FROM $table_name Where b_end_date='$Astro_check_out'");
                            if(!empty($book_results)): 
                                foreach($book_results as $results):
                                    $room_ids[] = $results->b_room_id;
                                endforeach;
                            endif;
                            if(!empty($room_ids)):
                            $room_chin_count = array(
                                'post_type'=>'rooms',
                                'post_status' =>'publish',
                                'post__in' => $room_ids,
			                    'posts_per_page' => -1,
                                );
                            else:
                               $room_chin_count = array();
                            endif;
                            $room_query = new WP_Query($room_chin_count);
                            $numberOfPosts= $room_query->found_posts;
                            if(!empty($numberOfPosts)):
                              echo '<h2>'.esc_html($numberOfPosts).'</h2>';
                            else:
                              echo '<h2>'.esc_html__('0','astro').'</h2>'; 
                            endif;
                            ?>
                            <h3><?php echo esc_html__('Check Out','astro'); ?></h3>
                        </div>
                    </div>
                </div>
            </div>
            
        </div> 
    </div>
</div>