<?php
/**
 * Astro Event Metabox 
 */
class Cafe_metabox{
    /**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;
    public $prefix;
    public $page_option_meta;
	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

        $this->prefix = 'cafe_';
        /**
         * Appointment  Meta Option  
         */ 
        $this->page_option_meta = array(
            'id' => 'section-page-meta',
            'title' => esc_html__('Event Disble Setting','astro'),
            'page' => 'cafe_date',
            'context' => 'normal',
            'priority' => 'high',
            'fields' => array(
                    array(
                        'name' => esc_html__('Set Disble Date','astro'),
                        'desc' => '', 
                        'id' => $this->prefix.'disble_datepicker', 
                        'type' => 'date_picker',
                        'std' => '',
                        'cls' => 'hide_row'
                       ),
                    )
               );
    } 
    /**
     * Event Add Meta Option
     */  
    public function cafe_add_meta_boxes(){
        $page_option_meta = $this->page_option_meta;
        add_meta_box($page_option_meta['id'], $page_option_meta['title'], array($this,'cafe_show_meta_options'), $page_option_meta['page'], $page_option_meta['context'], $page_option_meta['priority']);
    }
    /**
     * Event Add Meta Option
     */
    public function cafe_show_meta_options(){
        global $post;
        $page_option_meta = $this->page_option_meta;
        $val = '';
		// Use nonce for verification
		echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
		echo '<table class="form-table hl-room-setting-wrap">';
		foreach ($page_option_meta['fields'] as $field) {
			// get current post meta data
			$meta = get_post_meta($post->ID, $field['id'], true);
			switch ($field['type']) {
				case 'sidebarradio':
					echo '<tr>',
					'<th><label for="', esc_attr($field['id']), '"><strong>', esc_html($field['name']), '</strong><span>' . esc_html($field['desc']). '</span></label></th>',
					'<td>';
					if(empty($meta)){
						$meta = 'full';
					}
					foreach($field['option'] as $k=>$v){
						echo '<div class="', ($meta == $k) ? 'fishing_chooseborder '
						: '' ,'fishing-select-sidebar">
						<div>
						<input type="radio" value="'.esc_attr($k).'" ',($meta == $k) ? 'checked'
						: '','  name="'.esc_attr($field['id']).'" ></div>';
						echo '<img src="'.esc_url($v).'" alt="'.esc_attr__('event image','astro').'"></div>';
					}
				break;
				case 'text':
					echo '<tr>',
					'<th><label for="', esc_attr($field['id']), '"><strong>', esc_attr($field['name']), '</strong><span>' .esc_attr($field['desc']). '</span></label></th>',
					'<td>';
					echo '<input type="text" name="', esc_attr($field['id']), '" id="', $field['id'], '" value="', $meta ? stripslashes(htmlspecialchars(($meta), ENT_QUOTES))
						: stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '"/>';
                break;
				case 'select':
                echo '<tr>',
                    '<th><label for="', esc_attr($field['id']), '"><strong>', esc_attr($field['name']), '</strong><span>' . esc_attr($field['desc']). '</span></label></th>',
                   '<td>';
                echo'<select name="' . esc_attr($field['id']) . '">';
                    foreach ($field['options'] as $k=>$v) {

                        echo'<option';
                        if ($meta == $k) {
                            echo ' selected="selected"';
                        }
                        echo' value="'.esc_attr($k).'">' . esc_attr($v). '</option>';

                    }
                echo'</select>';
                break;
                case 'textarea':
                    echo '<tr class="'.($val == 'quote' ? '' : $field['cls']).'">',
                        '<th><label for="', esc_attr($field['id']), '"><strong>', esc_html($field['name']), '</strong><span>' . esc_html($field['desc']) . '</span></label></th>',
                        '<td>';
                        $args = array(
                            'textarea_rows' => 5,
                            'media_buttons' => true,
                            'teeny' => true,
                            'quicktags' => true,
                            'tinymce'=> array(
                                'toolbar1'=> 'bold,italic,underline,bullist,numlist,justifyleft,justifycenter,justifyright,undo,redo'
                            )
                        );
                        wp_editor($meta ? $meta : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), $field['id'],$args);
                    echo '</tr>';
                break;
                case 'date_picker':
                    echo '<tr class="'.($val == 'quote' ? '' : $field['cls']).'">',
                    '<th><label for="', esc_attr($field['id']), '"><strong>', esc_html($field['name']), '</strong><span>' . esc_html($field['desc']). '</span></label></th>',
                    '<td>';
                    echo '<input type="text" name="', esc_attr($field['id']), '" id="', esc_html($field['id']), '" value="', $meta ? stripslashes(htmlspecialchars(($meta), ENT_QUOTES))
						: stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '"/>';
                    echo '</td></tr>';
                break;
                case 'schedule_time_picker':
                    $schedule_times = get_post_meta(get_the_ID(), 'schedule_times_datas', true );
                     echo '<tr class="'.($val == 'quote' ? '' : $field['cls']).'">',
                           '<th><label for="', esc_attr($field['id']), '"><strong>', esc_html($field['name']), '</strong><span>' . esc_html($field['desc']). '</span></label></th>
                           <td>';
                    if(!empty($schedule_times)):
                        foreach($schedule_times as $sc_time):
                           echo '<div><input type="text" name="schedule_times[]" class="hl_schedule_times_picker" value="'.esc_attr($sc_time).'"/><a href="javascript:void(0);" class="remove_button">'.esc_html('Remove','astro').'</a></div>';
                        endforeach;
                    endif;
                    echo '<div id="schedule_time_pickers"></div>',
                         '<input type="button" value="'.esc_html__('Add Time Schedule','astro').'" class="hl-add-schedule" id="hl_add_schedule"/>
                          </td> 
                         </tr>';
                break;
                case 'gallery_image':
                $gallery_data = get_post_meta(get_the_ID(), 'gallery_data', true );
                echo '<tr class="'.($val == 'quote' ? '' : $field['cls']).'">';
                ?>
                <th>
                <div style="display:none" id="master-row">
                    <div class="field_row">
                        <div class="field_left">
                            <div class="form_field">
                                <label for="', $field['id'], '"><?php echo esc_html($field['name']); ?></label>
                                <input class="meta_image_url" value="" type="text" name="gallery[image_url][]" />
                                <span><?php echo esc_html($field['desc']); ?></span>
                            </div>
                        </div>
                        <div class="field_right image_wrap"></div> 
                        <div class="field_right"> 
                            <input type="button" class="button" value="<?php echo esc_attr__('Choose File','astro'); ?>" onclick="add_image(this)" />
                            <input class="button" type="button" value="<?php echo esc_attr__('Remove','astro'); ?>" onclick="remove_field(this)" /> 
                        </div>
                        <div class="clear"></div>
                     </div>
                     </div>
                    <div id="add_field_row">
                      <input class="button" type="button" value="<?php echo esc_attr__('Add Gallery Image','astro'); ?>" onclick="add_field_row();" />
                    </div>
                 </th>
                <th>
                <div id="dynamic_form">
                    <div id="field_wrap" class="hl-gallery-img-wrap">
                        <?php 
                        if ( isset( $gallery_data['image_url'] ) ) 
                        {
                            for( $i = 0; $i < count( $gallery_data['image_url'] ); $i++ ) 
                            {
                            ?>
                            <div class="field_row">
                                <div class="field_left">
                                <div class="form_field"> 
                                <label><?php echo esc_html__('Room Images','astro'); ?></label>
                                <input type="text" class="meta_image_url"
                                                name="gallery[image_url][]"
                                                value="<?php echo esc_url( $gallery_data['image_url'][$i] ); ?>"
                                        />
                                </div>
                            </div>
                            <div class="field_right image_wrap">
                                <img src="<?php echo esc_url( $gallery_data['image_url'][$i] ); ?>" height="<?php echo esc_attr__('100','astro'); ?>" width="<?php echo esc_attr__('100','astro'); ?>" />
                            </div>
                            <div class="field_right">
                                <input class="button" type="button" value="<?php echo esc_attr__('Choose File','astro'); ?>" onclick="add_image(this)" />
                                <input class="button" type="button" value="<?php echo esc_attr__('Remove','astro'); ?>" onclick="remove_field(this)" />
                            </div>
                            <div class="clear"></div> 
                            </div>
                            <?php
                                } 
                            } 
                            ?>
                       </div> 
                    </th>
                  <?php
                 echo '</tr>';
                break;
			}
		}
		echo '</table>';   
	}
    /**
     * Event Schedule Add Meta Option
     */ 
    public function cafe_save_meta_options(){	
		$page_option_meta = $this->page_option_meta;
		$new = '';
        $post_id = get_the_ID();
		// verify nonce
		if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
			return $post_id;
		}
		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}
		if (defined('DOING_AJAX') && DOING_AJAX)
			return;
		// check permissions
		if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
			if (!current_user_can('edit_page', $post_id)) {
				return $post_id;
			}
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}
	 
		foreach ($page_option_meta['fields'] as $field) {
			$old = get_post_meta($post_id, $field['id'], true);
			if (isset($_POST[$field['id']])) {
				 $new = $_POST[$field['id']];
			}
			if ($new && $new != $old) {
				update_post_meta($post_id, $field['id'], $new);
			} elseif ('' == $new && $old) {
				delete_post_meta($post_id, $field['id'], $old);
			}
		}
        
        if ( $_POST['gallery'] ){
            // Build array for saving post meta
            $gallery_data = array();
            for ($i = 0; $i < count( $_POST['gallery']['image_url'] ); $i++ ) 
            {
                if ( '' != $_POST['gallery']['image_url'][ $i ] ) 
                {
                    $gallery_data['image_url'][]  = $_POST['gallery']['image_url'][ $i ];
                }
            }
     
                if ($gallery_data){
                    update_post_meta( $post_id, 'gallery_data', $gallery_data );
                }else{
                    delete_post_meta( $post_id, 'gallery_data' );
                }

        }else {
              delete_post_meta( $post_id, 'gallery_data' );
        }

        if($_POST['schedule_times']){
            update_post_meta( $post_id, 'schedule_times_datas',$_POST['schedule_times']);
        }else{
            delete_post_meta( $post_id, 'schedule_times_datas' ); 
        }

	}

}