<?php
/**
 * Astro Event Booking List 
 */
class Astro_cafe_booking_Table extends WP_List_Table {
  
	public function __construct() {
		// Set parent defaults.
		parent::__construct( array(
			'singular' => 'user',     // Singular name of the listed records.
			'plural'   => 'users',    // Plural name of the listed records.
			'ajax'     => false,       // Does this table support ajax?
		) );
	}

	public function display_data() {
		global $wpdb;
		$booking_data = array();
		$pmt_tbl = $wpdb->prefix . 'cafe_table_booked';
        if(isset($_GET['s']) && $_GET['s'] != ''){
		    $allubooked = get_users( array('search' => $_GET['s']) );
		    $books_ids = array();
		    foreach($allubooked as $booked){
		        $books_ids[] = $booked->bc_id;
		    }  
		    $str_ids = implode(',', $books_ids);
		    $booking_query = $wpdb->get_results("SELECT * FROM $pmt_tbl WHERE bc_id in($str_ids)");
		}else{
		    $booking_query = $wpdb->get_results("SELECT * FROM $pmt_tbl ORDER BY bc_id ASC");
		}
        $payment_curreny = get_option('stripe_cafe_currency_val');
		if($booking_query) {  
			foreach ($booking_query as $booking) {
                $customer_details = '';
				if(!empty($booking->bc_customer_details)):
				 $customer_details = json_decode($booking->bc_customer_details);
				endif;
				$strip_cust_name = '';
				if(!empty($customer_details->strip_cust_name)):
		        $strip_cust_name = $customer_details->strip_cust_name;
                endif;
				$eamil = '';
				if(!empty($customer_details->eamil)):
				$eamil = $customer_details->eamil;
				endif;
				$contact_number = '';
				if(!empty($customer_details->contact_number)):
				$contact_number = $customer_details->contact_number;
				endif;
				$cust_message = '';
				if(!empty($customer_details->strip_cust_message)):
					$cust_message = $customer_details->strip_cust_message;
				endif;
				$event_type = '';
				if(!empty($customer_details->event_type)):
					$event_type = $customer_details->event_type;
				endif;
				$numberof_guests = '';
				if(!empty($customer_details->num_of_guests)):
					$numberof_guests = $customer_details->num_of_guests;
				endif;
				$booking_data[] = array(
						'ID' => $booking->bc_id, 
						'customer_name' => $strip_cust_name, 
						'email' => $eamil,
						'contact_number' => $contact_number,
						'txn_id' => $booking->bc_txnid,
						'payment_amount' => $payment_curreny.' '.$booking->bc_payment_amount	,
						'payment_status' => $booking->bc_payment_status, 
						'booking_date' => date('d-m-Y',strtotime($booking->bc_timestamp)),
						'booking_time' => $booking->bc_booking_time,
						'event_type' => $event_type ,
						'numberof_guests' => $numberof_guests ,
						'message'=> $cust_message, 
						); 

			}
		}
		return $booking_data;
	}

	public function no_items() {
	  esc_html_e('No Booking Avaliable.', 'astro');
	}

	public function get_columns() {
		$columns = array(
			'cb' => '<input type="checkbox" />',   
			// Render a checkbox instead of text.
			'customer_name' => esc_html__('Customer', 'astro'),
			'email' => esc_html__('Email', 'astro'),
			'contact_number' => esc_html__('Contact Number', 'astro'),
			'txn_id' => esc_html__('Transaction Id', 'astro'),
			'payment_amount' => esc_html__('Amount', 'astro'),
			'payment_status' => esc_html__('Status', 'astro' ),
			'booking_date' => esc_html__('Booking Date', 'astro'),
			'booking_time' => esc_html__('Booking Time', 'astro'), 
			'event_type' => esc_html__('Event', 'astro'),
			'numberof_guests' => esc_html__('Number Of Guests', 'astro'),
			'message'=> esc_html__('Message', 'astro'),
			);  
        return $columns;
	}

	protected function get_sortable_columns() {
		 $sortable_columns = array(
			  'email'    => array('email', false),
			  'contact_number'   => array('contact_number', false),
			  'booking_date'   => array('booking_date', false),
			  'booking_time'   => array('booking_time', false),
			  'event_type'   => array('event_type', false),
			  'numberof_guests'   => array('numberof_guests', false),
		    ); 
        return $sortable_columns;
	} 

	protected function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'customer_name':
				return $item[ $column_name ];
			case 'email':
				return $item[ $column_name ];
			case 'contact_number':
				return $item[ $column_name ];
			case 'address':
				return $item[ $column_name ];
			case 'txn_id':
				return $item[ $column_name ];
			case 'payment_amount':
				return $item[ $column_name ];
			case 'payment_status':
				return $item[ $column_name ];			
			case 'booking_date':
				return $item[ $column_name ];
			case 'booking_time':
				return $item[ $column_name ];
			case 'event_type':
				return $item[ $column_name ];
			case 'numberof_guests':
				return $item[ $column_name ];
			case 'message':
				return $item[ $column_name ];	
		} 
	}

	protected function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="%1$s[]" value="%2$s" />',
			$this->_args['singular'],  // Let's simply repurpose the table's singular label ("user").
			$item['ID']                // The value of the checkbox should be the record's ID.
		);
	}

	protected function column_title( $item ) {
		$page = wp_unslash( $_REQUEST['page'] ); // WPCS: Input var ok.
        // Build edit row action.
		$edit_query_args = array(
			'page'   => $page,
			'action' => 'edit',
			'user'  => $item['ID'],
		);

		$actions['edit'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $edit_query_args, 'admin.php' ), 'edituser_' . $item['ID'] ) ),
			_x( 'Edit', 'row action','astro')
		);

		// Build delete row action.
		$delete_query_args = array(
			'page'   => $page,
			'action' => 'delete',
			'user'  => $item['ID'],
		);

		$actions['delete'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $delete_query_args, 'admin.php' ), 'deleteuser_' . $item['ID'] ) ),
			_x( 'Delete', 'row action','astro')
		);

		// Return the title contents.
		return sprintf( '%1$s %2$s',
			$item['customer_name'],
			$this->row_actions( $actions )
		);
	}

	protected function get_bulk_actions() {
		$actions = array(
			'delete' => _x( 'Delete', 'bulk action', 'astro' ),
		);

		return $actions;
	}


	protected function process_bulk_action() {
		// Detect when a bulk action is being triggered.
		global $wpdb;  
		$pmt_tbl = $wpdb->prefix . 'cafe_table_booked';
       
		if ( 'delete' === $this->current_action() ) {
			foreach ($_GET['user'] as $value) {
               $wpdb->delete( $pmt_tbl, array( 'bc_id' => $value ), array( '%d' ) );
			}
		}
  
		// Edit when a bulk action is being triggered.
		if ( 'edit' === $this->current_action() ) {
			$this->single_row_edit();
			//wp_die( 'Items edited (or they would be if we had items to edit)!' );
		}
	}

	function single_row_edit() {
		require dirname( __FILE__ ) . '/user-edit.php';
		wp_die();
	}

	function prepare_items() {
		global $wpdb; //This is used only if making any database queries
        /*
		 * First, lets decide how many records per page to show
		 */ 
		$per_page = 20;
        $columns  = $this->get_columns();
		$hidden   = array();
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array( $columns, $hidden, $sortable );

		$this->process_bulk_action();

		$data = $this->display_data();

		usort( $data, array( $this, 'usort_reorder' ) );

		$current_page = $this->get_pagenum();

		$total_items = count( $data );

		$data = array_slice( $data, ( ( $current_page - 1 ) * $per_page ), $per_page );

		$this->items = $data;

		$this->set_pagination_args( array(
			'total_items' => $total_items,                     // WE have to calculate the total number of items.
			'per_page'    => $per_page,                        // WE have to determine how many items to show on a page.
			'total_pages' => ceil( $total_items / $per_page ), // WE have to calculate the total number of pages.
		) );
	}

	protected function usort_reorder( $a, $b ) {
		// If no sort, default to title.
		$orderby = ! empty( $_REQUEST['orderby'] ) ? wp_unslash( $_REQUEST['orderby'] ) : 'customer_name'; 

		// If no order, default to asc.
		$order = ! empty( $_REQUEST['order'] ) ? wp_unslash( $_REQUEST['order'] ) : 'asc'; 

		// Determine sort order.
		$result = strcmp( $a[ $orderby ], $b[ $orderby ] );

		return ( 'asc' === $order ) ? $result : - $result;
	}
}

/**
 * Astro Event Disbale Date
 */ 
class Astro_cafe_disbaledate extends WP_List_Table {

	public function __construct() {
		// Set parent defaults.
		parent::__construct( array(
			'singular' => 'user',     // Singular name of the listed records.
			'plural'   => 'users',    // Plural name of the listed records.
			'ajax'     => true,       // Does this table support ajax?
		) );
	}

	public function display_data() {
        global $wpdb; 
		$disble_date_data = array();
		$args = array(
			'post_type' =>'cafe_date',
			'posts_per_page' => -1,
			'post_status' =>'publish',
		   ); 
		   
	    $cafedate_query = new WP_Query($args);
        if($cafedate_query->have_posts() ) :
		    while($cafedate_query->have_posts() ) : $cafedate_query->the_post();
            $disble_title = '<a href="'.esc_url(get_the_permalink(get_the_ID())).'">'.get_the_title().'</a>';
			$delete_query_args = array(
				'page'   => 'cafe_form',  
				'action' => 'delete',
				'user'  => get_the_ID(),
			   ); 
			$cafe_disble_date = get_post_meta(get_the_ID(),'cafe_disble_datepicker',true);
			$cafe_disble_edite = '<a href="'.esc_url(get_edit_post_link(get_the_ID())).'" class="hl-edit">'.esc_html__('Edit','astro').'</a> <a href="'.esc_url( wp_nonce_url( add_query_arg( $delete_query_args, 'admin.php' ), 'deleteuser_'.get_the_ID()) ).'" class="hl-delete">'.esc_html__('Delete','astro').'</a>';
           
            $disble_date_data[] = array('ID' => get_the_ID(), 
							'disble_title' => $disble_title, 
							'disble_date' => $cafe_disble_date,
							'actions' => $cafe_disble_edite, 
							);

		    endwhile;
		endif;
        return $disble_date_data;
	}

	public function no_items() {
	   esc_html_e('No Date Avaliable.','astro');
	}

	public function get_columns() {
		$columns = array(
			'cb' => '<input type="checkbox" />', 
			'disble_title' => esc_html__( 'Date Title','astro'),
			'disble_date' => esc_html__( 'Date','astro'),
			'actions' => esc_html__( 'Actions', 'astro'),
		    ); 
        return $columns; 
	}

	protected function get_sortable_columns() {
		$sortable_columns = array(
			'disble_title'  => array('Date Title', false ),
			'disble_date' => array('Date', false )
		); 
        return $sortable_columns;
	} 

	protected function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'disble_title':
				return $item[ $column_name ];
				break;
			case 'disble_date':
				return $item[ $column_name ];
				break;
			case 'actions':
				return $item[ $column_name ];
			    break;
			
        }
		
	}

	protected function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="%1$s[]" value="%2$s" />',
			$this->_args['singular'],  // Let's simply repurpose the table's singular label ("user").
			$item['ID']                // The value of the checkbox should be the record's ID.
		);
	}

	protected function column_title( $item ) {
		$page = wp_unslash( $_REQUEST['page'] ); // WPCS: Input var ok.
        // Build edit row action.
		$edit_query_args = array(
			'page'   => $page,
			'action' => 'edit',
			'user'  => $item['ID'],
		);
         
		$actions['edit'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $edit_query_args, 'admin.php' ), 'edituser_' . $item['ID'] ) ),
			_x( 'Edit', 'row action','astro')
		);

		// Build delete row action.
		$delete_query_args = array(
			'page'   => $page,
			'action' => 'delete',
			'user'  => $item['ID'],
		);

		$actions['delete'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $delete_query_args, 'admin.php' ), 'deleteuser_' . $item['ID'] ) ),
			_x( 'Delete', 'row action', 'astro')
		);

		// Return the schedule_name contents.
		return sprintf( '%1$s %2$s',
			$item['disble_title'],
			$this->row_actions( $actions )
		);
	} 
 
	protected function get_bulk_actions() {
		$actions = array(
			'delete' => _x( 'Delete', 'bulk action', 'astro'),
		);
        return $actions;
	}
 
    protected function process_bulk_action() {
		// Detect when a bulk action is being triggered.
		
		if ('delete' === $this->current_action()) {
			if(is_array($_GET['user'])){
				foreach ($_GET['user'] as $value) {
				wp_delete_post($value);
				}
		    }else{
				wp_delete_post($_GET['user']);
			}
		} 
        
		// Edit when a bulk action is being triggered.
		if ('edit' === $this->current_action()) {
			$this->single_row_edit();
		} 
	} 

	function single_row_edit() {
		require dirname( __FILE__ ) . '/user-edit.php';
		wp_die();
	}

	function prepare_items() {
		global $wpdb; //This is used only if making any database queries

		/*
		 * First, lets decide how many records per page to show
		 */
		$per_page = 20;
        $columns  = $this->get_columns();
		$hidden   = array();
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array( $columns, $hidden, $sortable );

		$this->process_bulk_action();

		$data = $this->display_data();

		usort( $data, array( $this, 'usort_reorder' ) );

		$current_page = $this->get_pagenum();

		$total_items = count( $data );

		$data = array_slice( $data, ( ( $current_page - 1 ) * $per_page ), $per_page );

		$this->items = $data;

		$this->set_pagination_args( array(
			'total_items' => $total_items,                     // WE have to calculate the total number of items.
			'per_page'    => $per_page,                        // WE have to determine how many items to show on a page.
			'total_pages' => ceil( $total_items / $per_page ), // WE have to calculate the total number of pages.
		) );
	}

	protected function usort_reorder( $a, $b ) {
		// If no sort, default to title.
		$orderby = ! empty( $_REQUEST['orderby'] ) ? wp_unslash( $_REQUEST['orderby'] ) : 'disble_title'; 

        // If no order, default to asc.
		$order = ! empty( $_REQUEST['order'] ) ? wp_unslash( $_REQUEST['order'] ) : 'asc'; 
        
		// Determine sort order.
		$result = strcmp( $a[ $orderby ], $b[ $orderby ] );

		return ( 'asc' === $order ) ? $result : - $result;
	} 
}