<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2\Service\Entity;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class FactorOptions {
    /**
     * @param string $bindingAlg The algorithm used when `factor_type` is `push`
     * @param string $bindingPublicKey The public key encoded in Base64
     * @param string $configAppId The ID that uniquely identifies your app in the
     *                            Google or Apple store
     * @param string $configNotificationPlatform The transport technology used to
     *                                           generate the Notification Token
     * @param string $configNotificationToken For APN, the device token. For FCM
     *                                        the registration token
     * @param string $configSdkVersion The Verify Push SDK version used to
     *                                 configure the factor
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return CreateFactorOptions Options builder
     */
    public static function create(string $bindingAlg = Values::NONE, string $bindingPublicKey = Values::NONE, string $configAppId = Values::NONE, string $configNotificationPlatform = Values::NONE, string $configNotificationToken = Values::NONE, string $configSdkVersion = Values::NONE, string $twilioSandboxMode = Values::NONE): CreateFactorOptions {
        return new CreateFactorOptions($bindingAlg, $bindingPublicKey, $configAppId, $configNotificationPlatform, $configNotificationToken, $configSdkVersion, $twilioSandboxMode);
    }

    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return DeleteFactorOptions Options builder
     */
    public static function delete(string $twilioSandboxMode = Values::NONE): DeleteFactorOptions {
        return new DeleteFactorOptions($twilioSandboxMode);
    }

    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return FetchFactorOptions Options builder
     */
    public static function fetch(string $twilioSandboxMode = Values::NONE): FetchFactorOptions {
        return new FetchFactorOptions($twilioSandboxMode);
    }

    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return ReadFactorOptions Options builder
     */
    public static function read(string $twilioSandboxMode = Values::NONE): ReadFactorOptions {
        return new ReadFactorOptions($twilioSandboxMode);
    }

    /**
     * @param string $authPayload Optional payload to verify the Factor for the
     *                            first time
     * @param string $friendlyName The friendly name of this Factor
     * @param string $configNotificationToken For APN, the device token. For FCM
     *                                        the registration token
     * @param string $configSdkVersion The Verify Push SDK version used to
     *                                 configure the factor
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return UpdateFactorOptions Options builder
     */
    public static function update(string $authPayload = Values::NONE, string $friendlyName = Values::NONE, string $configNotificationToken = Values::NONE, string $configSdkVersion = Values::NONE, string $twilioSandboxMode = Values::NONE): UpdateFactorOptions {
        return new UpdateFactorOptions($authPayload, $friendlyName, $configNotificationToken, $configSdkVersion, $twilioSandboxMode);
    }
}

class CreateFactorOptions extends Options {
    /**
     * @param string $bindingAlg The algorithm used when `factor_type` is `push`
     * @param string $bindingPublicKey The public key encoded in Base64
     * @param string $configAppId The ID that uniquely identifies your app in the
     *                            Google or Apple store
     * @param string $configNotificationPlatform The transport technology used to
     *                                           generate the Notification Token
     * @param string $configNotificationToken For APN, the device token. For FCM
     *                                        the registration token
     * @param string $configSdkVersion The Verify Push SDK version used to
     *                                 configure the factor
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     */
    public function __construct(string $bindingAlg = Values::NONE, string $bindingPublicKey = Values::NONE, string $configAppId = Values::NONE, string $configNotificationPlatform = Values::NONE, string $configNotificationToken = Values::NONE, string $configSdkVersion = Values::NONE, string $twilioSandboxMode = Values::NONE) {
        $this->options['bindingAlg'] = $bindingAlg;
        $this->options['bindingPublicKey'] = $bindingPublicKey;
        $this->options['configAppId'] = $configAppId;
        $this->options['configNotificationPlatform'] = $configNotificationPlatform;
        $this->options['configNotificationToken'] = $configNotificationToken;
        $this->options['configSdkVersion'] = $configSdkVersion;
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
    }

    /**
     * The algorithm used when `factor_type` is `push`. Algorithm supported: `ES256`
     *
     * @param string $bindingAlg The algorithm used when `factor_type` is `push`
     * @return $this Fluent Builder
     */
    public function setBindingAlg(string $bindingAlg): self {
        $this->options['bindingAlg'] = $bindingAlg;
        return $this;
    }

    /**
     * The Ecdsa public key in PKIX, ASN.1 DER format encoded in Base64
     *
     * @param string $bindingPublicKey The public key encoded in Base64
     * @return $this Fluent Builder
     */
    public function setBindingPublicKey(string $bindingPublicKey): self {
        $this->options['bindingPublicKey'] = $bindingPublicKey;
        return $this;
    }

    /**
     * The ID that uniquely identifies your app in the Google or Apple store, such as `com.example.myapp`. Required when `factor_type` is `push`
     *
     * @param string $configAppId The ID that uniquely identifies your app in the
     *                            Google or Apple store
     * @return $this Fluent Builder
     */
    public function setConfigAppId(string $configAppId): self {
        $this->options['configAppId'] = $configAppId;
        return $this;
    }

    /**
     * The transport technology used to generate the Notification Token. Can be `apn` or `fcm`. Required when `factor_type` is `push`
     *
     * @param string $configNotificationPlatform The transport technology used to
     *                                           generate the Notification Token
     * @return $this Fluent Builder
     */
    public function setConfigNotificationPlatform(string $configNotificationPlatform): self {
        $this->options['configNotificationPlatform'] = $configNotificationPlatform;
        return $this;
    }

    /**
     * For APN, the device token. For FCM the registration token. It used to send the push notifications. Required when `factor_type` is `push`
     *
     * @param string $configNotificationToken For APN, the device token. For FCM
     *                                        the registration token
     * @return $this Fluent Builder
     */
    public function setConfigNotificationToken(string $configNotificationToken): self {
        $this->options['configNotificationToken'] = $configNotificationToken;
        return $this;
    }

    /**
     * The Verify Push SDK version used to configure the factor
     *
     * @param string $configSdkVersion The Verify Push SDK version used to
     *                                 configure the factor
     * @return $this Fluent Builder
     */
    public function setConfigSdkVersion(string $configSdkVersion): self {
        $this->options['configSdkVersion'] = $configSdkVersion;
        return $this;
    }

    /**
     * The Twilio-Sandbox-Mode HTTP request header
     *
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return $this Fluent Builder
     */
    public function setTwilioSandboxMode(string $twilioSandboxMode): self {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.CreateFactorOptions ' . $options . ']';
    }
}

class DeleteFactorOptions extends Options {
    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     */
    public function __construct(string $twilioSandboxMode = Values::NONE) {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
    }

    /**
     * The Twilio-Sandbox-Mode HTTP request header
     *
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return $this Fluent Builder
     */
    public function setTwilioSandboxMode(string $twilioSandboxMode): self {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.DeleteFactorOptions ' . $options . ']';
    }
}

class FetchFactorOptions extends Options {
    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     */
    public function __construct(string $twilioSandboxMode = Values::NONE) {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
    }

    /**
     * The Twilio-Sandbox-Mode HTTP request header
     *
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return $this Fluent Builder
     */
    public function setTwilioSandboxMode(string $twilioSandboxMode): self {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.FetchFactorOptions ' . $options . ']';
    }
}

class ReadFactorOptions extends Options {
    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     */
    public function __construct(string $twilioSandboxMode = Values::NONE) {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
    }

    /**
     * The Twilio-Sandbox-Mode HTTP request header
     *
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return $this Fluent Builder
     */
    public function setTwilioSandboxMode(string $twilioSandboxMode): self {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.ReadFactorOptions ' . $options . ']';
    }
}

class UpdateFactorOptions extends Options {
    /**
     * @param string $authPayload Optional payload to verify the Factor for the
     *                            first time
     * @param string $friendlyName The friendly name of this Factor
     * @param string $configNotificationToken For APN, the device token. For FCM
     *                                        the registration token
     * @param string $configSdkVersion The Verify Push SDK version used to
     *                                 configure the factor
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     */
    public function __construct(string $authPayload = Values::NONE, string $friendlyName = Values::NONE, string $configNotificationToken = Values::NONE, string $configSdkVersion = Values::NONE, string $twilioSandboxMode = Values::NONE) {
        $this->options['authPayload'] = $authPayload;
        $this->options['friendlyName'] = $friendlyName;
        $this->options['configNotificationToken'] = $configNotificationToken;
        $this->options['configSdkVersion'] = $configSdkVersion;
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
    }

    /**
     * The optional payload needed to verify the Factor for the first time. E.g. for a TOTP, the numeric code.
     *
     * @param string $authPayload Optional payload to verify the Factor for the
     *                            first time
     * @return $this Fluent Builder
     */
    public function setAuthPayload(string $authPayload): self {
        $this->options['authPayload'] = $authPayload;
        return $this;
    }

    /**
     * The new friendly name of this Factor
     *
     * @param string $friendlyName The friendly name of this Factor
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * For APN, the device token. For FCM the registration token. It used to send the push notifications. Required when `factor_type` is `push`
     *
     * @param string $configNotificationToken For APN, the device token. For FCM
     *                                        the registration token
     * @return $this Fluent Builder
     */
    public function setConfigNotificationToken(string $configNotificationToken): self {
        $this->options['configNotificationToken'] = $configNotificationToken;
        return $this;
    }

    /**
     * The Verify Push SDK version used to configure the factor
     *
     * @param string $configSdkVersion The Verify Push SDK version used to
     *                                 configure the factor
     * @return $this Fluent Builder
     */
    public function setConfigSdkVersion(string $configSdkVersion): self {
        $this->options['configSdkVersion'] = $configSdkVersion;
        return $this;
    }

    /**
     * The Twilio-Sandbox-Mode HTTP request header
     *
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return $this Fluent Builder
     */
    public function setTwilioSandboxMode(string $twilioSandboxMode): self {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.UpdateFactorOptions ' . $options . ']';
    }
}