<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Trunking\V1\Trunk;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * @property string $mode
 * @property string $trim
 * @property string $url
 * @property string $trunkSid
 */
class RecordingInstance extends InstanceResource {
    /**
     * Initialize the RecordingInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $trunkSid The trunk_sid
     */
    public function __construct(Version $version, array $payload, string $trunkSid) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'mode' => Values::array_get($payload, 'mode'),
            'trim' => Values::array_get($payload, 'trim'),
            'url' => Values::array_get($payload, 'url'),
            'trunkSid' => Values::array_get($payload, 'trunk_sid'),
        ];

        $this->solution = ['trunkSid' => $trunkSid, ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return RecordingContext Context for this RecordingInstance
     */
    protected function proxy(): RecordingContext {
        if (!$this->context) {
            $this->context = new RecordingContext($this->version, $this->solution['trunkSid']);
        }

        return $this->context;
    }

    /**
     * Fetch the RecordingInstance
     *
     * @return RecordingInstance Fetched RecordingInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): RecordingInstance {
        return $this->proxy()->fetch();
    }

    /**
     * Update the RecordingInstance
     *
     * @return RecordingInstance Updated RecordingInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(): RecordingInstance {
        return $this->proxy()->update();
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Trunking.V1.RecordingInstance ' . \implode(' ', $context) . ']';
    }
}