<?php 
echo do_shortcode(get_the_content());
if(get_post_type() =='rooms'):
?>
<div class="hl-hotel-roomgallery row">
    <?php 
    $gallery_data = get_post_meta(get_the_ID(), 'gallery_data', true ); 
    if(isset($gallery_data['image_url'])):
        for( $i = 0; $i < count( $gallery_data['image_url'] ); $i++ ){ 
        ?>
        <div class="card col-lg-3">
            <div class="card-image">
                <a href="<?php echo esc_url( $gallery_data['image_url'][$i] ); ?>" data-fancybox="<?php esc_attr__('gallery','astro'); ?>" data-caption="<?php the_title_attribute(); ?>"><img src="<?php echo esc_url( $gallery_data['image_url'][$i] ); ?>" alt="<?php the_title_attribute(); ?>"> 
                </a>
            </div>
        </div>
        <?php
        }
    endif;   
    ?>
</div>
<div class="hl-hotel-facilities">
    <h3><?php echo esc_html__('Hotel Facilities','astro'); ?></h3>
    <?php 
    $args = array(
          'taxonomy' => 'hotel-facilities',
          'orderby' => 'name',
          'order'   => 'ASC'
          );
    $room_types = get_categories($args);
    ?>
    <ul> 
    <?php 
    if($room_types):
     foreach($room_types as $rooms):
    ?>   
    <li><?php echo esc_html($rooms->name); ?></li>
    <?php 
     endforeach;
    endif;
    ?>   
    </ul>
</div>
<div class="social_share">
	<ul>
		<li><?php echo esc_html('Share : ','astro');?></li>
		<li>
			<a href="<?php echo esc_url('https://www.facebook.com/sharer/sharer.php?u='.get_permalink()); ?>" id="facebook" target="_blank">
                <img src="<?php echo esc_url(plugins_url(). '/astro-appointment/assets/images/social/facebook_img.png'); ?>" alt="<?php echo esc_attr__('Facebook','astro'); ?>">
            </a>
        </li>
		<li>
            <a href="<?php echo esc_url('https://twitter.com/share?url='.get_permalink()); ?>" id="twitter" target="_blank">
                <img src="<?php echo esc_url(plugins_url(). '/astro-appointment/assets/images/social/twitter-img.png'); ?>" alt="<?php echo esc_attr__('twitter','astro'); ?>">
            </a>
        </li>
		<li>
            <a href="<?php echo esc_url('https://wa.me/?text='.get_permalink()); ?>" id="whatsapp" target="_blank">
				<img src="<?php echo esc_url(plugins_url(). '/astro-appointment/assets/images/social/whatsapp-img.png'); ?>" alt="<?php echo esc_attr__('whatsapp','astro'); ?>">
            </a>
        </li>
		<li>
            <a href="<?php echo esc_url('https://www.linkedin.com/shareArticle?mini=true&amp;url='.get_permalink()); ?>" id="linkedin" target="_blank">
                <img src="<?php echo esc_url(plugins_url(). '/astro-appointment/assets/images/social/linkedin-img.png'); ?>" alt="<?php echo esc_attr__('linkedin','astro'); ?>">
            </a>
        </li>
	</ul>
</div>
<div class="hl-hotel-location">
  <?php 
    echo get_post_meta(get_the_ID(),'hotel_location_map',true);
  ?>    
</div>
<?php 
$check_in_date = '';
if(isset($_GET['chi'])):
    $check_in_date = base64_decode($_GET['chi']); 
endif;
$check_out_date = '';
if(isset($_GET['cho'])):
    $check_out_date = base64_decode($_GET['cho']); 
endif; 
if(!empty($check_in_date) && !empty($check_out_date)):
?>
<div class="hl-room-booking-form">
    <?php  
    $room_status = get_post_meta(get_the_ID(),'hotel_status',true);
    if($room_status == 'open'):
    $booking_form_heading = get_option('hotel_booking_form_heading'); 
    if(!empty($booking_form_heading)):
    ?><h2 class="hl-room-title"><?php echo esc_html($booking_form_heading); ?></h2>
     <?php endif;?> 
    <form name="hl_booking_room" id="hl_booking_room" method="post"> 
        <ul>
            <li>
             <label for="hl_bfirst_name"><?php echo esc_html__('First Name','astro'); ?></label>
             <input type="text" name="hl_bfirst_name" id="hl_bfirst_name">
             <input type="hidden" name="hl_check_in_date" id="hl_check_in_date" value="<?php echo esc_attr($check_in_date); ?>" readonly>
             <input type="hidden" name="hl_check_out_date" id="hl_check_out_date" value="<?php echo esc_attr($check_out_date); ?>" readonly>
             <input type="hidden" name="hl_room_id" id="hl_room_id" value="<?php echo esc_attr(get_the_ID()); ?>" readonly> 
            </li>
            <li>
              <label for="hl_blast_name"><?php echo esc_html__('Last Name','astro'); ?></label>
              <input type="text" name="hl_blast_name" id="hl_blast_name">
            </li>
            <li>
              <label for="hl_bemail"><?php echo esc_html__('Email','astro'); ?></label>
              <input type="text" name="hl_bemail" id="hl_bemail">
            </li>
            <li>
             <label for="hl_bcontact_number">
             <?php echo esc_html__('Contact Number','astro'); ?></label>
             <input type="text" name="hl_bcontact_number" id="hl_bcontact_number">
            </li>
            <li>
             <label for="hl_baddress">
             <?php echo esc_html__('Address','astro'); ?></label>
             <input type="text" name="hl_baddress" id="hl_baddress">
            </li>
            <li>
            <?php 
            $number_of_people = '';
            if(!empty($_COOKIE['hotel_number_of_people'])):
              $number_of_people = $_COOKIE['hotel_number_of_people'];
            endif;
            ?>
            <label for="number_of_peoples">
             <?php echo esc_html__('Numbers of People','astro'); ?></label>
               <select name="number_of_peoples" id="number_of_peoples">
                <option value="">
                    <?php echo esc_html__('Select Number','astro'); ?>
                </option>  
                <?php 
                $room_capicity = get_post_meta(get_the_ID(),'hotel_room_capacity',true);
                if(!empty($room_capicity)):
                for($i=1; $i<=$room_capicity; $i++){
                ?><option value="<?php echo esc_attr($i); ?>" <?php if($number_of_people == $i): echo esc_html__('selected','astro'); endif; ?>><?php echo esc_html($i); ?>
                </option> 
                <?php
                }
                endif;
                ?>         
              </select>
            </li>
            <li>
             <label for="hl_badults"><?php echo esc_html__('Adults','astro'); ?></label>
             <input type="number" name="hl_badults" id="hl_badults" value="0" min="0" max="<?php echo esc_attr($room_capicity); ?>">
            </li> 
            <li>
              <label for="hl_bchildren"><?php echo esc_html__('Children','astro'); ?></label>
              <input type="number" name="hl_bchildren" id="hl_bchildren" value="0" min="0" max="<?php echo esc_attr($room_capicity); ?>"> 
            </li> 
			
			<?php
				$currency = $price = get_post_meta(get_the_ID(),'hotel_currency',true);					
				if(!empty($tax_title) && !empty($tax)){
					$tax_title = get_option('tax_title');
					$text_percent = get_option('text_percent');
					$price = get_post_meta(get_the_ID(),'hotel_room_price',true);
					$tax = ($price*$text_percent)/100;
					$total = $tax + $price;			
					?>
						<li>
							<label for="new_price"><?php echo esc_html__($text_percent. '% ' . $tax_title .' Tax on your order and your Total Price '.$currency .' '.$total ); ?></label>
							<input type="hidden" name="new_price" id="new_price" value="<?php echo esc_attr($total); ?>"> 
							<input type="hidden" name="tax_name_n" id="tax_name_n" value="<?php echo esc_attr($tax_title); ?>"> 
							<input type="hidden" name="text_percent_n" id="text_percent_n" value="<?php echo esc_attr($text_percent); ?>"> 
						</li>
					<?php 
				}
			?>
        </ul>
        <button class="hl-btn"><?php echo esc_html__('Book Now','astro'); ?></button>
      </form> 
      <div id="hotel_payment_option" class="modal dfsdg">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="modal-header">
                <?php
                $booking_review_heading = get_option('hotel_booking_review_heading');
                if(!empty($booking_review_heading)):
                ?><h4><?php echo esc_html($booking_review_heading); ?></h4>
                <?php endif; ?> 
                </div>
                <div class="modal-body">
                <div class="hl-payment-astro" id="hotal_review_data"></div>  
                    <!-- Stripe Payment Option --> 
                    <div id="hotal_stripe_payment_button"></div>
                </div>
            </div>
         </div>
      </div>
    <?php 
    else:
    ?>
    <?php
    endif;
    ?>
</div>
<?php
else:
?>
<div class="astro_room_filter_single">
 <?php echo do_shortcode('[astro_room_views]'); ?>
</div>
<?php 
endif;
endif;