<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://codecanyon.net/user/kamleshyadav
 * @since      1.0.0
 *
 * @package    Astro
 * @subpackage Astro/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Astro
 * @subpackage Astro/public
 * @author     kamleshyadav <kamlesh.yadav@himanshusofttech.com >
 */
class Astro_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

    /**
	 * This varibal is appointment Schedule
	 */
    public $schedule_data;
	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
        
		$this->plugin_name = $plugin_name;
		$this->version = $version;
        add_shortcode('astro_room_views',array($this,'Astro_hotel_rooms_view'));
		add_shortcode('room_booking_invoice',array($this,'Astro_hotel_room_invoice'));
		add_shortcode('astro_table_views',array($this,'Astro_cafe_table_view'));
		add_shortcode('cafe_booking_invoice',array($this,'Astro_cafe_booking_invoice')); 
		add_shortcode('astro_appointment_views',array($this,'Astro_appointment_view'));
        add_shortcode('Astro_appointment_booking_invoice',array($this,'Astro_appointment_booking_invoice'));
	}
	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Astro_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Astro_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
        wp_enqueue_style('bootstrap', plugins_url(). '/astro-appointment/assets/css/bootstrap.min.css', array(), '5.0.2', 'all' );
		wp_enqueue_style('bootstrap-datepicker', plugins_url(). '/astro-appointment/assets/css/bootstrap-datepicker.min.css', array(), '1.9.0', 'all' );   
		wp_enqueue_style('bootstrap-datetimepicker', plugins_url(). '/astro-appointment/assets/css/bootstrap-datetimepicker.css', array(), '1.9.0', 'all' ); 
		wp_enqueue_style('astro-font', plugins_url(). '/astro-appointment/assets/css/astro-font.css', array(), '1.0', 'all' );
		wp_enqueue_style('toastr', plugins_url(). '/astro-appointment/assets/css/toastr.min.css', array(), '2.1.3', 'all' ); 
		wp_enqueue_style('fancybox', plugins_url(). '/astro-appointment/assets/css/jquery.fancybox.min.css', array(), '3.5.7', 'all' );   
		wp_enqueue_style('printarea', plugins_url(). '/astro-appointment/assets/css/printarea.css', array(), '3.5.7', 'all' );    
		wp_enqueue_style('t-datepicker', plugins_url(). '/astro-appointment/assets/css/t-datepicker.min.css', array(), '3.5.7', 'all' );   
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/astro-public.css', array(), $this->version, 'all' );
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'assets/css/astro-colors-style.php'; 
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Astro_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Astro_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
        wp_enqueue_script('bootstrap', plugins_url(). '/astro-appointment/assets/js/bootstrap.min.js', array( 'jquery' ), '5.0.2', false );	 
		wp_enqueue_script('bootstrap-datepicker', plugins_url(). '/astro-appointment/assets/js/bootstrap-datepicker.min.js', array( 'jquery' ), '5.0.2', false );	 
        wp_enqueue_script('toastr', plugins_url(). '/astro-appointment/assets/js/toastr.min.js', array( 'jquery' ), '2.1.3', false ); 
		wp_enqueue_script('fancybox', plugins_url(). '/astro-appointment/assets/js/jquery.fancybox.min.js', array(), '3.5.7', 'all');    
        wp_enqueue_script('cookie', plugins_url(). '/astro-appointment/assets/js/jquery.cookie.min.js', array(), '3.5.7', 'all');  
        wp_enqueue_script('bootstrap-datetimepicker', plugins_url(). '/astro-appointment/assets/js/bootstrap-datetimepicker.min.js', array(), '3.5.7', 'all');  
		wp_enqueue_script('printarea', plugins_url(). '/astro-appointment/assets/js/jquery.PrintArea.js', array(), '3.5.7', 'all');   
		wp_enqueue_script('t-datepicker', plugins_url(). '/astro-appointment/assets/js/t-datepicker.min.js', array(), '3.5.7', 'all');   
       
		wp_enqueue_script('astro-fullcalendar', plugins_url(). '/astro-appointment/assets/js/astro-fullcalendar.js', array(), '1.6.4', 'all');  
        
		wp_enqueue_script('astro-appointment-calendar', plugin_dir_url( __FILE__ ). 'js/astro-appointment-calendar.js', array(), '1.6.4', 'all');  
        /**
		 * Appoint Calendar Booking Set
		 */
		/**
		 * Schedule Data 
		 */
		$args = array(  
			'post_type' => 'schedule',
			'post_status' => 'publish',
			'posts_per_page' => -1,
			'order' => 'ASC',
		   );
		$schedule_arr = array();
		$schedule_query = new WP_Query($args);
		if($schedule_query->have_posts()):
			while($schedule_query->have_posts()): $schedule_query->the_post();
			  
			   $schedule_date = get_post_meta(get_the_ID(),'appointment_schedule_datepicker',true);
			   $current_date = date('Y-m-d');
			   
			   if(strtotime($schedule_date) <= strtotime($current_date)):
			       $data = array();
			   else:
    			   $data = array(
                   'id' => get_the_ID(),
                   'title' =>'<span data-schedule_id="'.get_the_ID().'" data-schedule_date="'.$schedule_date.'">'.get_the_title().'</span>',
    			   'start' => $schedule_date,
    			   ); 
    		    endif;
			    array_push($schedule_arr, $data);
			   
            endwhile; 
            wp_reset_query();
		endif;
        wp_localize_script('astro-appointment-calendar', 'Astro_appointment_datas', array(
			'url' => admin_url('admin-ajax.php'),
			'appointment_datas' => json_encode($schedule_arr),
			) 
	    ); 
       wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/astro-public.js', array( 'jquery' ), $this->version, false );
        
		/**
		 * Event Data
		 */
		$args = array(  
			'post_type' => 'cafe_date',
			'post_status' => 'publish',
			'posts_per_page' => -1,
			'order' => 'ASC',
		   ); 
		$disbale_date_arr = array();
		$disbale_date_query = new WP_Query($args);
		if($disbale_date_query->have_posts()):
			while($disbale_date_query->have_posts()): $disbale_date_query->the_post();
			  $disbale_date = get_post_meta(get_the_ID(),'cafe_disble_datepicker',true);
			  array_push($disbale_date_arr,$disbale_date);
            endwhile;   
            wp_reset_query();
		endif; 
        wp_localize_script($this->plugin_name, 'Astro_ajax_path', array(
			'url' => admin_url('admin-ajax.php'),
			'disbale_cafe_datas' => json_encode($disbale_date_arr),
			)   
	    );    
    }
   /**
	* Astro Hotel Room View 
	*/
	public function Astro_hotel_rooms_view(){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/hotel/astro-room-view.php';   
    }  
    public function Astro_hotel_room_invoice(){
       require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/hotel/astro-booking-invoice.php';  
	}
	/**
	 * Astro Hotel Room Single
	 */

    public function Astro_hotel_rooms_single(){
		require_once plugin_dir_path( dirname( __FILE__ ) ) .'public/partials/hotel/astro-room-single.php';     
    }  
     
	/**
	 * Astro Hotel Room Filter Ajax
	 */
	public function Astro_hotel_room_filter(){
		extract($_POST); 
		global $wpdb;  
		$table_name = $wpdb->prefix.'hotel_room_booked';
		$room_ids = array();
		$book_results = $wpdb->get_results("SELECT * FROM $table_name Where b_start_date='$Astro_check_in' OR b_end_date='$Astro_check_out'");
		if(!empty($book_results)): 
			foreach($book_results as $results):
				$room_ids[] = $results->b_room_id;
			endforeach;
		endif;
		$args = array(  
			'post_type' => 'rooms',
			'post_status' => 'publish',
			'post__not_in' => $room_ids,
			'posts_per_page' => -1,
			'order' => 'ASC',
			'tax_query' => array(
				array(
				 'taxonomy'  => 'room-type',
				 'field'     => 'slug',
				 'terms'     => $Astro_room_type
				)
             ),
			'meta_query' => array(
				'relation' => 'OR',
				array(
					'key' => 'hotel_room_capacity',
					'value' => $Astro_number_of_people,
				   ), 
				array(
					'key' => 'hotel_status',
					'value' => 'open',
				   ), 
			),
		);
		$chinout_date = 'chi='.base64_encode($Astro_check_in).'&cho='.base64_encode($Astro_check_out);
		$rooms_query = new WP_Query( $args ); 
        if($rooms_query->have_posts()):
			while($rooms_query->have_posts()): $rooms_query->the_post();
			if(has_post_thumbnail(get_the_ID())):
				$rooms_attachment_url = wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()), 'full');
			endif;
			$room_price_currency = get_post_meta(get_the_ID(),'hotel_currency',true);
			$room_price = get_post_meta(get_the_ID(),'hotel_room_price',true);
            ?>
			<div class="col-lg-4 col-sm-6">
				<div class="hl-room-box">
					<?php if(!empty($rooms_attachment_url)): ?>
						<div class="hl-room-img">
							<img src="<?php echo esc_url($rooms_attachment_url); ?>" alt="<?php the_title_attribute(); ?>">
						</div>
					<?php endif; ?>
					<div class="hl-room-content">
						<a href="<?php echo esc_url(get_the_permalink().'?'.$chinout_date); ?>" class="hl-room-title"><?php the_title(); ?></a>
						<p><?php echo substr(get_the_content(),0,100); ?></p>
						<div class="hl-room-footer">
							<a href="<?php echo esc_url(get_the_permalink().'?'.$chinout_date); ?>" class="hl-btn"><?php echo esc_html__('Book Now','astro'); ?></a>
							<h4><?php echo esc_html($room_price_currency.$room_price); ?></h4>
						</div>   
					</div>
				</div>
			</div>
         <?php 
		endwhile;
		wp_reset_query();
	    else:
         echo "<h1 class='hl-filter-room-empty'>".esc_html__('Please Select Another Date and Room Type','astro')."</h1>";
		endif;
		wp_die();  
	}
    /**
	 * Astro Hotel Single Page Check Booking Date
	 */
	public function Astro_hotel_singel_page_checkdate(){
		extract($_POST);
		global $wpdb;
		$table_name = $wpdb->prefix.'hotel_room_booked';
		$room_ids = array();
		$book_results = $wpdb->get_results("SELECT * FROM $table_name Where b_start_date='$Astro_check_in' OR b_end_date='$Astro_check_out'");
		if(!empty($book_results)): 
			foreach($book_results as $results):
				$room_ids[] = $results->b_room_id;
			endforeach;
		endif;
        $args = array(  
			'post_type' => 'rooms',
			'post_status' => 'publish',
			'post__not_in' => $room_ids,
			'posts_per_page' => -1,
			'order' => 'ASC',
		   );
		$hotel_arr = array();
		$rooms_query = new WP_Query( $args ); 
        if($rooms_query->have_posts()):
		while($rooms_query->have_posts()): $rooms_query->the_post();
              array_push($hotel_arr,get_the_ID());
        endwhile;
        echo json_encode($hotel_arr);
		wp_reset_query();
		endif;
		wp_die(); 	
	}
	/**
	 * Hotel strip Payment form
	 */
	public function Astro_hotel_stripe_payment(){
		extract($_POST);
		$stripe_submit_url = plugins_url().'/astro-appointment/strippayment/astro-hotel-payment.php';
        $stripe_publishable_key = get_option('stripe_publishbale_key');
		$payment_form_heading = get_option('hotel_payment_form_heading');
		//$currency = get_option('curreny_val'); 
		$currency = INR;
		if(!empty($payment_form_heading)):
			$stripe_store_name = get_option('hotel_payment_form_heading');
		else:
			$stripe_store_name = get_the_title();
		endif; 
		$room_price = $orderamount = get_post_meta($hl_room_id,'hotel_room_price',true);
		$tax_title = get_option('tax_title');
		$text_percent = get_option('text_percent');
		if(!empty($tax_title) && !empty($text_percent)){
		    $tax = ($room_price*$text_percent)/100;
		    $room_price = $tax + $room_price;
		    echo '<p>'.esc_html('You have booked an order of', 'astro').' '.  $currency .' '. $orderamount .' '. esc_html('And', 'astro') .' '. $tax_title .' '. esc_html('Tax', 'astro') .' '. $text_percent .' '. esc_html('% and 
                total amount will be', 'astro') .' '.$currency .' '. $room_price .'</p>';
		}
		?>
		<div class="payment-form">
    		<form action="<?php echo esc_url($stripe_submit_url); ?>" method="post" id="form_data_strip">
            <script src="https://checkout.stripe.com/checkout.js" class="stripe-button"
                data-key="<?php echo esc_attr($stripe_publishable_key); ?>"
                data-name="<?php echo esc_attr($stripe_store_name); ?>"
                data-currency=<?php echo esc_attr($currency); ?>
    			data-amount="<?php echo esc_attr($room_price*100); ?>"
                data-email="<?php echo esc_attr($email); ?>1111"
                data-locale="auto"></script>
    			<input type="hidden" name="item_id" id="item_id" value="<?php echo $hl_room_id; ?>"> 
    			<input type="hidden" name="first_name" id="first_name" value="<?php echo esc_attr($first_name); ?>"> 
    			<input type="hidden" name="last_name" id="last_name" value="<?php echo esc_attr($last_name); ?>">  
    			<input type="hidden" name="eamil" id="eamil" value="<?php echo esc_attr($email); ?>">  
    			<input type="hidden" name="badults" id="badults" value="<?php echo esc_attr($badults); ?>">  
    			<input type="hidden" name="bchildren" id="bchildren" value="<?php echo esc_attr($bchildren); ?>">  
    			<input type="hidden" name="num_of_peoples" id="num_of_peoples" value="<?php echo esc_attr($num_of_peoples); ?>">    
    			<input type="hidden" name="address" id="address" value="<?php echo esc_attr($address); ?>">  
    			<input type="hidden" name="check_in" id="check_in" value="<?php echo esc_attr($check_in); ?>">    
    			<input type="hidden" name="check_out" id="check_out" value="<?php echo esc_attr($check_out); ?>"> 
    			<input type="hidden" name="room_type" id="room_type" value="<?php echo esc_attr($room_type); ?>">  
    			<input type="hidden" name="contact_number" id="contact_number" value="<?php echo esc_attr($contact_number); ?>">
    			<input type="hidden" name="new_price" id="new_price" value="<?php echo esc_attr($room_price); ?>">
    			<input type="hidden" name="tax_name_n" id="tax_name_n" value="<?php echo esc_attr($tax_title); ?>">
    			<input type="hidden" name="text_percent_n" id="text_percent_n" value="<?php echo esc_attr($text_percent); ?>">  			
             </form> 
            <?php
    			// Razorpay Payment form
    			$razorpay_url= plugins_url().'/astro-appointment/razorpay/payment-process.php';
    			$razorpay_key = get_option('razorpay_key');
    			$razorpay_success_url = get_option('razorpay_success_url');
    			$razorpay_cancel_url = get_option('razorpay_cancel_url');
    			$currency = get_option('curreny_val');
    			$room_price = get_post_meta($hl_room_id,'hotel_room_price',true);
    			$tax_title = get_option('tax_title');
    		    $text_percent = get_option('text_percent');
            		if(!empty($tax_title) && !empty($text_percent)){
            		    $tax = ($room_price*$text_percent)/100;
            		    $room_price = $tax + $room_price;		
            		}
    			?>
    			<form action="" method="post" id="form_data_razorpay">
    				<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    				<input type="hidden" name="item_id" id="item_id" value="<?php echo esc_attr($hl_room_id); ?>">
    				<input type="hidden" name="first_name" id="first_name" value="<?php echo esc_attr($first_name); ?>"> 
    				<input type="hidden" name="last_name" id="last_name" value="<?php echo esc_attr($last_name); ?>">  
    				<input type="hidden" name="eamil" id="eamil" value="<?php echo esc_attr($email); ?>">  
    				<input type="hidden" name="badults" id="badults" value="<?php echo esc_attr($badults); ?>">  
    				<input type="hidden" name="bchildren" id="bchildren" value="<?php echo esc_attr($bchildren); ?>">  
    				<input type="hidden" name="num_of_peoples" id="num_of_peoples" value="<?php echo esc_attr($num_of_peoples); ?>">  
    				<input type="hidden" name="room_price" id="room_price" value="<?php echo esc_attr($room_price); ?>"> 
    				<input type="hidden" name="address" id="address" value="<?php echo esc_attr($address); ?>">  
    				<input type="hidden" name="check_in" id="check_in" value="<?php echo esc_attr($check_in); ?>">    
    				<input type="hidden" name="check_out" id="check_out" value="<?php echo esc_attr($check_out); ?>">
    				<input type="hidden" name="currency" id="currency" value="<?php echo esc_attr($currency); ?>">
    				<input type="hidden" name="room_type" id="room_type" value="<?php echo esc_attr($room_type); ?>">  
    				<input type="hidden" name="contact_number" id="contact_number" value="<?php echo esc_attr($contact_number); ?>">	
    				<input type="hidden" name="razorpay" id="razorpay" value="<?php echo esc_attr($razorpay_key); ?>">
    				<input type="hidden" name="razorpay_success_url" id="razorpay_success_url" value="<?php echo esc_attr($razorpay_success_url); ?>">
    				<input type="hidden" name="razorpay_cancel_url" id="razorpay_cancel_url" value="<?php echo esc_attr($razorpay_cancel_url); ?>">
    				<input type="hidden" name="razorpay_url" id="razorpay_url" value="<?php echo esc_attr($razorpay_url); ?>">
    				<input type="hidden" name="new_price" id="new_price" value="<?php echo esc_attr($new_price); ?>">
    				<input type="hidden" name="tax_name_n" id="tax_name_n" value="<?php echo esc_attr($tax_name_n); ?>">
    				<input type="hidden" name="text_percent_n" id="text_percent_n" value="<?php echo esc_attr($text_percent_n); ?>">
    				<input type="submit" name="razorpay_submit" id="razorpay_submit" value="">
    				</div>
    			</div>
		<?php 	
       wp_die();	
	}
	
	
	
	/**
	 * Astro Event Table Views
	 */
	public function Astro_cafe_table_view(){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/event/astro-event-table-view.php';    
    } 
	/**
	 * Astro Event Booking Invoice
	 */
    public  function Astro_cafe_booking_invoice(){
       require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/event/astro-event-booking-invoice.php';   
  	}  
	/**
	 * Astro Appointment Booking Views
	 */
	public function Astro_appointment_view(){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/appointment/astro-appointment-view.php';    
    } 
	/**
	 * Astro Appointment Booking Invoice
	 */
	public  function Astro_appointment_booking_invoice(){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/appointment/astro-appointment-invoice.php';   
	} 
	/**
	 * Astro Appointment Schedule Show
	 */
    public function Astro_appointment_schedule_show(){
        extract($_POST);
		global $wpdb;
		$table_prefix = $wpdb->prefix;
		$table_tablename = $table_prefix.'appointment_schedule_booked';
		$results = $wpdb->get_results("SELECT asb_schedule_time FROM $table_tablename WHERE 	asb_schedule_date='$schedule_date'");  
		$asb_schedule_time = '';
		if(!empty($results)):
            $asb_schedule_time = $results[0]->asb_schedule_time;
	    endif;  
		$args = array(  
				'post_type' => 'schedule',
				'post_status' => 'publish',
				'p'=> $schedule_id
		       );
		$schedule_query = new WP_Query($args);
		if($schedule_query->have_posts()):
			while($schedule_query->have_posts()): $schedule_query->the_post();
			$a =1;
			$schedule_date = get_post_meta(get_the_ID(),'appointment_schedule_datepicker',true);
			$schedule_times = get_post_meta(get_the_ID(), 'schedule_times_datas', true );
			$pos = array_search($asb_schedule_time, $schedule_times);
			unset($schedule_times[$pos]); 
			$schedule_currency = get_post_meta(get_the_ID(), 'appointment_currency', true );
			$schedule_price = get_post_meta(get_the_ID(), 'appointment_schedule_price', true );
				if(!empty($schedule_times)):
					foreach($schedule_times as $sc_time):
						echo '<div class="hl-radio-btn">
								<input type="radio" id="checkbox'.esc_attr($a).'" name="hl_appoint_time" value="'.esc_attr($sc_time).'">
								<label for="checkbox'.esc_attr($a).'">'.esc_html($sc_time).'</label>
							</div>'; 
					$a++;
					endforeach;
				endif; 
            endwhile; 
			wp_reset_query();
		endif;
		echo '<input type="hidden" id="schedule_price" name="schedule_price" value="'.esc_attr($schedule_price).'"><input type="hidden" id="schedule_currency" name="schedule_currency" value="'.esc_attr($schedule_currency).'"><input type="hidden" id="schedule_id" name="schedule_id" value="'.base64_encode(get_the_ID()).'">';
        wp_die();  
	}

	/**
	 * Appointment strip Payment form
	 */
	public function Astro_appointment_stripe_payment(){
		extract($_POST);
		$razorpay_url= plugins_url().'/astro-appointment/razorpay/app-payment-process.php';
    	$razorpay_key = get_option('app_razorpay_key');
		$stripe_submit_url = plugins_url().'/astro-appointment/strippayment/astro-appointment-payment.php'; 
		$post_schedule_id = base64_decode($schedule_id); 
        $stripe_publishable_key = get_option('stripe_appointment_publishbale_key');
		$currency = get_option('app_curreny_val');
        $stripe_store_name = get_option('appointment_payment_form_heading');
		$schedule_price = $main_price = get_post_meta($post_schedule_id, 'appointment_schedule_price', true );
		
		$tax_title = get_option('app_tax_title');
		$text_percent = get_option('app_text_percent');
		if(!empty($tax_title) && !empty($text_percent)){
		    $tax = ($schedule_price*$text_percent)/100;
		    $schedule_price = $tax + $schedule_price;
		    if (empty($stripe_publishable_key) && empty($razorpay_key)):
			?> 
			<p><?php echo esc_html__('Your Schedule Price is '.$currency .' '. $main_price .'  and '.$text_percent. '% ' . $tax_title .' Tax on your order and your Total Price '.$currency .' '.$schedule_price ); ?></p>
		    <?php 
			endif;
			}
			?>
			<div class="payment-form">
			    <?php 
			    if (empty($stripe_publishable_key) && empty($razorpay_key)):
			    ?>
			   <!-- Free Booking form start -->
			    <form action="" method="post" id="free_booking_form_data">
                    <input type="hidden" name="booking_id" id="booking_id" value="<?php echo esc_attr($post_schedule_id); ?>">  
                    <input type="hidden" name="strip_cust_name" id="strip_cust_name" value="<?php echo esc_attr($cust_name); ?>"> 
                    <input type="hidden" name="eamil" id="eamil" value="<?php echo esc_attr($cust_email); ?>">  
                    <input type="hidden" name="contact_number" id="contact_number" value="<?php echo esc_attr($cust_phone); ?>">  
                    <input type="hidden" name="strip_cust_message" id="strip_cust_message" value="<?php echo esc_attr($cust_message); ?>">  
                    <input type="hidden" name="booking_date" id="booking_date" value="<?php echo esc_attr($cust_date); ?>">  
                    <input type="hidden" name="booking_time" id="booking_time" value="<?php echo esc_attr($appoint_time); ?>"> 
        			<input type="hidden" name="schedule_price" id="schedule_price" value="<?php echo esc_attr($schedule_price); ?>">
        			<input type="hidden" name="new_price" id="new_price" value="<?php echo esc_attr($schedule_price); ?>">
        			<input type="submit" name="free_booking_submit" id="free_booking_submit" class="al-btn" value="<?php esc_attr_e('submit', 'Astro'); ?>"/>
                </form> 
                <?php 
				endif;
				 if (!empty($stripe_publishable_key)):
			    ?>
                 <!-- Free Booking form end-->
        		<form action="<?php echo esc_url($stripe_submit_url); ?>" method="post" id="form_data_strip">
                <script src="https://checkout.stripe.com/checkout.js" class="stripe-button"
                    data-key="<?php echo esc_attr($stripe_publishable_key); ?>"
                    data-name="<?php echo esc_attr($stripe_store_name); ?>"
                    data-currency="<?php echo esc_attr($currency); ?>"
                    
        			data-amount="<?php echo esc_attr($schedule_price*100); ?>"
                    data-email="<?php echo esc_attr($cust_email); ?>"
                    data-locale="auto"></script> 
                    <input type="hidden" name="item_id" id="item_id" value="<?php echo esc_attr($post_schedule_id); ?>">  
                    <input type="hidden" name="strip_cust_name" id="strip_cust_name" value="<?php echo esc_attr($cust_name); ?>"> 
                    <input type="hidden" name="eamil" id="eamil" value="<?php echo esc_attr($cust_email); ?>">  
                    <input type="hidden" name="contact_number" id="contact_number" value="<?php echo esc_attr($cust_phone); ?>">  
                    <input type="hidden" name="strip_cust_message" id="strip_cust_message" value="<?php echo esc_attr($cust_message); ?>">  
                    <input type="hidden" name="strip_booking_date" id="strip_booking_date" value="<?php echo esc_attr($cust_date); ?>">  
                    <input type="hidden" name="strip_booking_time" id="strip_booking_time" value="<?php echo esc_attr($appoint_time); ?>"> 
        			<input type="hidden" name="new_price" id="new_price" value="<?php echo esc_attr($schedule_price); ?>">
        			<input type="hidden" name="tax_name_n" id="tax_name_n" value="<?php echo esc_attr($tax_name_n); ?>">
        			<input type="hidden" name="text_percent_n" id="text_percent_n" value="<?php echo esc_attr($text_percent_n); ?>">
                </form> 
            <?php
            	endif;
            	
    			// Razorpay Payment form
    			$razorpay_url= plugins_url().'/astro-appointment/razorpay/app-payment-process.php';
    			$razorpay_key = get_option('app_razorpay_key');
    			$razorpay_success_url = get_option('app_razorpay_success_url');
    			$razorpay_cancel_url = get_option('app_razorpay_cancel_url');
    			if (!empty($razorpay_key)):
    			?>
    			<form action="" method="post" id="form_data_razorpay_app">
    			<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    				<input type="hidden" name="item_id" id="item_id" value="<?php echo esc_attr($schedule_id); ?>">  
    				<input type="hidden" name="strip_cust_name" id="strip_cust_name" value="<?php echo esc_attr($cust_name); ?>"> 
    				<input type="hidden" name="eamil" id="eamil" value="<?php echo esc_attr($cust_email); ?>">  
    				<input type="hidden" name="contact_number" id="contact_number" value="<?php echo esc_attr($cust_phone); ?>">  
    				<input type="hidden" name="strip_cust_message" id="strip_cust_message" value="<?php echo esc_attr($cust_message); ?>">  
    				<input type="hidden" name="strip_booking_date" id="strip_booking_date" value="<?php echo esc_attr($cust_date); ?>">  
    				<input type="hidden" name="strip_booking_time" id="strip_booking_time" value="<?php echo esc_attr($appoint_time); ?>">
    				<input type="hidden" name="razorpay" id="razorpay" value="<?php echo esc_attr($razorpay_key); ?>">
    				<input type="hidden" name="razorpay_success_url" id="razorpay_success_url" value="<?php echo esc_attr($razorpay_success_url); ?>">
    				<input type="hidden" name="razorpay_cancel_url" id="razorpay_cancel_url" value="<?php echo esc_attr($razorpay_cancel_url); ?>">
    				<input type="hidden" name="razorpay_url" id="razorpay_url" value="<?php echo esc_attr($razorpay_url); ?>">
    				<input type="hidden" name="new_prices" id="new_prices" value="<?php echo esc_attr($schedule_price); ?>">
    				<input type="hidden" name="tax_name_n" id="tax_name_n" value="<?php echo esc_attr($tax_title); ?>">
    				<input type="hidden" name="text_percent_n" id="text_percent_n" value="<?php echo esc_attr($text_percent); ?>">
    				<input type="submit" name="razorpay_submit" id="razorpay_submit" value="">
    				</form> 
    			</div>
		<?php 
		endif;
       wp_die();	
	}
}