<?php
/***
 * Astro Custom Post Type For Create Schedule 
 */
$r_labels = array(
    'name' => esc_html__( 'Astro Schedule', 'astro' ),
    'singular_name' => esc_html__( 'Astro Schedule', 'astro' ),
    'menu_name'  => esc_html__( 'Astro Schedule', 'admin menu', 'astro' ),
    'name_admin_bar' => _x( 'Astro Schedule', 'add new on admin bar', 'astro' ),
    'add_new' => _x( 'Add New', 'Schedule', 'astro' ),
    'add_new_item' => esc_html__( 'Add New Schedule', 'astro' ),
    'new_item'  => esc_html__( 'New Schedule', 'astro' ),
    'edit_item' => esc_html__( 'Edit Schedule', 'astro' ),
    'view_item' => esc_html__( 'View Schedule', 'astro' ),
    'all_items' => esc_html__( 'All Schedule', 'astro' ),
    'search_items' => esc_html__( 'Search Schedule', 'astro' ),
    'parent_item_colon'  => esc_html__( 'Parent Schedule:', 'astro' ),
    'not_found' => esc_html__( 'No Schedule found.', 'astro' ),
    'not_found_in_trash' => esc_html__( 'No Schedule found in Trash.', 'astro' )
   );

$hr_args = array(
    'labels'             => $r_labels,
    'description'        => esc_html__( 'Description.', 'astro' ),
    'public'             => true,
    'publicly_queryable' => true,
    'show_ui'            => true,
    'show_in_menu'       => false,
    'query_var'          => true,
    'rewrite'            => array( 'slug' => 'schedule' ),
    'capability_type'    => 'post',
    'has_archive'        => true,
    'hierarchical'       => false,
    'menu_position'      => null,
    'menu_icon'          => 'dashicons-video-alt3',
    'supports'           => array( 'title', 'editor', 'author')
   );
register_post_type('schedule', $hr_args );
  /* Add new taxonomy, make it hierarchical (like categories) */
  $rty_labels = array(
    'name'              => esc_html__( 'Schedule Types', 'astro' ),
    'singular_name'     => esc_html__( 'Schedule Type', 'astro' ),
    'search_items'      => esc_html__( 'Search Schedule Types', 'astro' ),
    'all_items'         => esc_html__( 'All Schedule Types', 'astro' ),
    'parent_item'       => esc_html__( 'Parent Schedule Type', 'astro' ),
    'parent_item_colon' => esc_html__( 'Parent Schedule Type:', 'astro' ),
    'edit_item'         => esc_html__( 'Edit Schedule Type', 'astro' ),
    'update_item'       => esc_html__( 'Update Schedule Type', 'astro' ),
    'add_new_item'      => esc_html__( 'Add New Schedule Type', 'astro' ),
    'new_item_name'     => esc_html__( 'New Schedule Type Name', 'astro' ),
    'menu_name'         => esc_html__( 'Schedule Type', 'astro' ),
  );
  $rty_args = array(
    'hierarchical'      => true,
    'labels'            => $rty_labels,
    'show_ui'           => true,
    'show_admin_column' => true,
    'query_var'         => true,
    'rewrite'           => array('slug' => 'schedule-type'),
  );
register_taxonomy('schedule-type', array('schedule'), $rty_args );  