<?php
/**
 * Astro Event Booking List 
 */
class Astro_appointment_booking_list extends WP_List_Table {
  
	public function __construct() {
		// Set parent defaults.
		parent::__construct( array(
			'singular' => 'user',     // Singular name of the listed records.
			'plural'   => 'users',    // Plural name of the listed records.
			'ajax'     => false,       // Does this table support ajax?
		) );
	} 

	public function display_data() {
		global $wpdb;
		$booking_data = array();
		$pmt_tbl = $wpdb->prefix .'appointment_schedule_booked'; 
        if(isset($_GET['s']) && $_GET['s'] != ''){
		    $allubooked = get_users( array('search' => $_GET['s']) );
		    $books_ids = array();
		    foreach($allubooked as $booked){
		        $books_ids[] = $booked->asb_id;
		    }  
		    $str_ids = implode(',', $books_ids);
		    $booking_query = $wpdb->get_results("SELECT * FROM $pmt_tbl WHERE asb_id in($str_ids)");
		}else{
		    $booking_query = $wpdb->get_results("SELECT * FROM $pmt_tbl ORDER BY asb_id ASC");
		}
        $payment_curreny = get_option('stripe_appointment_currency_val');
       
		if($booking_query) {   
			foreach ($booking_query as $booking) {
                $customer_details = '';
				if(!empty($booking->asb_customer_details)):
				  $customer_details = json_decode($booking->asb_customer_details);
				endif;
				// print_r($customer_details);
				$strip_cust_name = '';
				if(!empty($customer_details->strip_cust_name)):
		           $strip_cust_name = $customer_details->strip_cust_name;
                endif;
				$eamil = '';
				if(!empty($customer_details->eamil)):
				   $eamil = $customer_details->eamil;
				endif;
				$contact_number = '';
				if(!empty($customer_details->contact_number)):
				    $contact_number = $customer_details->contact_number;
				endif;
				$cust_message = '';
				if(!empty($customer_details->strip_cust_message)):
					$cust_message = $customer_details->strip_cust_message;
				endif;
				$booking_data[] = array(
						'ID' => $booking->asb_id, 
						'customer_name' => $strip_cust_name, 
						'email' => $eamil,
						'contact_number' => $contact_number,
						'txn_id' => $booking->asb_txnid,
						'payment_amount' => $payment_curreny.' '.$booking->asb_payment_amount	,
						'payment_status' => $booking->asb_payment_status	, 
						'booking_date' => date('d-m-Y',strtotime($booking->asb_schedule_date)),
						'booking_time' => $booking->asb_schedule_time,
						'message'=> $cust_message, 
						); 

			}
		}
		return $booking_data;
	}

	public function no_items() {
	  esc_html_e('No Booking Avaliable.', 'astro');
	}

	public function get_columns() {
		$columns = array(
			'cb' => '<input type="checkbox" />',   
			'customer_name' => esc_html__('Customer', 'astro'),
			'email' => esc_html__('Email', 'astro'),
			'contact_number' => esc_html__('Contact Number', 'astro'),
			'txn_id' => esc_html__('Transaction Id', 'astro'),
			'payment_amount' => esc_html__('Amount', 'astro'),
			'payment_status' => esc_html__('Status', 'astro' ),
			'booking_date' => esc_html__('Booking Date', 'astro'),
			'booking_time' => esc_html__('Booking Time', 'astro'), 
			'message'=> esc_html__('Message', 'astro'),
			); 
        return $columns;
	}

	protected function get_sortable_columns() {
		 $sortable_columns = array(
			  'email'    => array('email', false),
			  'contact_number'   => array('contact_number', false),
			  'booking_date'   => array('booking_date', false),
			  'booking_time'   => array('booking_time', false),
			);  
        return $sortable_columns;
	} 

	protected function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'customer_name':
				return $item[ $column_name ];
			case 'email':
				return $item[ $column_name ];
			case 'contact_number':
				return $item[ $column_name ];
			case 'txn_id':
				return $item[ $column_name ];
			case 'payment_amount':
				return $item[ $column_name ];
			case 'payment_status':
				return $item[ $column_name ];			
			case 'booking_date':
				return $item[ $column_name ];
			case 'booking_time':
				return $item[ $column_name ];
			case 'message':
				return $item[ $column_name ];	
		}  
	}

	protected function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="%1$s[]" value="%2$s" />',
			$this->_args['singular'],  // Let's simply repurpose the table's singular label ("user").
			$item['ID']                // The value of the checkbox should be the record's ID.
		);
	}

	protected function column_title( $item ) {
		$page = wp_unslash( $_REQUEST['page'] ); // WPCS: Input var ok.

		// Build edit row action.
		$edit_query_args = array(
			'page'   => $page,
			'action' => 'edit',
			'user'  => $item['ID'],
		);

		$actions['edit'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $edit_query_args, 'admin.php' ), 'edituser_' . $item['ID'] ) ),
			_x( 'Edit', 'row action','astro')
		);

		// Build delete row action.
		$delete_query_args = array(
			'page'   => $page,
			'action' => 'delete',
			'user'  => $item['ID'],
		);

		$actions['delete'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $delete_query_args, 'admin.php' ), 'deleteuser_' . $item['ID'] ) ),
			_x( 'Delete', 'row action','astro')
		);

		// Return the title contents.
		return sprintf( '%1$s %2$s',
			$item['customer_name'],
			$this->row_actions( $actions )
		);
	}

	protected function get_bulk_actions() {
		$actions = array(
			'delete' => _x( 'Delete', 'bulk action', 'astro' ),
		);

		return $actions;
	}


	protected function process_bulk_action() {
		// Detect when a bulk action is being triggered.
		global $wpdb;  
		$pmt_tbl = $wpdb->prefix . 'appointment_schedule_booked';
       
		if ( 'delete' === $this->current_action() ) {
			foreach ($_GET['user'] as $value) {
               $wpdb->delete( $pmt_tbl, array( 'asb_id' => $value ), array( '%d' ) );
			}
		}
  
		// Edit when a bulk action is being triggered.
		if ( 'edit' === $this->current_action() ) {
			$this->single_row_edit();
			wp_die( 'Items edited (or they would be if we had items to edit)!' );
		}
	}

	function single_row_edit() {
		require dirname( __FILE__ ) . '/user-edit.php';
		wp_die();
	}

	function prepare_items() {
		global $wpdb; //This is used only if making any database queries

		/*
		 * First, lets decide how many records per page to show
		 */
		
		$per_page = 20;
        $columns  = $this->get_columns();
		$hidden   = array();
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array( $columns, $hidden, $sortable );

		$this->process_bulk_action();

		$data = $this->display_data();

		usort( $data, array( $this, 'usort_reorder' ) );

		$current_page = $this->get_pagenum();

		$total_items = count( $data );

		$data = array_slice( $data, ( ( $current_page - 1 ) * $per_page ), $per_page );

		$this->items = $data;

		$this->set_pagination_args( array(
			'total_items' => $total_items,                     // WE have to calculate the total number of items.
			'per_page'    => $per_page,                        // WE have to determine how many items to show on a page.
			'total_pages' => ceil( $total_items / $per_page ), // WE have to calculate the total number of pages.
		) );
	}

	protected function usort_reorder( $a, $b ) {
		// If no sort, default to title.
		$orderby = ! empty( $_REQUEST['orderby'] ) ? wp_unslash( $_REQUEST['orderby'] ) : 'customer_name'; 

		// If no order, default to asc.
		$order = ! empty( $_REQUEST['order'] ) ? wp_unslash( $_REQUEST['order'] ) : 'asc'; 

		// Determine sort order.
		$result = strcmp( $a[ $orderby ], $b[ $orderby ] );

		return ( 'asc' === $order ) ? $result : - $result;
	}
}
 
/**
 * Astro Appointment Schedule List
 */
class Astro_appointment_schedule_list extends WP_List_Table {

	public function __construct() {
		// Set parent defaults.
		parent::__construct( array(
			'singular' => 'user',     // Singular name of the listed records.
			'plural'   => 'users',    // Plural name of the listed records.
			'ajax'     => true,       // Does this table support ajax?
		) );
	}

	public function display_data() {
        global $wpdb; 
		$schedule_data = array();
		$args = array(
			'post_type' =>'schedule',
			'posts_per_page' => -1,
			'post_status' =>'publish',
		   ); 
	    $schedule_query = new WP_Query($args);
        if($schedule_query->have_posts() ) :
		    while($schedule_query->have_posts() ) : $schedule_query->the_post();
            $terms_slug_str = '';
			$terms = get_the_terms(get_the_ID(), 'schedule-type'); 
			if ($terms && ! is_wp_error($terms)) :
				$tslugs_arr = array();
				foreach ($terms as $term) {
					$tslugs_arr[] = $term->name;
				}
				$terms_slug_str = join( " ", $tslugs_arr);
			endif;

            $schedule_title = '<a href="'.esc_url(get_the_permalink(get_the_ID())).'">'.get_the_title().'</a>';
			$delete_query_args = array(
				'page'   => 'appointment_schedule', 
				'action' => 'delete',
				'user'  => get_the_ID(),
			   );
			$schedule_edite = '<a href="'.esc_url(get_edit_post_link(get_the_ID())).'" class="hl-edit">'.esc_html__('Edit','astro').'</a> <a href="'.esc_url( wp_nonce_url( add_query_arg( $delete_query_args, 'admin.php' ), 'deleteuser_'.get_the_ID()) ).'" class="hl-delete">'.esc_html__('Delete','astro').'</a>';

            $price_currency = get_post_meta(get_the_ID(),'appointment_currency',true);
            $schedule_price = get_post_meta(get_the_ID(),'appointment_schedule_price',true);
			$schedule_capacity = get_post_meta(get_the_ID(),'appointment_schedule_capacity',true);
            $schedule_status = get_post_meta(get_the_ID(),'appointment_status',true);
			
			if($schedule_status == 'open'):
                $schedule_status = '<span class="hl-status-active">'.get_post_meta(get_the_ID(),'appointment_status',true).'</span>'; 
            else: 
			    $schedule_status = '<span class="hl-status-deactivate">'.get_post_meta(get_the_ID(),'appointment_status',true).'</span>'; 
			endif;
			$schedule_date = get_post_meta(get_the_ID(),'appointment_schedule_datepicker',true);
            $schedule_data[] = array('ID' => get_the_ID(), 
							'schedule_name' => $schedule_title, 
							'schedule_date' => $schedule_date,
							'schedule_price' => $price_currency.''.$schedule_price,
							'schedule_capacity' => $schedule_capacity,
							'status' => $schedule_status,
							'actions' => $schedule_edite, 
							);

		    endwhile;
		endif;
        return $schedule_data;
	}

	public function no_items() {
	  echo esc_html_e( 'No Schedule avaliable.','astro');
	}

	public function get_columns() {
		$columns = array(
			'cb' => '<input type="checkbox" />', 
			'schedule_name' => esc_html__( 'Schedule Name','astro'),
			'schedule_date' => esc_html__( 'Schedule Dete','astro'),
			'schedule_price' => esc_html__( 'Schedule Price','astro' ),
			'schedule_capacity' => esc_html__( 'Schedule Capacity','astro'),
			'status' => esc_html__( 'Status', 'astro'),
			'actions' => esc_html__( 'Actions', 'astro'),
		    ); 
        return $columns; 
	}

	protected function get_sortable_columns() {
		$sortable_columns = array(
			'schedule_name'  => array('schedule_name', false ),
			'schedule_price' => array('schedule_price', false )
		);
        return $sortable_columns;
	} 

	protected function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'schedule_name':
				return $item[ $column_name ];
				break;
			case 'schedule_date':
				return $item[ $column_name ];
				break;
			case 'schedule_price':
				return $item[ $column_name ];
				break;
			case 'schedule_capacity':
				return $item[ $column_name ];
				break;
			case 'status':
				return $item[ $column_name ];
				break;
			case 'actions':
				return $item[ $column_name ];
			    break;
			
        }
		
	}

	protected function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="%1$s[]" value="%2$s" />',
			$this->_args['singular'],  // Let's simply repurpose the table's singular label ("user").
			$item['ID']                // The value of the checkbox should be the record's ID.
		);
	}

	protected function column_title( $item ) {
		$page = wp_unslash( $_REQUEST['page'] ); // WPCS: Input var ok.
        // Build edit row action.
		$edit_query_args = array(
			'page'   => $page,
			'action' => 'edit',
			'user'  => $item['ID'],
		);
         
		$actions['edit'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $edit_query_args, 'admin.php' ), 'edituser_' . $item['ID'] ) ),
			_x( 'Edit', 'row action','astro')
		);

		// Build delete row action.
		$delete_query_args = array(
			'page'   => $page,
			'action' => 'delete',
			'user'  => $item['ID'],
		);

		$actions['delete'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $delete_query_args, 'admin.php' ), 'deleteuser_' . $item['ID'] ) ),
			_x( 'Delete', 'row action', 'astro')
		);

		// Return the schedule_name contents.
		return sprintf( '%1$s %2$s',
			$item['schedule_name'],
			$this->row_actions( $actions )
		);
	} 
 
	protected function get_bulk_actions() {
		$actions = array(
			'delete' => _x( 'Delete', 'bulk action', 'astro'),
		);

		return $actions;
	}
 
    protected function process_bulk_action() {
		// Detect when a bulk action is being triggered.
		if ( 'delete' === $this->current_action() ) {
			if(is_array($_GET['user'])){
				foreach ($_GET['user'] as $value) {
				wp_delete_post($value);
				}
		    }else{
				wp_delete_post($_GET['user']);
			}
		} 

		// Edit when a bulk action is being triggered.
		if ('edit' === $this->current_action()) {
			$this->single_row_edit();
		} 
	} 

	function single_row_edit() {
		require dirname( __FILE__ ) . '/user-edit.php';
		wp_die();
	}

	function prepare_items() {
		global $wpdb; //This is used only if making any database queries

		/*
		 * First, lets decide how many records per page to show
		 */
		$per_page = 20;
        $columns  = $this->get_columns();
		$hidden   = array();
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array( $columns, $hidden, $sortable );

		$this->process_bulk_action();

		$data = $this->display_data();

		usort( $data, array( $this, 'usort_reorder' ) );

		$current_page = $this->get_pagenum();

		$total_items = count( $data );

		$data = array_slice( $data, ( ( $current_page - 1 ) * $per_page ), $per_page );

		$this->items = $data;

		$this->set_pagination_args( array(
			'total_items' => $total_items,                     // WE have to calculate the total number of items.
			'per_page'    => $per_page,                        // WE have to determine how many items to show on a page.
			'total_pages' => ceil( $total_items / $per_page ), // WE have to calculate the total number of pages.
		) );
	}

	protected function usort_reorder( $a, $b ) {
		// If no sort, default to title.
		$orderby = ! empty( $_REQUEST['orderby'] ) ? wp_unslash( $_REQUEST['orderby'] ) : 'schedule_name'; 

        // If no order, default to asc.
		$order = ! empty( $_REQUEST['order'] ) ? wp_unslash( $_REQUEST['order'] ) : 'asc'; 
        
		// Determine sort order.
		$result = strcmp( $a[ $orderby ], $b[ $orderby ] );

		return ( 'asc' === $order ) ? $result : - $result;
	} 
}