<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://codecanyon.net/user/kamleshyadav
 * @since      1.0.0
 *
 * @package    Astro
 * @subpackage Astro/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Astro
 * @subpackage Astro/admin
 * @author     kamleshyadav <kamlesh.yadav@himanshusofttech.com >
 */
class Astro_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Astro_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Astro_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
	   
		if(get_post_type() !='page'):
	 	 wp_enqueue_style('bootstrap', plugins_url(). '/astro-appointment/assets/css/bootstrap.min.css', array(), '5.0.2', 'all' );
	 	 wp_enqueue_style('bootstrap-datepicker', plugins_url(). '/astro-appointment/assets/css/bootstrap-datepicker.min.css', array(), '1.9.0', 'all' );   
		 wp_enqueue_style('bootstrap-datetimepicker', plugins_url(). '/astro-appointment/assets/css/bootstrap-datetimepicker.css', array(), '1.9.0', 'all' );  
		endif;
	 	 wp_enqueue_style('astro-font', plugins_url(). '/astro-appointment/assets/css/astro-font.css', array(), '1.0', 'all' );
		 wp_enqueue_style('printarea', plugins_url(). '/astro-appointment/assets/css/printarea.css', array(), '3.5.7', 'all' );  
         wp_enqueue_style('toastr', plugins_url(). '/astro-appointment/assets/css/toastr.min.css', array(), '2.1.3', 'all' );
		 wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/astro-admin.css', array(), $this->version, 'all' );
	}
    
	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Astro_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Astro_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
	    wp_enqueue_script('bootstrap', plugins_url(). '/astro-appointment/assets/js/bootstrap.min.js', array( 'jquery' ), '5.0.2', false );	
        wp_enqueue_script('bootstrap-datepicker', plugins_url(). '/astro-appointment/assets/js/bootstrap-datepicker.min.js', array( 'jquery' ), '5.0.2', false );	
        wp_enqueue_script('bootstrap-datetimepicker', plugins_url(). '/astro-appointment/assets/js/bootstrap-datetimepicker.min.js', array(), '3.5.7', 'all'); 
        wp_enqueue_script('printarea', plugins_url(). '/astro-appointment/assets/js/jquery.PrintArea.js', array(), '3.5.7', 'all');  
        wp_enqueue_script('toastr', plugins_url(). '/astro-appointment/assets/js/toastr.min.js', array( 'jquery' ), '2.1.3', false );
		//wp_enqueue_script('xlsx.core.min', plugins_url(). '/astro-appointment/assets/js/xlsx.core.min.js', array( 'jquery' ), '2.1.3', false );
		wp_enqueue_script('table2csv', plugins_url(). '/astro-appointment/assets/js/table-export/table2csv.js', array( 'jquery' ), '2.1.3', false );
		wp_enqueue_script('jquery.table2excel', plugins_url(). '/astro-appointment/assets/js/table-export/jquery.table2excel.js', array( 'jquery' ), '2.1.3', false );
		
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/astro-admin.js', array( 'jquery' ), $this->version, false );
		
		
        wp_localize_script($this->plugin_name, 'Astro_ajax_path', array(
			'url' => admin_url('admin-ajax.php'),
			) 
	    );

	}
	/**
	 * Astro Custom Post Type
	 */
	public function Astro_custom_post_type(){
        /**
		 * Hotel Rooms Create
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/hotel/astro-create-room.php';

		/**
		 * Appointment Schedule Create
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/appointment/astro-appointment-schedule-create.php'; 

		/**
		 * Event Date Setting Option
		 */
	    require_once plugin_dir_path(dirname(__FILE__)).'admin/partials/event/astro-event-date-setting.php'; 
    }

	/**
     * Astro Connection
     */
    public function Astro_connection(){
        extract($_POST);
        $Astro_con = update_option('Astro_connection_details', $startbooking);
		if($Astro_con){ 
		       echo json_encode( array( 'status' => 1, 'msg' => 'Connection Has Been Successfully ' ) );
		 }else{
			   echo json_encode( array( 'status' => 0, 'msg' => 'Something went Wrong!' ) );
		 } 
        wp_die();
    } 
    /**
     * Astro Diconnection 
     */
    public function Astro_disconnection(){  
        
        $Astro_dic = delete_option('Astro_connection_details');
        if($Astro_dic){
           echo json_encode( array( 'status' => 1, 'msg' => 'Disconnection Has Been Successfully ' ) );
        }else{
            echo json_encode( array( 'status' => 0, 'msg' => 'Something went Wrong!' ) );
        }

    wp_die();  
    }

	/**
	 * Astro Plugin Admin Menus
	 */
	public function Astro_admin_menu(){

		// Astro Main Menu
		add_menu_page( 
			__( 'Astro', 'astro' ),
			'Astro',
			'manage_options',
			'astro-menu',
			array( $this, 'Astro_menu_pages'),
			plugin_dir_url( __FILE__ ) . 'images/astro-appointment.png',
			2
		);
        add_submenu_page('astro-menu', 'QR Code', 'QR Code', 'manage_options', 'astro-qr-code',array( $this, 'Astro_qr_code'));

        add_submenu_page('astro-menu', 'Social Share', 'Social Share', 'manage_options', 'astro-social-share',array( $this, 'Astro_social_share'));
 
        $Astro_startbooking = get_option('Astro_connection_details');
		switch ($Astro_startbooking):
			case 'hotelbooking':
			// Astro Hotal Options
			add_submenu_page('astro-menu', 'Hotel', 'Hotel', 'manage_options', 'hotel-options',array( $this, 'Astro_hotel_option'));
			
           	add_submenu_page('hotel-options', 'Rooms', 'Rooms', 'manage_options', 'hotel_rooms',array($this,'Astro_hotel_room'));
        
			add_submenu_page('hotel-options', 'Booking', 'Booking', 'manage_options', 'hotel_booking',array($this,'Astro_hotel_booking'));

			add_submenu_page('hotel-options', 'Payment', 'Payment', 'manage_options', 'hotel_payment',array($this,'Astro_hotel_payment'));

			add_submenu_page('hotel-options', 'Form', 'Form', 'manage_options', 'hotel_form',array($this,'Astro_hotel_form'));
			break;
			case 'appointmentbooking':
			// Astro Appointment Options
			add_submenu_page( 'astro-menu', 'Appointment', 'Appointment', 'manage_options', 'appointment-options',array( $this, 'Astro_appointment_option'));
        
			add_submenu_page('appointment-options', 'Schedule', 'Schedule', 'manage_options', 'appointment_schedule',array($this,'Astro_appointment_schedule'));

			add_submenu_page('appointment-options', 'booking', 'booking', 'manage_options', 'appointment_booking',array($this,'Astro_appointment_booking'));

			add_submenu_page('appointment-options', 'paymentsetting', 'paymentsetting', 'manage_options', 'appointment_paymentsetting',array($this,'Astro_appointment_paymentsetting')); 
            
			add_submenu_page('appointment-options', 'formsetting', 'formsetting', 'manage_options', 'appointment_formsetting',array($this,'Astro_appointment_formsetting')); 
            break; 
			case 'cafebooking':
			// Astro Event Options
			add_submenu_page('astro-menu', 'Event', 'Event', 'manage_options', 'event-options',array( $this, 'Astro_cafe_option'));

			add_submenu_page('event-options', 'Setting', 'Setting', 'manage_options', 'cafe_setting',array($this,'Astro_cafe_setting')); 

			add_submenu_page('event-options', 'Booking', 'Booking', 'manage_options', 'cafe_booking',array($this,'Astro_cafe_booking_mange'));

			add_submenu_page('event-options', 'Booking', 'Booking', 'manage_options', 'cafe_booking',array($this,'Astro_cafe_booking_mange'));

			add_submenu_page('event-options', 'Payment', 'Payment', 'manage_options', 'cafe_payment',array($this,'Astro_cafe_payment_setting'));

			add_submenu_page('event-options', 'Form', 'Form', 'manage_options', 'cafe_form',array($this,'Astro_cafe_form_setting'));
			break;
        endswitch;

	}  
	
	/**
	 * Astro Plugin Menu Pages
	 */
	public function Astro_menu_pages(){
	   require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/astro-admin-display.php';
	}

	/**
	 * Astro Hotel Options
	 */
	public function Astro_hotel_option(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/hotel/astro-hotel.php';
	}
	/**
	 * Astro Hotel Room Mange
	 */
	public function Astro_hotel_room(){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/hotel/astro-room-mange.php';
	}
    /**
	 * Astro Hotel Bookings Mange
	 */
	public function Astro_hotel_booking(){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/hotel/astro-booking-mange.php';
    }

	/**
	 * Astro Hotel Payment Setting
	 */
	public function Astro_hotel_payment(){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/hotel/astro-payment-mange.php';
    }
	/**
	 * Astro Hotel Form Setting
	 */
	public function Astro_hotel_form(){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/hotel/astro-form-mange.php';
    } 
	
	/**
	 * Astro Hotel Payment Setting
	 */
    public function Astro_payment_details_save(){
        extract($_POST);
		update_option( 'curreny_val', $curreny_val);
		update_option( 'tax_title', $tax_title);
		update_option( 'text_percent', $text_percent);
		echo esc_html__('Details has been Saved Success','astro'); 
	    wp_die();
	}
	/**
	 * Astro Hotel Payment Details Save
	 */
    public function Astro_hotel_stripe_payment_details_save(){
        extract($_POST);
		  update_option( 'stripe_publishbale_key', $stripe_publishbale_key);
		  update_option( 'stripe_secret_key', $stripe_secret_key);
		  update_option( 'stripe_email', $stripe_email);
		  update_option( 'stripe_success_url', $stripe_success_url);
		  update_option( 'stripe_cancel_url', $stripe_cancel_url);  
		  echo esc_html__('Details has been Saved Success','astro'); 
	    wp_die();
	}
	/**
	 * Astro Hotel Razorpay Payment Details Save
	 */
    public function Astro_hotel_razorpay_payment_details_save(){
        extract($_POST);
		  update_option( 'razorpay_key', $razorpay_key);
		  update_option( 'razorpay_success_url', $razorpay_success_url);
		  update_option( 'razorpay_cancel_url', $razorpay_cancel_url);
		  echo esc_html__('Details has been Saved Success','astro');
	    wp_die();
	}
    /**
	 * Hotel Custom Option Settings
	 */
	public function Astro_hotel_custom_option_save(){
		extract($_POST);
		  update_option( 'hotel_confirmation_charge', $confirmation_charge);
		  update_option( 'hotel_display_currency', $display_currency);
		  update_option( 'hotel_booking_form_heading', $booking_form_heading); 
		  update_option( 'hotel_booking_review_heading', $booking_review_heading);
		  update_option( 'hotel_payment_form_heading', $payment_form_heading); 
		  update_option( 'hotel_booking_invoice_heading', $booking_invoice_heading);   
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die(); 
	}  
	
	
	/**
	 * Hotel Custom Option Settings
	 */
	public function Astro_hotel_sms_option_save(){
		extract($_POST);
		  update_option( 'acsid', $acsid);
		  update_option( 'auth_token', $auth_token);
		  update_option( 'ac_phone', $ac_phone); 
		  update_option( 'ac_mssid', $ac_mssid);
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die(); 
	}  
	
	/**
	 * Hotel Custom Option Settings
	 */
	public function Astro_hotel_email_option_save(){
		extract($_POST);
		  update_option( 'email_h', $email_h);
		  update_option( 'email_sub', $email_sub);
		  update_option( 'email_content', $email_content); 
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die(); 
	}  
	
	/**
	 * Hotel Custom color Settings
	 */
	public function Astro_hotel_color_option_save(){
		extract($_POST);
		  update_option( 'primary_color', $primary_color);
		  update_option( 'gc_color', $gc_color);
		  update_option( 'gcc_color', $gcc_color); 
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die(); 
	}  
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	/**
	 * Astro Event Payment Setting
	 */
    public function Astro_payment_cafe_details_save(){
        extract($_POST);
		update_option( 'curreny_val', $curreny_val);
		update_option( 'tax_title', $tax_title);
		update_option( 'text_percent', $text_percent);
		echo esc_html__('Details has been Saved Success','astro'); 
	    wp_die();
	}
	/**
	 * Event Strip Payment Details Save
	 */
    public function Astro_cafe_payment_dateails_save(){
	    extract($_POST);
		update_option( 'stripe_cafe_publishbale_key', $stripe_cafe_publishbale_key);
		update_option( 'stripe_cafe_secret_key', $stripe_cafe_secret_key);
		update_option( 'stripe_cafe_email', $stripe_email); 
		update_option( 'stripe_cafe_success_url', $stripe_success_url);
		update_option( 'stripe_cafe_cancel_url', $stripe_cancel_url); 
		echo esc_html__('Details has been Saved Success','astro'); 
	    wp_die();
	}
	/**
	 * Astro Event Razorpay Payment Details Save
	 */
    public function Astro_cafe_razorpay_payment_details_save(){
        extract($_POST);
		  update_option( 'cafe_razorpay_key', $cafe_razorpay_key);
		  update_option( 'cafe_razorpay_success_url', $cafe_razorpay_success_url);
		  update_option( 'cafe_razorpay_cancel_url', $cafe_razorpay_cancel_url);
		  echo esc_html__('Details has been Saved Success','astro');
	    wp_die();
	}
	/**
	 * Event SMS Option Settings
	 */
	public function Astro_cafe_sms_option_save(){
		extract($_POST);
		  update_option( 'cafe_acsid', $cafe_acsid);
		  update_option( 'cafe_auth_token', $cafe_auth_token);
		  update_option( 'cafe_ac_phone', $cafe_ac_phone); 
		  update_option( 'cafe_ac_mssid', $cafe_ac_mssid);
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die(); 
	}  
	
	/**
	 * Hotel email Option Settings
	 */
	public function Astro_cafe_email_option_save(){
		extract($_POST);
		  update_option( 'cafe_email_h', $cafe_email_h);
		  update_option( 'cafe_email_sub', $cafe_email_sub);
		  update_option( 'cafe_email_content', $cafe_email_content); 
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die(); 
	}  
	
	/**
	 * Hotel Custom color Settings
	 */
	public function Astro_cafe_color_option_save(){
		extract($_POST);
		  update_option( 'primary_color', $primary_color);
		  update_option( 'gc_color', $gc_color);
		  update_option( 'gcc_color', $gcc_color); 
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die(); 
	}  
    /**
	 * Event Custom Option Settings
	 */
	public function Astro_cafe_custom_option_save(){
		extract($_POST);
		  update_option( 'cafe_confirmation_charge', $confirmation_charge);
		  update_option( 'cafe_display_currency', $display_currency);
		  update_option( 'cafe_booking_form_heading', $booking_form_heading); 
		  update_option( 'cafe_booking_review_heading', $booking_review_heading);
		  update_option( 'cafe_payment_form_heading', $payment_form_heading); 
		  update_option( 'cafe_booking_invoice_heading', $booking_invoice_heading); 
		  update_option( 'cafe_booking_calendar_heading', $cafe_booking_calendar_heading);  
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die();
	}  
	/**
	 * Astro Appointment Options
	 */
	public function Astro_appointment_option(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/appointment/astro-appointment.php';
	}
	/**
	 * Astro Appointment Schedule Mange
	 */
    public function Astro_appointment_schedule(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/appointment/astro-appointment-schedulemange.php'; 
	}
    /**
	 * Astro Appointment Booking 
	 */
	public function Astro_appointment_booking(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/appointment/astro-appointment-bookings.php'; 
	}   
    /**
	 * Astro Appointment Payment Setting 
	 */
	public function Astro_appointment_paymentsetting(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/appointment/astro-appointment-paymentoption.php'; 
	} 
    /**
	 * Astro Appointment Form Setting
	 */
	public function Astro_appointment_formsetting(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/appointment/astro-appointment-formsetting.php'; 
	} 

	public function Astro_app_payment_save(){
		extract($_POST);
		 update_option( 'app_curreny_val', $app_curreny_val);
		 update_option( 'app_tax_title', $app_tax_title);
		 update_option( 'app_text_percent', $app_text_percent); 
		 echo esc_html__('Details has been Saved Success','astro'); 
	    wp_die();
	}  
    
	public function Astro_appointment_paymentdetail_save(){
		extract($_POST);
		 update_option( 'stripe_appointment_publishbale_key', $stripe_publishbale_key);
		 update_option( 'stripe_appointment_secret_key', $stripe_secret_key);
		 update_option( 'stripe_appointment_email', $stripe_email); 
		 update_option( 'stripe_appointment_success_url', $stripe_success_url);
		 update_option( 'stripe_appointment_cancel_url', $stripe_cancel_url); 
		 echo esc_html__('Details has been Saved Success','astro'); 
	    wp_die();
	}  
	
	public function Astro_app_razorpay_save(){
		extract($_POST);
		 update_option( 'app_razorpay_key', $app_razorpay_key);
		 update_option( 'app_razorpay_success_url', $app_razorpay_success_url);
		 update_option( 'app_razorpay_cancel_url', $app_razorpay_cancel_url);
		 echo esc_html__('Details has been Saved Success','astro'); 
	    wp_die();
	}  
	
	public function Astro_app_sms_save(){
		extract($_POST);
		 update_option( 'app_acsid', $app_acsid);
		 update_option( 'app_auth_token', $app_auth_token);
		 update_option( 'app_ac_phone', $app_ac_phone);
		 update_option( 'app_ac_phone', $app_ac_phone);
		 update_option( 'app_ac_mssid', $app_ac_mssid);
		 update_option( 'app_ac_msg', $app_ac_msg);
		 echo esc_html__('Details has been Saved Success','astro'); 
	    wp_die();
	}  
	
	/**
	 * Hotel Custom color Settings
	 */
	public function Astro_app_color_option_save(){
		extract($_POST);
		  update_option( 'primary_color', $primary_color);
		  update_option( 'gc_color', $gc_color);
		  update_option( 'gcc_color', $gcc_color); 
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die(); 
	}  
	
	/**
	 * Hotel Custom color Settings
	 */
	public function Astro_app_email_option_save(){
		extract($_POST);
		  update_option( 'app_email_h', $app_email_h);
		  update_option( 'app_email_sub', $app_email_sub);
		  update_option( 'app_email_content', $app_email_content); 
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die(); 
	}  

	/**
	 * Astro Appointment Custom Option Settings
	 */
	public function Astro_appointment_custom_option_save(){
		extract($_POST);  
		  update_option('appointment_confirmation_charge', $confirmation_charge);
		  update_option('appointment_display_currency', $display_currency);
		  update_option('appointment_booking_form_heading', $booking_form_heading); 
		  update_option('appointment_booking_review_heading', $booking_review_heading);
		  update_option('appointment_payment_form_heading', $payment_form_heading); 
		  update_option('appointment_booking_invoice_heading', $booking_invoice_heading);   
		  echo esc_html__('Details has been Saved Success','astro'); 
		wp_die(); 
	}   

    /**
	 * Astro Event Options
	 */
	public function Astro_cafe_option(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/event/astro-event.php';
	} 

	/**
	 * Astro Event Booking Mange
	 */ 
	public function Astro_cafe_booking_mange(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/event/astro-event-booking.php';
	} 
	/**
	 * Astro Event Payment Setting
	 */
	public function Astro_cafe_payment_setting(){
       require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/event/astro-event-payment.php';
	}
	/**
	 * Astro Event Form Setting
	 */
	public function Astro_cafe_form_setting(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/event/astro-event-form.php';
	} 

	/**
	 * Astro Social Share 
	 */
	public function Astro_social_share(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/astro-social-share.php'; 
	}

	/**
	 * Astro QR Code 
	 */
	public function Astro_qr_code(){
       require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/astro-qr-code.php'; 
	}
    
	/**
	 * Astro QR Code OPtion Data Save
	 */
    public function Astro_qr_code_save(){
        extract($_POST);
		  update_option('hl_qr_code_heading', $hl_qrinput_title);
		  update_option('hl_qr_contact_number', $hl_qrinput_number);
		  update_option('hl_qr_custom_url', $hl_qrtext_url); 
		wp_die();	
	}
  /**
	 * Handily handily free booking
	 */
	public function Astro_appointment_free_payment(){
    //extract($_POST);
    
    $booking_id = '';
    if(isset($_POST['booking_id'])):
     $booking_id =$_POST['booking_id'];
    endif;
    $booking_date = ''; 
    if(isset($_POST['cust_date'])):
     $booking_date = $_POST['cust_date'];
    endif;
    $booking_time = '';
    if(isset($_POST['appoint_time'])):
        $booking_time = $_POST['appoint_time'];
    endif;
    $tranx_amount = '';
    if(!empty($_POST['new_price'])):
	    $tranx_amount = $_POST['new_price'];
	endif;
	
    $user_id = '';
    $tranx_id= '123';
    $tranx_status ='succeeded';
    global $wpdb;
    $tablename = $wpdb->prefix. 'appointment_schedule_booked';
    $data=array(
        	'asb_user_id' => $user_id, 
            'asb_schedule_id' => $booking_id, 
            'asb_schedule_date' => $booking_date, 
            'asb_schedule_time' => $booking_time, 
            'asb_txnid' => $tranx_id, 
            'asb_payment_amount' => $tranx_amount, 
            'asb_payment_status' => $tranx_status, 
            'asb_timestamp' => date('Y-m-d H:i:s'), 
            'asb_customer_details'=> json_encode($_POST), 
            'asb_payment_getway' => 'Free', 
		   );
    $insert_db = $wpdb->insert( $tablename, $data,array('%d', '%d', '%s', '%s', '%s', '%d', '%s', '%s', '%s', '%s'));
    if($wpdb->insert_id){
        $success_url = get_option('stripe_success_url').'/?invoice='.base64_encode($wpdb->insert_id);
        $data = array('status' => 'true','massage'=>'Your Booking succesfull Done','success_url'=>$success_url);
    }else{ 
		$data = array('status' => 'false','massage'=>'Something Want to Wrong!');
	} 
    echo json_encode($data);
    wp_die(); 
	}


}  