const CACHE_NAME = "valvevantage-cache-v1";
const urlsToCache = [
  "/index.html",
  "/style.css",
  "/images/VV_Logo_4_3.png",
  "/images/hero.jpg",
  "/images/2_Valve_01.jpg",
  "/images/icons/android-chrome-192x192.png",
  "/images/icons/android-chrome-512x512.png"
];

self.addEventListener("install", (event) => {
  event.waitUntil(
    caches.open(CACHE_NAME).then((cache) => {
      return cache.addAll(urlsToCache);
    })
  );
});

self.addEventListener("fetch", (event) => {
  event.respondWith(
    caches.match(event.request).then((response) => {
      return response || fetch(event.request);
    })
  );
});
