<?php
/**
 * ResellerClub API Proxy
 * Handles domain availability checks securely from frontend
 */

header('Content-Type: application/json');

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method Not Allowed']);
    exit;
}

// Load POST JSON
$input = json_decode(file_get_contents('php://input'), true);
if (!isset($input['action']) || $input['action'] !== 'checkDomain' || empty($input['domain'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
    exit;
}

// Sanitize domain
$domain = strtolower(trim($input['domain']));
if (!preg_match('/^([a-z0-9\-]+\.)+[a-z]{2,}$/', $domain)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid domain format']);
    exit;
}

// Split domain into name + tld
$parts = explode('.', $domain, 2);
$sld = $parts[0]; // second-level domain
$tld = $parts[1]; // top-level domain

// API Credentials — replace with real values
$reseller_id = 'YOUR_RESELLER_ID';
$api_key     = 'YOUR_API_KEY';

// API URL
$url = "https://httpapi.com/api/domains/available.json?auth-userid={$reseller_id}&api-key={$api_key}&domain-name={$sld}&tlds={$tld}";

// cURL Request
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

if (!$response) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'No response from ResellerClub API']);
    exit;
}

$data = json_decode($response, true);
$key = $sld . '.' . $tld;

if (isset($data[$key])) {
    echo json_encode([
        'status' => 'success',
        'domain' => $key,
        'available' => $data[$key]['status'] === 'available',
        'classkey' => $data[$key]['classkey'],
        'action' => $data[$key]['status']
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'API response invalid', 'api_response' => $data]);
}
