<?php
/**
 * PayPal Payment Webhook Handler
 * Handles POSTed payment info from JS after onApprove()
 */

header('Content-Type: application/json');

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method Not Allowed']);
    exit;
}

// Get raw POST body
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

if (!$data || !isset($data['orderID'], $data['payerID'], $data['paymentDetails'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid payload']);
    exit;
}

// Sanitize and extract data
$order_id     = preg_replace('/[^a-zA-Z0-9\-]/', '', $data['orderID']);
$payer_id     = preg_replace('/[^a-zA-Z0-9\-]/', '', $data['payerID']);
$details      = $data['paymentDetails'];

// Optional: log to file for debug
$log_path = __DIR__ . '/paypal-log.txt';
file_put_contents($log_path, date('[Y-m-d H:i:s] ') . json_encode($data) . PHP_EOL, FILE_APPEND);

// OPTIONAL: Save to database or email (future step)

// Respond to frontend
echo json_encode([
    'status' => 'success',
    'message' => 'Payment data received',
    'order_id' => $order_id,
    'payer_id' => $payer_id
]);
