<?php
/**
 * cPanel / WHM API Proxy
 * For internal panel status checks or future account operations
 */

header('Content-Type: application/json');

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method Not Allowed']);
    exit;
}

// Load and decode raw JSON body
$input = json_decode(file_get_contents('php://input'), true);

// Validate and route action
if (!isset($input['action'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Missing action']);
    exit;
}

switch ($input['action']) {

    case 'status':
        // TODO: Replace this block with live WHM/cPanel API checks
        echo json_encode([
            'status' => 'success',
            'message' => 'WHM panel is reachable and responding (mock response).',
            'timestamp' => date('Y-m-d H:i:s')
        ]);
        break;

    default:
        echo json_encode([
            'status' => 'error',
            'message' => 'Unknown action: ' . htmlspecialchars($input['action'])
        ]);
        break;
}
