<?php
header('Content-Type: application/json');

// Basic protection: allow only POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method Not Allowed']);
    exit;
}

// Sanitize inputs
$name    = trim(filter_input(INPUT_POST, 'name', FILTER_SANITIZE_STRING));
$email   = trim(filter_input(INPUT_POST, 'email', FILTER_VALIDATE_EMAIL));
$message = trim(filter_input(INPUT_POST, 'message', FILTER_SANITIZE_STRING));

if (!$name || !$email || !$message) {
    echo json_encode(['status' => 'error', 'message' => 'All fields are required.']);
    exit;
}

// Spam protection: basic length + forbidden words
if (strlen($message) < 10 || stripos($message, 'http') !== false) {
    echo json_encode(['status' => 'error', 'message' => 'Suspicious message detected.']);
    exit;
}

// Simulate email delivery (replace with mail() or SMTP logic later)
$admin_email = 'support@smartersweb.com';
$subject = "New Contact Request from $name";
$body    = "Name: $name\nEmail: $email\nMessage:\n$message";

// mail($admin_email, $subject, $body); // Uncomment when SMTP configured

// Success response
echo json_encode(['status' => 'success', 'message' => 'Thank you! Your message has been sent.']);
