<?php
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);
$name = trim($data['name'] ?? '');
$email = trim($data['email'] ?? '');
$password = trim($data['password'] ?? '');

if (!$name || !$email || !$password) {
    echo json_encode(['status' => 'error', 'message' => 'All fields are required.']);
    exit;
}

$users_file = __DIR__ . '/users.json';
$users = json_decode(file_get_contents($users_file), true);

// Check for existing email
foreach ($users as $user) {
    if ($user['email'] === $email) {
        echo json_encode(['status' => 'error', 'message' => 'Email already exists.']);
        exit;
    }
}

// Add new user
$new_user = [
    'id' => count($users) + 1,
    'role' => 'user',
    'name' => $name,
    'email' => $email,
    'password' => password_hash($password, PASSWORD_DEFAULT)
];

$users[] = $new_user;
file_put_contents($users_file, json_encode($users, JSON_PRETTY_PRINT));

echo json_encode(['status' => 'success', 'message' => 'Registration complete.', 'user' => $new_user]);
