<?php
session_start();
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);
$email = trim($data['email'] ?? '');
$password = trim($data['password'] ?? '');

if (!$email || !$password) {
    echo json_encode(['status' => 'error', 'message' => 'Email and password required.']);
    exit;
}

$users = json_decode(file_get_contents(__DIR__ . '/users.json'), true);
foreach ($users as $user) {
    if ($user['email'] === $email && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['role'] = $user['role'];
        $_SESSION['name'] = $user['name'];
        echo json_encode(['status' => 'success', 'message' => 'Login successful', 'user' => $user]);
        exit;
    }
}

echo json_encode(['status' => 'error', 'message' => 'Invalid email or password.']);
