<?php
header('Content-Type: application/json');

// Simulate session check or token-based auth
session_start();
$auth = isset($_SESSION['user_id']) || (isset($_GET['token']) && $_GET['token'] === 'demo-token');

if (!$auth) {
    http_response_code(401);
    echo json_encode(['status' => 'unauthorized', 'message' => 'Authentication required']);
    exit;
}

// Simulated dashboard data (in production, pull from DB)
$response = [
    'status' => 'success',
    'data' => [
        'active_services' => 4,
        'pending_invoices' => 2,
        'total_domains' => 7,
        'support_tickets' => 1,
        'next_due' => '2025-06-10',
        'account_name' => 'John Doe'
    ]
];

echo json_encode($response);
