// ResellerClub Domain Lookup & Integration

async function searchDomain(domain) {
  try {
    const res = await fetch('/dev-html/smartersweb-host/backend/api/resellerclub.php?domain=' + domain);
    const data = await res.json();
    if (data.available) {
      document.getElementById('domain-result').innerHTML = '<span class="success">Domain is available!</span>';
    } else {
      document.getElementById('domain-result').innerHTML = '<span class="error">Domain not available.</span>';
    }
  } catch (err) {
    console.error('ResellerClub error:', err);
  }
}

document.addEventListener('DOMContentLoaded', () => {
  const domainForm = document.getElementById('domain-check-form');
  if (domainForm) {
    domainForm.addEventListener('submit', function (e) {
      e.preventDefault();
      const domain = document.getElementById('domain-input').value;
      if (domain.length > 3) {
        searchDomain(domain);
      }
    });
  }
});
