// PayPal Button Integration - Canada Base

document.addEventListener('DOMContentLoaded', function () {
  if (typeof paypal !== 'undefined') {
    paypal.Buttons({
      style: {
        layout: 'vertical',
        color: 'blue',
        shape: 'rect',
        label: 'paypal'
      },
      createOrder: function (data, actions) {
        return actions.order.create({
          purchase_units: [{
            amount: {
              value: '49.99',
              currency_code: 'CAD'
            }
          }]
        });
      },
      onApprove: function (data, actions) {
        return actions.order.capture().then(function (details) {
          alert('Payment completed by ' + details.payer.name.given_name);
        });
      }
    }).render('#paypal-button-container');
  }
});
