// Dashboard JS: Tab Control + API Fetch

document.addEventListener('DOMContentLoaded', () => {
  const tabs = document.querySelectorAll('.dashboard-tab');
  const panes = document.querySelectorAll('.dashboard-pane');

  tabs.forEach(tab => {
    tab.addEventListener('click', () => {
      const target = tab.getAttribute('data-target');

      tabs.forEach(t => t.classList.remove('active'));
      tab.classList.add('active');

      panes.forEach(p => p.classList.remove('active'));
      document.getElementById(target).classList.add('active');
    });
  });

  // Load account info
  fetch('/dev-html/smartersweb-host/backend/api/user.php')
    .then(res => res.json())
    .then(data => {
      document.getElementById('user-name').textContent = data.name;
      document.getElementById('user-email').textContent = data.email;
    });

  // Load services
  fetch('/dev-html/smartersweb-host/backend/api/services.php')
    .then(res => res.json())
    .then(data => {
      const servicesList = document.getElementById('services-list');
      servicesList.innerHTML = '';
      data.forEach(service => {
        const li = document.createElement('li');
        li.textContent = service.name + ' – ' + service.status;
        servicesList.appendChild(li);
      });
    });

  // Load payments
  fetch('/dev-html/smartersweb-host/backend/api/payments.php')
    .then(res => res.json())
    .then(data => {
      const paymentsTable = document.getElementById('payments-table');
      paymentsTable.innerHTML = '<tr><th>Date</th><th>Amount</th><th>Status</th></tr>';
      data.forEach(payment => {
        const tr = document.createElement('tr');
        tr.innerHTML = `<td>${payment.date}</td><td>${payment.amount}</td><td>${payment.status}</td>`;
        paymentsTable.appendChild(tr);
      });
    });
});
