<?php
require_once '../app/Config/Database.php';

class Form {
    private $conn;
    private $table_name = "forms";

    public $id;
    public $user_id;
    public $form_name;
    public $form_endpoint;
    public $form_config;
    public $is_active;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  SET user_id=:user_id, form_name=:form_name, 
                      form_endpoint=:form_endpoint, form_config=:form_config";

        $stmt = $this->conn->prepare($query);

        $this->form_name = htmlspecialchars(strip_tags($this->form_name));
        $this->form_endpoint = $this->generateEndpoint();
        $this->form_config = json_encode($this->form_config);

        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":form_name", $this->form_name);
        $stmt->bindParam(":form_endpoint", $this->form_endpoint);
        $stmt->bindParam(":form_config", $this->form_config);

        if($stmt->execute()) {
            $this->id = $this->conn->lastInsertId();
            return true;
        }
        return false;
    }

    public function getByUserId($user_id) {
        $query = "SELECT * FROM " . $this->table_name . " 
                  WHERE user_id = :user_id AND is_active = 1 
                  ORDER BY created_at DESC";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':user_id', $user_id);
        $stmt->execute();

        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getByEndpoint($endpoint) {
        $query = "SELECT * FROM " . $this->table_name . " 
                  WHERE form_endpoint = :endpoint AND is_active = 1 LIMIT 1";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':endpoint', $endpoint);
        $stmt->execute();

        if($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->id = $row['id'];
            $this->user_id = $row['user_id'];
            $this->form_name = $row['form_name'];
            $this->form_endpoint = $row['form_endpoint'];
            $this->form_config = json_decode($row['form_config'], true);
            return true;
        }
        return false;
    }

    private function generateEndpoint() {
        return uniqid('sf_', true);
    }
}
?>
