<?php
require_once __DIR__ . '/config.php';

$isLive = STRIPE_LIVE_MODE;
$products = $isLive ? json_decode(STRIPE_LIVE_PRICES, true) : json_decode(STRIPE_TEST_PRICES, true);

// Map plan keys for the toggle JS logic
$starter_monthly_id   = array_search('Starter Monthly', $products);
$starter_quarterly_id = array_search('Starter Yearly', $products);
$premium_monthly_id   = array_search('Premium Monthly', $products);
$premium_quarterly_id = array_search('Premium Yearly', $products);

// Prices for display (customize if you want different than Stripe)
$starterMonthlyPrice = '$54.99';
$starterQuarterlyPrice = '$49.99';
$premiumMonthlyPrice = '$99.99';
$premiumQuarterlyPrice = '$89.99';

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Pricing | CanMan Solutions</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --blue: #0081e8;
      --green: #7ac053;
      --light: #f8fafc;
      --grey: #e1e7ef;
      --text: #223047;
      --card-radius: 24px;
    }
    body {
      margin: 0;
      font-family: 'Inter', Arial, sans-serif;
      background: var(--light);
      color: var(--text);
    }
    .pricing-toggle-row {
      display: flex;
      justify-content: center;
      align-items: center;
      margin: 48px 0 36px 0;
      gap: 18px;
      font-size: 1.13rem;
    }
    .pricing-toggle {
      position: relative;
      width: 76px;
      height: 34px;
      background: var(--grey);
      border-radius: 20px;
      display: inline-block;
      cursor: pointer;
      transition: background 0.25s;
    }
    .pricing-toggle input {
      display: none;
    }
    .pricing-toggle-slider {
      position: absolute;
      top: 2px; left: 2px;
      width: 30px; height: 30px;
      background: var(--blue);
      border-radius: 50%;
      transition: left 0.25s;
    }
    .pricing-toggle input:checked + .pricing-toggle-slider {
      left: 44px;
      background: var(--green);
    }
    .pricing-cards {
      display: flex;
      justify-content: center;
      gap: 2.2rem;
      flex-wrap: wrap;
      max-width: 1200px;
      margin: 0 auto 22px auto;
    }
    .pricing-card {
      background: #fff;
      border-radius: var(--card-radius);
      box-shadow: 0 8px 32px rgba(0,36,54,0.11), 0 1.5px 8px rgba(45,55,72,0.09);
      padding: 2.3rem 2rem 2.1rem 2rem;
      flex: 1 1 300px;
      max-width: 350px;
      min-width: 260px;
      display: flex;
      flex-direction: column;
      align-items: flex-start;
      margin-bottom: 32px;
      transition: box-shadow 0.25s;
    }
    .pricing-card.enterprise {
      background: var(--blue);
      color: #fff;
      box-shadow: 0 12px 32px rgba(0,129,232,0.17), 0 1.5px 8px rgba(45,55,72,0.09);
      position: relative;
      z-index: 1;
    }
    .pricing-card .plan-title {
      font-size: 1.3rem;
      font-weight: 700;
      margin-bottom: 7px;
    }
    .pricing-card .plan-price {
      font-size: 2.5rem;
      font-weight: 700;
      color: var(--blue);
      margin-bottom: 0.2rem;
    }
    .pricing-card .plan-price .price-period {
      font-size: 1.1rem;
      font-weight: 400;
      color: #8290b2;
    }
    .pricing-card .plan-subprice {
      font-size: 1.02rem;
      font-weight: 600;
      color: #1bb259;
      margin-bottom: 9px;
    }
    .pricing-card .plan-desc {
      font-size: 1.06rem;
      margin-bottom: 18px;
      color: #444f5a;
    }
    .pricing-card.enterprise .plan-title,
    .pricing-card.enterprise .plan-desc,
    .pricing-card.enterprise .plan-features li {
      color: #fff;
    }
    .plan-button {
      width: 100%;
      display: block;
      margin: 0 0 18px 0;
      padding: 0.9rem 0;
      border: none;
      border-radius: 18px;
      background: var(--green);
      color: #fff;
      font-weight: 700;
      font-size: 1.16rem;
      cursor: pointer;
      text-align: center;
      box-shadow: 0 2px 8px rgba(32,183,66,0.10);
      transition: background 0.2s;
      text-decoration: none;
      letter-spacing: 0.01em;
    }
    .pricing-card.enterprise .plan-button {
      background: #fff;
      color: var(--blue);
      border: none;
      font-weight: 600;
    }
    .plan-button:hover {
      background: #67a644;
    }
    .pricing-card.enterprise .plan-button:hover {
      background: #d3ecfb;
    }
    .plan-features {
      list-style: none;
      padding: 0;
      margin: 0;
      margin-top: 6px;
    }
    .plan-features li {
      font-size: 1rem;
      margin-bottom: 8px;
      display: flex;
      align-items: center;
      color: #1a2b44;
    }
    .plan-features .checkmark {
      color: #1bb259;
      margin-right: 8px;
      font-size: 1.1em;
    }
    .pricing-card.enterprise .plan-features .checkmark {
      color: #bfffdc;
    }
    .promo-note {
      text-align: center;
      margin: 16px auto 0 auto;
      color: #13ad59;
      font-size: 0.96rem;
      max-width: 700px;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 7px;
    }
    .promo-note svg {
      vertical-align: middle;
      font-size: 1.13em;
    }
    @media (max-width: 1000px) {
      .pricing-cards { gap: 1rem; }
      .pricing-card { padding: 2rem 1.2rem; }
    }
    @media (max-width: 820px) {
      .pricing-cards { flex-direction: column; align-items: center; }
      .pricing-card { max-width: 500px; min-width: 0; width: 95%; }
    }
  </style>
</head>
<body>
  <div class="pricing-toggle-row">
    <span>Quarterly Discount</span>
    <label class="pricing-toggle">
      <input type="checkbox" id="subscription-toggle">
      <span class="pricing-toggle-slider"></span>
    </label>
    <span>Monthly Subscription</span>
  </div>
  <div class="pricing-cards">
    <!-- Starter Card -->
    <div class="pricing-card" id="starter-card">
      <div class="plan-title">Starter</div>
      <div class="plan-price" id="starter-price"><?= $starterQuarterlyPrice ?><span class="price-period">/month</span></div>
      <div class="plan-subprice" id="starter-subprice">You pay $149.97 every three months</div>
      <div class="plan-desc">Perfect for small households with standard trash needs</div>
      <a href="checkout.php?price_id=<?= htmlspecialchars($starter_quarterly_id) ?>" class="plan-button" id="starter-btn">Start Now</a>
      <ul class="plan-features">
        <li><span class="checkmark">✔</span> One Collection Day Per Week</li>
        <li><span class="checkmark">✔</span> Service Up To 3 Bins</li>
        <li><span class="checkmark">✔</span> Bins Delivered To Curb And Back</li>
        <li><span class="checkmark">✔</span> 24/7 Support</li>
      </ul>
    </div>
    <!-- Premium Card -->
    <div class="pricing-card" id="premium-card">
      <div class="plan-title">Premium</div>
      <div class="plan-price" id="premium-price"><?= $premiumQuarterlyPrice ?><span class="price-period">/month</span></div>
      <div class="plan-subprice" id="premium-subprice">You pay $269.97 every three months</div>
      <div class="plan-desc">Ideal for larger households or those with higher trash volumes</div>
      <a href="checkout.php?price_id=<?= htmlspecialchars($premium_quarterly_id) ?>" class="plan-button" id="premium-btn">Start Now</a>
      <ul class="plan-features">
        <li><span class="checkmark">✔</span> One Collection Day Per Week</li>
        <li><span class="checkmark">✔</span> Service Up To 6 Bins</li>
        <li><span class="checkmark">✔</span> Bins Delivered To Curb And Back</li>
        <li><span class="checkmark">✔</span> 24/7 Support</li>
      </ul>
    </div>
    <!-- Enterprise Card -->
    <div class="pricing-card enterprise">
      <div class="plan-title">Enterprise</div>
      <div style="font-size:1.55rem;font-weight:700;margin-bottom:5px;">Custom Billing</div>
      <div style="font-size:1.05rem;font-weight:600;margin-bottom:10px;">For +10 Properties</div>
      <div class="plan-desc">Perfect for businesses and organizations that require large-scale waste management solutions.</div>
      <a href="mailto:sales@canmansolutions.com?subject=Enterprise%20Plan%20Inquiry" class="plan-button" target="_blank">Let's Talk</a>
      <ul class="plan-features">
        <li><span class="checkmark">✔</span> One Collection Day Per Week</li>
        <li><span class="checkmark">✔</span> Bins Delivered To Curb And Back</li>
        <li><span class="checkmark">✔</span> 24/7 Support</li>
      </ul>
    </div>
  </div>
  <div class="promo-note" id="promo-note">
    <svg width="18" height="18" fill="none"><path d="M9 17c4.418 0 8-3.582 8-8s-3.582-8-8-8-8 3.582-8 8 3.582 8 8 8zm0-12v3m0 4h.01" stroke="#1bb259" stroke-width="2" stroke-linecap="round"/></svg>
    Promo Codes Only Applicable to Quarterly Plans
  </div>
  <script>
    // Set plan price IDs from PHP
    const starterMonthlyLink = "checkout.php?price_id=<?= htmlspecialchars($starter_monthly_id) ?>";
    const starterQuarterlyLink = "checkout.php?price_id=<?= htmlspecialchars($starter_quarterly_id) ?>";
    const premiumMonthlyLink = "checkout.php?price_id=<?= htmlspecialchars($premium_monthly_id) ?>";
    const premiumQuarterlyLink = "checkout.php?price_id=<?= htmlspecialchars($premium_quarterly_id) ?>";

    // Pricing/Copy for monthly and quarterly
    const pricing = {
      starter: {
        monthly: {
          price: "<?= $starterMonthlyPrice ?>",
          subprice: "",
        },
        quarterly: {
          price: "<?= $starterQuarterlyPrice ?>",
          subprice: "You pay $149.97 every three months",
        }
      },
      premium: {
        monthly: {
          price: "<?= $premiumMonthlyPrice ?>",
          subprice: "",
        },
        quarterly: {
          price: "<?= $premiumQuarterlyPrice ?>",
          subprice: "You pay $269.97 every three months",
        }
      }
    };

    const toggle = document.getElementById('subscription-toggle');
    const starterPrice = document.getElementById('starter-price');
    const starterSubprice = document.getElementById('starter-subprice');
    const starterBtn = document.getElementById('starter-btn');
    const premiumPrice = document.getElementById('premium-price');
    const premiumSubprice = document.getElementById('premium-subprice');
    const premiumBtn = document.getElementById('premium-btn');
    const promoNote = document.getElementById('promo-note');

    function updatePrices() {
      const isQuarterly = !toggle.checked;
      // Starter
      starterPrice.innerHTML = isQuarterly ?
        pricing.starter.quarterly.price + '<span class="price-period">/month</span>' :
        pricing.starter.monthly.price + '<span class="price-period">/month</span>';
      starterSubprice.textContent = isQuarterly ?
        pricing.starter.quarterly.subprice : pricing.starter.monthly.subprice;
      starterBtn.href = isQuarterly ? starterQuarterlyLink : starterMonthlyLink;
      // Premium
      premiumPrice.innerHTML = isQuarterly ?
        pricing.premium.quarterly.price + '<span class="price-period">/month</span>' :
        pricing.premium.monthly.price + '<span class="price-period">/month</span>';
      premiumSubprice.textContent = isQuarterly ?
        pricing.premium.quarterly.subprice : pricing.premium.monthly.subprice;
      premiumBtn.href = isQuarterly ? premiumQuarterlyLink : premiumMonthlyLink;
      // Promo note
      promoNote.style.display = isQuarterly ? 'flex' : 'none';
    }
    // Set initial
    updatePrices();
    toggle.addEventListener('change', updatePrices);
  </script>
</body>
</html>