<?php
$USER = 'admin';
$PASS = 'changeme';
if (!isset($_SERVER['PHP_AUTH_USER']) ||
    $_SERVER['PHP_AUTH_USER'] !== $USER ||
    $_SERVER['PHP_AUTH_PW'] !== $PASS) {
  header('WWW-Authenticate: Basic realm="Admin"');
  header('HTTP/1.0 401 Unauthorized');
  echo 'Auth Required';
  exit;
}

require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/config.php';

$isLive = STRIPE_LIVE_MODE;
$stripeSecretKey = $isLive ? STRIPE_LIVE_SECRET : STRIPE_TEST_SECRET;
$products = $isLive ? json_decode(STRIPE_LIVE_PRICES, true) : json_decode(STRIPE_TEST_PRICES, true);

\Stripe\Stripe::setApiKey($stripeSecretKey);

$since = strtotime('-60 days');
$found = [];

$paymentIntents = \Stripe\PaymentIntent::all([
  'created' => ['gte' => $since],
  'limit' => 100,
]);

foreach ($paymentIntents->autoPagingIterator() as $pi) {
    if ($pi->status === 'requires_capture' && isset($pi->charges->data[0])) {
        $sessions = \Stripe\Checkout\Session::all([
            'payment_intent' => $pi->id,
            'limit' => 1,
        ]);
        if (count($sessions->data)) {
            $session = $sessions->data[0];
            $line_items = \Stripe\Checkout\Session::retrieve($session->id, ['expand' => ['line_items']])->line_items;
            $price_id = $line_items->data[0]->price->id ?? '';
            if (isset($products[$price_id])) {
                $found[] = [
                    'pi_id' => $pi->id,
                    'amount' => number_format($pi->amount / 100, 2),
                    'currency' => strtoupper($pi->currency),
                    'customer_email' => $session->customer_details->email ?? '—',
                    'product' => $products[$price_id],
                    'status' => $pi->status,
                ];
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Stripe Admin - Authorized Payments</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { font-family: 'Segoe UI',sans-serif; background:#f7fafb; margin:0;}
    h1 { text-align:center; color:#216e3a; }
    table { border-collapse: collapse; margin: 40px auto; background: #fff; box-shadow:0 4px 24px #ccc5; min-width:720px;}
    th, td { padding: 12px 18px; border-bottom: 1px solid #e2e2e2;}
    th { background: #ecfaf1; }
    .btn { background: #34935b; color: #fff; border: none; padding: 8px 18px; border-radius: 5px; cursor: pointer;}
    .btn[disabled] { background: #aaa; cursor: default;}
  </style>
</head>
<body>
  <h1>Stripe Payments Awaiting Capture<br><small style="font-size:16px;font-weight:400;"><?php echo $isLive ? "LIVE MODE" : "TEST MODE"; ?></small></h1>
  <table>
    <tr>
      <th>Product</th>
      <th>Customer Email</th>
      <th>Amount</th>
      <th>Status</th>
      <th>Action</th>
    </tr>
    <?php if (!$found): ?>
      <tr><td colspan="5" style="text-align:center;color:#888;">No authorized (uncaptured) payments found.</td></tr>
    <?php else: foreach($found as $row): ?>
      <tr>
        <td><?= htmlspecialchars($row['product']) ?></td>
        <td><?= htmlspecialchars($row['customer_email']) ?></td>
        <td><?= $row['amount'] . ' ' . $row['currency'] ?></td>
        <td><?= htmlspecialchars($row['status']) ?></td>
        <td>
          <button class="btn" onclick="capture('<?= $row['pi_id'] ?>', this)">Capture</button>
        </td>
      </tr>
    <?php endforeach; endif; ?>
  </table>
  <script>
    function capture(pi, btn) {
      if(!confirm('Capture this payment?')) return;
      btn.disabled = true;
      fetch('admin-capture.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: 'pi_id=' + encodeURIComponent(pi)
      }).then(r=>r.json()).then(data=>{
        if(data.success){
          btn.innerText = "Captured";
          btn.style.background="#aaa";
        }else{
          alert('Capture failed: ' + data.error);
          btn.disabled = false;
        }
      });
    }
  </script>
</body>
</html>