<?php
require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/config.php';

$isLive = STRIPE_LIVE_MODE;
$stripeSecretKey = $isLive ? STRIPE_LIVE_SECRET : STRIPE_TEST_SECRET;
\Stripe\Stripe::setApiKey($stripeSecretKey);

header('Content-Type: application/json');
$pi_id = $_POST['pi_id'] ?? '';
if(!$pi_id) {
    echo json_encode(['success'=>false,'error'=>'Missing pi_id']);
    exit;
}
try {
    $intent = \Stripe\PaymentIntent::retrieve($pi_id);
    if ($intent->status !== 'requires_capture') throw new Exception('Not authorized or already captured.');
    $intent->capture();
    echo json_encode(['success'=>true]);
} catch(Exception $e){
    echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}
